		NAME	DKXPAND
		PAGE	63,110
		TITLE	.DKXPAND - Expand possible dead key sequences [sk]

DATA		SEGMENT	PUBLIC	BYTE
		ASSUME	DS:DATA
		INCLUDE	PUBLICS.EQU

		EXTRN	DKXPND:WORD, DKSLCT:WORD, DKXOFS:WORD, DKXCNT:WORD

DATA		ENDS

CODE		SEGMENT	PUBLIC	BYTE
		ASSUME	CS:CODE

; DK_CHECK: 	Return NZ if dead key expansion is in progress

		PUBLIC	DK_CHECK	; Check for possible expansion
DK_CHECK	PROC	NEAR		;
		PUSH	BX		;

		MOV	BX,DKXCNT	; See how many keys are left
		TEST	BX,BX		; Zero is none!

		POP	BX		; Restore used register
		RET			;

DK_CHECK	ENDP
		PAGE

; DK_START:	Enter with key code in AX.  Dead key expansion will begin
;		if AX contains key in SELECT table
	
		PUBLIC	DK_START	; Give dead keys a chance
DK_START	PROC	NEAR		;
		PUSH	BX		;
		PUSH	CX		;

		MOV	CX,DKMAX	; Number of possible dead keys
		MOV	BX,OFFSET DATA:DKSLCT

DK_START_SCAN:	CMP	AX,[BX]		; Is this our key?
		JZ	DK_START_FOUND	; Yes, set flags & exit
		ADD	BX,2		; No, try next table entry
		LOOP	DK_START_SCAN	; Until found or out of counts

		XOR	BX,BX		; Set zero flag for no new expansion...

; Return zero if no match, non-zero if expansion started

DK_START_EXIT:	POP	CX		; Restore used registers
		POP	BX		;
		RET			;

DK_START_FOUND:	SUB	BX,OFFSET DATA:DKSLCT ; Get key number
		MOV	CL,3-1		; 
		SHL	BX,CL		; sizeof(eccode) * 4

		ADD	BX,OFFSET DATA:DKXPND
		MOV	DKXOFS,BX	; Save pointer to expansion string
		MOV	DKXCNT,4	; Words in possible expansion

		MOV	BX,[BX]		; Make sure this isn't a dud
		TEST	BX,BX		;
		JNZ	DK_START_EXIT	; All's well, non-zero code

		MOV	DKXCNT,0	; Bogus entry, kill request
		JMP	DK_START_EXIT	; And exit.

DK_START	ENDP
		PAGE

		PUBLIC	DK_EXPAND
DK_EXPAND	PROC	NEAR		; Get code from expansion
		PUSH	BX		;
		MOV	BX,DKXOFS	; Where chars are
		MOV	AX,[BX]		; Fetch the character

		ADD	BX,2		; Next location
		MOV	DKXOFS,BX	; Save this number in any case
		DEC	DKXCNT		; Count down possible bytes

		CMP	WORD PTR [BX],0	; Is this the end?
		JNZ	DK_EXPAND_EXIT	; No, nothing special

		MOV	DKXCNT,0	; Yes, force down the count

DK_EXPAND_EXIT:	POP	BX		; Restore used register
		RET			;

DK_EXPAND	ENDP

CODE		ENDS

		END
