/*	Convergent Technologies - System V - Sep 1984	*/
/*	"@(#)tsioctl.h	1.2"	*/


/*	Convergent Technologies - System V - Sept 1984	*/
/*	"@(#)tsioctl.h	1.4"	*/

/*  	streaming tape ioctls */
#ifndef tsioctl_h
#define tsioctl_h

#define	TPIOCTYPE	0xff00		/* same as TTY IOCTYPE - identifies
					   type as tape, returns TPIOC */

/* ioctl commands derived from sys/gdioctl.h */
#define	TPIOC		( 'S' << 8)
#define	TPGETA		(TPIOC|1)	/* get tpctl structure */
#define	TPSETA		(TPIOC|2)	/* set tpctl structure */
#define	TPCMD		(TPIOC|3)	/* send auxilliary tape command */
#define TPINTR	   	(TPIOC|7)	/* simulate tape interrupt */

/* tpcmd subcommands */
#define SENSE	1
#define RESET	2
#define CLR	3
#define WFM	4
#define RFM	5
#define REWIND	6
#define ERASE	7
#define RETENT  8

struct tpio {
	unsigned short status[6];
	short ctcs;
	short cstate;
	short opens;
	int   reads;
	int   writes;
	int   bcnt;
	short retries;
	short under;
} cb;

#endif tsioctl_h
