/*	Convergent Technologies - System V - Mar 1985	*/
/*	"@(#)ts.h	1.2"	*/


#ifndef ts_def
/* qici control registers */
#define SOC 0xc79900    /* wo  cr :send other command */

#define SRC 0xc7990c    /* wo     :send read command */
#define SWC 0xc7990e	/* wo     :send write command */
#define RST 0xc79910    /* wo  mr :reset controller */
#define RCS 0xc79914    /* ro  sr :read control signals */
#define ICM 0xc79916    /* wo  mr :set interrupt control mask */
#define RSW 0xc79918    /* ro  dr :read status words */

#define RWD 0xc7991c    /* ro  dr :read a word of data */
#define WWD 0xc7991e    /* wo  dr :write a word of data */

/* control signals bits and values */
#define ACTIVE 0	/* signals are low true */

#define READY  1	/* bit to test controller signals for ready */
#define EXCEPT 2	/* bit to test controller signals for exception */
#define WTRDY  4	/* bit to test controller for write ready */ 
#define RDRDY  8	/* bit to test controller for read ready */ 

#define ENABLE 0x38	/* enable interrupts, both exception and ready */

/* tape commands */
#define Q_SELECT	0		/* add select and drive # */
#define Q_BOT		0x21	
#define Q_ERASE		0x22
#define Q_RETEN		0x24
#define Q_WRITE		0x40
#define Q_WTFM		0x60
#define Q_READ		0x80
#define Q_RDFM		0xa0
#define Q_STATUS	0xc0

static unsigned short q_cmds[] = {
	0,Q_STATUS,0,0,Q_WTFM,Q_RDFM,Q_BOT,Q_ERASE,Q_RETEN
};

/* tp_flag bits */
#define TINIT   1
#define TOPEN   2

#define TPPRI 	(PZERO+5)

/* tp_state modes */
#define RDY_MODE 	0	/* controller should be ready for command */
#define IO_CMD  	1 	/* have sent an io command */
#define WT_MODE  	2	/* doing io */
#define RD_MODE	  	4	
#define IO_MODE		(WT_MODE | RD_MODE)	/* combined read/write mode */
#define RD_WAIT		8	/* data has arrived from tape */	

#define CMD_MODE 	0x20	/* have sent position, waiting for interrupt */
#define FM_ERR 		0x40	/* fm detected */
#define TP_ERR		0x80

/* tape debug log functions */
#ifndef LOG_TS
#define tp_log(x,y,x)
#define tp_dump()
#endif

#define ts_def
#endif
