/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)text.h	1.4"	*/

#ifndef text_h
#define text_h

#include <sys/types.h>
#include <sys/proc.h>
#include <sys/inode.h>

/*
 * Text structure.
 * One allocated per pure procedure on swap device.
 * Manipulated by text.c
 */
#define	NXDAD	16		/* param.h:MAXUMEM / dmap.h:DMTEXT */

struct text
{
	ushort	x_daddr[NXDAD];	/* click addresses of DMTEXT-page segments */
					/* (relative to swplo) */
	ushort	x_ptdaddr;	/* disk address of page table */
	ushort	x_size;		/* size (clicks) */
	struct proc *x_caddr;	/* ptr to linked proc, if loaded */
	struct inode *x_iptr;	/* inode of prototype */
	short	x_rssize;
	short	x_swrss;
	char	x_count;	/* reference count */
	char	x_ccount;	/* number of loaded references */
	char	x_flag;		/* traced, written flags */
	char	x_slptime;
	short	x_poip;		/* page out in progress count */
};

#ifdef	KERNEL
extern struct text text[];
#endif

#define	XTRC	01		/* Text may be written, exclusive use */
#define	XWRIT	02		/* Text written into, must swap out */
#define	XLOAD	04		/* Currently being read from file */
#define	XLOCK	010		/* Being swapped in or out */
#define	XWANT	020		/* Wanted for swapping */
#define	XPAGI	040		/* Page in on demand from inode */
#define XSWPIN	0100		/* Text is being swapped in */
#endif
