/*	Convergent Technologies - System V - Apr 1984	*/
/*	"@(#)spl.h	1.1"	*/

/*
 * spl.h - provide assembly macros for spls
 * These come in two flavors:
 *	SPLx - same as splx except puts previous sr into variable s
 *	VSPLx- same as (void) splx; i.e. no return value
 * SPLX restores previous spl level by using s
 *
 * NOTE: s is declared in macro SDEC as a auto short; It should not be a
 * register variable as that will require more space and time
 */
#ifndef spl_h
#define spl_h

extern ushort __sr;
#define SDEC	auto ushort s

#define SPL7\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	}

#define SPL6\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFEFF, __sr	| then down to level 6");\
	}

#define SPL5\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFDFF, __sr	| then down to level 5");\
	}

#define SPL4\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFCFF, __sr	| then down to level 4");\
	}

#define SPL3\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFBFF, __sr	| then down to level 3");\
	}

#define SPL2\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFAFF, __sr	| then down to level 2");\
	}

#define SPL1\
	{s = __sr;\
	asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xF9FF, __sr	| then down to level 1");\
	}

#define SPL0\
	{s = __sr;\
	asm("andw	#0xF8FF, __sr	| down to level 0");\
	}

#define VSPL7\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	}

#define VSPL6\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFEFF, __sr	| then down to level 6");\
	}

#define VSPL5\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFDFF, __sr	| then down to level 5");\
	}

#define VSPL4\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFCFF, __sr	| then down to level 4");\
	}

#define VSPL3\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFBFF, __sr	| then down to level 3");\
	}

#define VSPL2\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xFAFF, __sr	| then down to level 2");\
	}

#define VSPL1\
	{ asm("orw	#0x0700, __sr	| interrupt mask level 7");\
	asm("andw	#0xF9FF, __sr	| then down to level 1");\
	}

#define VSPL0\
	{ asm("andw	#0xF8FF, __sr	| down to level 0");\
	}

#define SPLX	{__sr = s;}

#endif  spl_h
