/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)shm.h	1.4"	*/

#ifndef shm_h
#define shm_h
#include "sys/ipc.h"
#include "sys/pte.h"
/*
**	IPC Shared Memory Facility.
*/

/*
**	Implementation Constants.
*/

#define	SHMLBA	(NBPC * NCPS)	/* segment low boundary address multiple */
			/* (SHMLBA must be a power of 2) */

/*
**	Permission Definitions.
*/

#define	SHM_R	0400	/* read permission */
#define	SHM_W	0200	/* write permission */

/*
**	ipc_perm Mode Definitions.
*/

#define	SHM_CLEAR	01000	/* clear segment on next attach */
#define	SHM_DEST	02000	/* destroy segment when # attached = 0 */

/*
**	Message Operation Flags.
*/

#define	SHM_RDONLY	010000	/* attach read-only (else read-write) */
#define	SHM_RND		020000	/* round attach address to SHMLBA */

/*
**	Structure Definitions.
*/

/*
**	There is a shared mem id data structure for each segment in the system.
**	These structs form shmem[] array, and are pointed to from shm_shmem[].
**	The word "segment" above meant a piece of shared memory.
**	Shared memory, and its page table entries and map thereto, are locked
**	into memory (unless, perhaps, all users are currently swapped?).
**	The page table entries are managed by an in-core copy in the area
**	provided by shmmpte[], using a map (via rmap()) in shmmap[].
*/

struct shmid_ds {
	struct ipc_perm	shm_perm;	/* operation permission struct */
	int		shm_segsz;	/* segment size (in bytes) */
	struct mpte	*shm_ptbl;	/* ptr to associated page table */
	ushort		shm_lpid;	/* pid of last shmop */
	ushort		shm_cpid;	/* pid of creator */
	ushort		shm_nattch;	/* current # attached */
	time_t		shm_atime;	/* last shmat time */
	time_t		shm_dtime;	/* last shmdt time */
	time_t		shm_ctime;	/* last change time */
};

/*
**	Shared memory page table descriptors, used to form shm_pte[] array.
**	Array shm_pte[] contains fixed number available per-process,
**	and active elements are chained together off p->p_smbeg, via
**	the shm_link member, in increasing order of the shm_sgbegin
**	segment #, to allow shmat() to do first fit easily.
*/

struct	shmpt_ds {
	struct shmpt_ds *shm_link;	/* links for the shared memory used
							by a process */
	unsigned char	shm_sflg;	/* R/W permission on segment */
	unsigned char	shm_index;	/* index into shmem */
	ushort		shm_sgbegin;	/* beginning virtual page number */
};
/* values for shm_sflg */
#define SHMPT_R		0x1
#define SHMPT_W		0x2

/*
**	One shminfo struct per system, with standard System V shared memory
**	parameters.
*/

struct	shminfo {
	int	shmmax,	/* max shared memory segment size */
		shmmin,	/* min shared memory segment size */
		shmmni,	/* # of shared memory identifiers */
		shmseg,	/* max attached shared memory segments per process */
		shmbrk,	/* gap (in clicks) used between data and shared memory */
		shmall;	/* max total shared memory system wide (in clicks) */
};
#endif shm_h
