/*	Convergent Technologies - System V - Aug 1983	*/
/*	"@(#)s2652.h	1.2"	*/

#ifndef s2652_h
#define s2652_h

/* bit definitions for the signetics 2652 high speed data line.  */

/*	Parameter Control Register - (PCR) */

#define	RCV_CHAR_LEN_MASK	0x700	/* Mask for character len bits */
#define	RCV_SHIFT_CHAR_LEN	8	/* Shift for character length */
#define	RCV_ENAB_CHAR_LEN	0x800	/* used to flag setting rcv char len */
#define	TRAN_ENAB_CHAR_LEN	0x1000	/* set transmit char len */
#define	TRAN_CHAR_LEN_MASK	0xE000	/* get tran char len bits */
#define	TRAN_SHIFT_CHAR_LEN	13	/* shift for tran char len */

/* 	Parameter Control Synch/Address Register (PCASR) */

#define	SYNCH_ADDR_MASK		0xFF	/* Whole low byte */
#define	ECM_MASK		0x700	/* Error Control Mode Mask */
#define	IDLE_CTRL		0x800	/* Idle bit */
#define	SECOND_ADDR_MODE	0x1000	/* Secondary Address Mode */
#define	STRIP_SYCH_GO_AHEAD	0x2000	/* Strip SYNCH/Go Ahead bit */
#define	BCP_PROTO		0x4000	/* Select BCP Protocol.	*/
#define ALL_PARTIES_ADDR	0x8000	/* Enables broadcast */

/*	Transmit Data/Status Register (TDSR) */

#define	TRANS_DATA_BUF_MASK	0xFF	/* Whole Low Byte */
#define	TRANS_START_MESS	0x100	/*  Start of message flag */
#define	TRANS_END_MESS		0x200	/* End of message flag */
#define	TRANS_ABORT		0x400	/* Abort transmission */
#define	TRANS_GO_AHEAD		0x800	/* Send go ahead instead of flag */
					/* bits 12-14 unused */
#define	TRANS_ERROR		0x8000	/* Transmission error */

/*	Receiver Data/Status Register (RDSR) */

#define RCV_DATA_BUF_MASK	0xFF	/* whole low byte */
#define	RCV_START_MESS		0x100	/* Start Message */
#define	RCV_END_MESS		0x200	/* End Message */
#define	RCV_ABORT_GO_AHEAD	0x400	/* Got abort or go ahead */
#define	RCV_OVERRUN		0x800	/* Overrun flag */
#define	ASSEM_BIT_CNT_MASK	0x7000	/* Bits in char */
#define	ASSEM_SHIFT_BIT_CNT	12
#define	RCV_ERROR		0x8000	/* Error flag */

#endif s2652_h
