/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)map.h	1.1"	*/

#ifndef map_h
#define map_h

/*
 * Resource Allocation Maps.
 *
 * Associated routines manage sub-allocation of an address space using
 * an array of segment descriptors.  The first element of this array
 * is a map structure, describing the arrays extent and the name
 * of the controlled object.  Each additional structure represents
 * a free segment of the address space.
 *
 * A call to rminit initializes a resource map and may also be used
 * to free some address space for the map.  Subsequent calls to rmalloc
 * and rmfree allocate and free space in the resource map.  If the resource
 * map becomes too fragmented to be described in the available space,
 * then some of the resource is discarded.  This may lead to critical
 * shortages, but is better than not checking (as the previous versions
 * of these routines did) or giving up and calling panic().  The routines
 * could use linked lists and call a memory allocator when they run
 * out of space, but that would not solve the out of space problem when
 * called at interrupt time.
 *
 * N.B.: The address 0 in the resource address space is not available
 * as it is used internally by the resource map routines.
 *
 * System 5 introduced the ability to request a wakeup on a map when
 * an mfree was performed. This has been merged with the UCB map routines
 * by using the most significant bit of the map name to signal that a
 * wakeup is required when an mfree is performed on this map.
 */
struct map {
	struct	mapent *m_limit;	/* address of last slot in map */
	uint	m_want:1,		/* non zero means do wakeup on map */
		m_name:31;		/* address of name of resource */
/* we use m_name when the map overflows, in warning messages */
};
struct mapent
{
	int	m_size;		/* size of this segment of the map */
	int	m_addr;		/* resource-space addr of start of segment */
};

#ifdef KERNEL
extern struct map swapmap[];
extern int	nswapmap;
extern struct	map argmap[];
#define	ARGMAPSIZE	16

#ifdef mega
extern struct	map kmap[];
#define	KMAPSIZE	32
#endif
#endif

#ifdef vax
#define	mapstart(X)	&X[1]
#define	mapwant(X)	X[0].m_addr
#define	mapsize(X)	X[0].m_size
#define	mapdata(X)	{(X)-2, 0} , {0, 0}
#define	mapinit(X, Y)	X[0].m_size = (Y)-2
#else
#define	mapwant(X)	X[0].m_want
#endif
#endif
