/*	Convergent Technologies - System V - Jun 1983	*/
/*	"@(#)iohw.h	1.11"	*/

#ifndef iohw_h
#define iohw_h

#include <sys/types.h>
#include <sys/target.h>

#ifndef space_h
/*	8253 interval timer			*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define CNT_BASE		0xC00000
#define CNT_S			((unsigned short *) (CNT_BASE))
#define CNT_F			((unsigned short *) (CNT_BASE + 0x02))
#define CNT_TICKS		((unsigned short *) (CNT_BASE + 0x04))
#define CNTL_WD			((unsigned short *) (CNT_BASE + 0x06))

/*	SC bits of control word bits 6-7 */
#define SEL_FC_TIM		0x00		/* SC select fast com timer */
#define SEL_PERIODIC		0x40		/* SC select periodic interrupt */
#define SEL_TICK_CNT		0x80		/* SC select counter of ticks */
/*	counts */
#define HZ_60_MSB		0x05		/* MSB of 60HZ count */
#define HZ_60_LSB		0x00		/* LSB of 60HZ count */
/*	RL bits of control word bits 4-5 */
#define RW2BYTE			0x30		/* RL bits= LSB then MSB */
#define RL_LATCH		0x00		/* RL latch state of timer */
#define MODE0			0x0
#define MODE1			0x2
#define MODE2			0x4		/* for periodic interrupt */
#define MODE3			0x6		/* for counting ticks */

/*  value to use in touching processor registers for some control functions */
#define	ACTIVATE	(ushort)0

/*	RS-422 Bus interface registers - 2652A		*/

#define A_2652_BASE	    0xC10000
#define A_RDSR_ADDR	    ((unsigned short *)(A_2652_BASE)) /* RO */
#define A_TDSR_ADDR	    ((unsigned short *)(A_2652_BASE+0x04)) /* R/W */
#define A_PCSAR_ADDR	    ((unsigned short *)(A_2652_BASE+0x08)) /* R/W */
#define A_PCR_ADDR	    ((unsigned short *)(A_2652_BASE+0x0C)) /* R/W */

#define A_RX_ENAB_ADDR	    ((unsigned short *)(A_2652_BASE+0x20)) /* CTRL */
#define A_RX_DISAB_ADDR	    ((unsigned short *)(A_2652_BASE+0x22)) /* CTRL */
#define A_DMA_ENAB_ADDR	    ((unsigned short *)(A_2652_BASE+0x24)) /* CTRL */
#define A_DMA_DISAB_ADDR    ((unsigned short *)(A_2652_BASE+0x26)) /* CTRL */
#define A_SCLK_SEL_ADDR	    ((unsigned short *)(A_2652_BASE+0x28)) /* CTRL */
#define A_FCLK_SEL_ADDR	    ((unsigned short *)(A_2652_BASE+0x2A)) /* CTRL */
#define A_TX_ENAB_ADDR	    ((unsigned short *)(A_2652_BASE+0x2C)) /* CTRL */
#define A_TX_DISAB_ADDR	    ((unsigned short *)(A_2652_BASE+0x2E)) /* CTRL */
#define A_ENAB_CLK_OP_ADDR  ((unsigned short *)(A_2652_BASE+0x30)) /* CTRL */
#define A_DISAB_CLK_OP_ADDR ((unsigned short *)(A_2652_BASE+0x32)) /* CTRL */
#define A_RESET_ADDR	    ((unsigned short *)(A_2652_BASE+0x34)) /* CTRL */

/*	RS-422 DMA registers - 2652A		*/
/*	Uses full 16 bit word */

#define A_DMA_BASE	  0xC20000
#define A_DMA_COUNT_ADDR  ((unsigned short *)(A_DMA_BASE))	/* R/W */
#define A_DMA_LADDR_ADDR  ((unsigned short *)(A_DMA_BASE+0x02)) /* WO */
#define A_SET_MEMDEV_ADDR ((unsigned short *)(A_DMA_BASE+0x06))	/* CTRL */
#define A_SET_DEVMEM_ADDR ((unsigned short *)(A_DMA_BASE+0x08)) /* CTRL */

#endif
/*	RS-232 Ports A + B Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define A_232_BASE	0xC30000
#define A_DATA_ADDR	((unsigned short *)(A_232_BASE))      /* R/W */
#define B_DATA_ADDR	((unsigned short *)(A_232_BASE+0x02)) /* R/W */
#define A_CMND_ADDR	((unsigned short *)(A_232_BASE+0x04)) /* WO */
#define B_CMND_ADDR	((unsigned short *)(A_232_BASE+0x06)) /* WO */
#define AB_EX_CTRL_ADDR	((unsigned short *)(A_232_BASE+0x08)) /* R/W */
#define AB_RESET	((unsigned short *)(A_232_BASE+0x0A)) /* WO */

/*	bits in the extended control register on writing */
#define EX_STDA			0x08		/* 1=secondary TX chnl A */
#define EX_STDB			0x04		/* 1=secondary TX chnl B */
/*	the internal/external selection: 0=internal	1=external */
#define EX_SELA			0x02		/* select int/ext clk chnl A */
#define EX_SELB			0x01		/* select int/ext clk chnl B */
/*	status bits in the extended control register on reading */
#define EX_RIA			0x80		/* 0=RI chnl A */
#define EX_DSRA			0x40		/* 0=DSR chnl A */
#define EX_SRDA			0x20		/* 0=SRD chnl A */
#define EX_RIB			0x10		/* 0=RI chnl B */
#define EX_DSRB			0x08		/* 0=DSR chnl B */
#define EX_SRDB			0x04		/* 0=SRD chnl B */
#define EX_FCC			0x02		/* fast com carrier 2652A */
#define EX_FDP			0x01		/* =0 floppy present */

/*	8253 timer for 8274 channel A + B		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define A_8253_BASE		0xC40000
#define A_BAUD_ADDR		((unsigned short *)(A_8253_BASE))
#define B_BAUD_ADDR		((unsigned short *)(A_8253_BASE+0x02))
#define AB_CNTL_WD		((unsigned short *)(A_8253_BASE+0x06))
/*	SC bits of control word bits 6-7 */
#define SEL_A_BAUD		0x00		/* SC select A baud rate */
#define SEL_B_BAUD		0x40		/* SC select B baud rate */

#ifndef space_h
/*	Parallel Line Printer Registers  */
/*	Uses the least significant byte of 16 bit word */

#define LP_BASE			0xC50000
#define LP_DATA_ADDR		((unsigned short *)(LP_BASE)) /* R/W */
#define LP_INT_ENAB_ADDR	((unsigned short *)(LP_BASE+0x02)) /* WO */
#define LP_INT_DISAB_ADDR	((unsigned short *)(LP_BASE+0x04)) /* WO */
/*	bits in the status register on reading */
#define LP_BUF_FULL		0x02		/* buffer is full */
#define LP_NOT_PRSNT		0x04		/* lp not present */
#define LP_OUT_PAPER		0x08		/* out of paper */
#define LP_SELECTED		0x10		/* selected */
#define LP_BUSY			0x20		/* busy */

/*	DISK Bus interface registers	*/
/*	Uses the least significant byte of 16 bit word */

#define HD_TRI_BASE	  0xC60000
#define HD_TRI_ADDR	  ((unsigned short *)(HD_TRI_BASE)) /* ??? */
#define HD_ERROR_FLAGS	  ((unsigned short *)(HD_TRI_BASE+0x02)) /*  R  */
#define HD_SECTOR	  ((unsigned short *)(HD_TRI_BASE+0x04)) /* R/W */
#define HD_SECNUM	  ((unsigned short *)(HD_TRI_BASE+0x06)) /* R/W */
#define HD_CYL_LOW	  ((unsigned short *)(HD_TRI_BASE+0x08)) /* R/W */
#define HD_CYL_HIGH	  ((unsigned short *)(HD_TRI_BASE+0x0A)) /* R/W */
#define HD_SDH		  ((unsigned short *)(HD_TRI_BASE+0x0C)) /* R/W */
#define HD_STAT_CMD	  ((unsigned short *)(HD_TRI_BASE+0x0E)) /*  R  */
#define FD_STAT_CMD	  ((unsigned short *)(HD_TRI_BASE+0x10)) /*  R  */
#define FD_TRACK_REG	  ((unsigned short *)(HD_TRI_BASE+0x12)) /* R/W */
#define FD_SECTOR	  ((unsigned short *)(HD_TRI_BASE+0x14)) /* R/W */
#define FD_DATA_REG	  ((unsigned short *)(HD_TRI_BASE+0x16)) /* R/W */
#define FD_ON_RESET	  ((unsigned short *)(HD_TRI_BASE+0x20)) /* CTRL */
#define FD_OF_RESET	  ((unsigned short *)(HD_TRI_BASE+0x22)) /* CTRL */
#define HD_ON_RESET	  ((unsigned short *)(HD_TRI_BASE+0x24)) /* CTRL */
#define HD_OF_RESET	  ((unsigned short *)(HD_TRI_BASE+0x26)) /* CTRL */
#define FD_ON_MOTOR	  ((unsigned short *)(HD_TRI_BASE+0x28)) /* CTRL */
#define FD_OF_MOTOR	  ((unsigned short *)(HD_TRI_BASE+0x2A)) /* CTRL */
#define HD_DMA_ENABLE	  ((unsigned short *)(HD_TRI_BASE+0x2C)) /* CTRL */
#define FD_DMA_ENABLE	  ((unsigned short *)(HD_TRI_BASE+0x2E)) /* CTRL */
#define DSK_DMA_DISABLE	  ((unsigned short *)(HD_TRI_BASE+0x30)) /* CTRL */
#define FD_SINGLE_DENSITY ((unsigned short *)(HD_TRI_BASE+0x32)) /* CTRL */
#define FD_DOUBLE_DENSITY ((unsigned short *)(HD_TRI_BASE+0x34)) /* CTRL */
#define BIU_RESET	  ((unsigned short *)(HD_TRI_BASE+0x36)) /* CTRL */

/*	DISK DMA registers - WD1010 & WD2797		*/
/*	Uses full 16 bit word */

#define D_DMA_BASE		0xC80000
#define D_DMA_COUNT_ADDR	((unsigned short *)(D_DMA_BASE)) /* R/W */
#define D_DMA_LADDR_ADDR	((unsigned short *)(D_DMA_BASE+0x02)) /* WO */
#define D_SET_MEMDEV_ADDR	((unsigned short *)(D_DMA_BASE+0x06)) /* CTRL */
#define D_SET_DEVMEM_ADDR	((unsigned short *)(D_DMA_BASE+0x08)) /* CTRL */
#endif

/*	RS-232 Ports C + D Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define C_232_BASE		0xC70000
#define C_DATA_ADDR		((unsigned short *)(C_232_BASE)) /* R/W */
#define D_DATA_ADDR		((unsigned short *)(C_232_BASE+0x02)) /* R/W */
#define C_CMND_ADDR		((unsigned short *)(C_232_BASE+0x04)) /* WO */
#define D_CMND_ADDR		((unsigned short *)(C_232_BASE+0x06)) /* WO */
#define CD_EX_CTRL_ADDR		((unsigned short *)(C_232_BASE+0x08)) /* R/W */
#define CD_RESET		((unsigned short *)(C_232_BASE+0x0A)) /* WO */

/*	RS-232 Ports E + F Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define	E_232_BASE		0xC71000
#define E_DATA_ADDR		((unsigned short *)(E_232_BASE)) /* R/W */
#define F_DATA_ADDR		((unsigned short *)(E_232_BASE+0x02)) /* R/W */
#define E_CMND_ADDR		((unsigned short *)(E_232_BASE+0x04)) /* WO */
#define F_CMND_ADDR		((unsigned short *)(E_232_BASE+0x06)) /* WO */
#define EF_EX_CTRL_ADDR		((unsigned short *)(E_232_BASE+0x08)) /* R/W */
#define EF_RESET		((unsigned short *)(C_232_BASE+0x0A)) /* WO */

/*	RS-232 Ports G + H Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define	G_232_BASE		0xC72000
#define G_DATA_ADDR		((unsigned short *)(G_232_BASE)) /* R/W */
#define H_DATA_ADDR		((unsigned short *)(G_232_BASE+0x02)) /* R/W */
#define G_CMND_ADDR		((unsigned short *)(G_232_BASE+0x04)) /* WO */
#define H_CMND_ADDR		((unsigned short *)(G_232_BASE+0x06)) /* WO */
#define GH_EX_CTRL_ADDR		((unsigned short *)(G_232_BASE+0x08)) /* R/W */
#define GH_RESET		((unsigned short *)(C_232_BASE+0x0A)) /* WO */

/*	RS-232 Ports I + J Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define	I_232_BASE		0xC73000
#define I_DATA_ADDR		((unsigned short *)(I_232_BASE)) /* R/W */
#define J_DATA_ADDR		((unsigned short *)(I_232_BASE+0x02)) /* R/W */
#define I_CMND_ADDR		((unsigned short *)(I_232_BASE+0x04)) /* WO */
#define J_CMND_ADDR		((unsigned short *)(I_232_BASE+0x06)) /* WO */
#define IJ_EX_CTRL_ADDR		((unsigned short *)(I_232_BASE+0x08)) /* R/W */
#define IJ_RESET		((unsigned short *)(C_232_BASE+0x0A)) /* WO */

/*	8253 timer for 8274 channel C + D + E		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define	C_8253_BASE		0xC74000
#define C_BAUD_ADDR		((unsigned short *)(C_8253_BASE))
#define D_BAUD_ADDR		((unsigned short *)(C_8253_BASE+0x02))
#define E_BAUD_ADDR		((unsigned short *)(C_8253_BASE+0x04))
#define CD_CNTL_WD		((unsigned short *)(C_8253_BASE+0x06))
/*	SC bits of control word bits 6-7 */
#define SEL_C_BAUD		0x00		/* SC select C baud rate */
#define SEL_D_BAUD		0x40		/* SC select D baud rate */
#define SEL_E_BAUD		0x80		/* SC select E baud rate */

/*	8253 timer for 8274 channel F + G + H		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define	G_8253_BASE		0xC75000
#define G_BAUD_ADDR		((unsigned short *)(G_8253_BASE))
#define H_BAUD_ADDR		((unsigned short *)(G_8253_BASE+0x02))
#define F_BAUD_ADDR		((unsigned short *)(G_8253_BASE+0x04))
#define GH_CNTL_WD		((unsigned short *)(G_8253_BASE+0x06))
/*	SC bits of control word bits 6-7 */
#define SEL_G_BAUD		0x00		/* SC select G baud rate */
#define SEL_H_BAUD		0x40		/* SC select H baud rate */
#define SEL_F_BAUD		0x80		/* SC select F baud rate */

/*	8253 timer for 8274 channel I + J		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define	I_8253_BASE		0xC76000
#define I_BAUD_ADDR		((unsigned short *)(I_8253_BASE))
#define J_BAUD_ADDR		((unsigned short *)(I_8253_BASE+0x02))
#define IJ_CNTL_WD		((unsigned short *)(I_8253_BASE+0x06))
/*	SC bits of control word bits 6-7 */
#define SEL_I_BAUD		0x00		/* SC select I baud rate */
#define SEL_J_BAUD		0x40		/* SC select J baud rate */

/*	8259A - on-board, controls 2652A (4 interrupts), 8253(0), 1010, 2797 */

#define A0_8259_ADDR		((unsigned short *)0xC90000)
#define A1_8259_ADDR		((unsigned short *)0xC90002)

/*	RadioFrame RS-232 Ports C + D Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define RC_DATA_ADDR		((unsigned short *)0xC30018) /* R/W */
#define RD_DATA_ADDR		((unsigned short *)0xC3001A) /* R/W */
#define RC_CMND_ADDR		((unsigned short *)0xC3001C) /* WO */
#define RD_CMND_ADDR		((unsigned short *)0xC3001E) /* WO */
#define RCD_EX_CTRL_ADDR	((unsigned short *)0xC3000C) /* R/W */
#define RCD_RESET		((unsigned short *)0xC3000A) /* WO */


/*	RadioFrame 8253 timer for 8274 channel C + D + E		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define RCD_CNTL_WD		((unsigned short *)0xC40016)
#define RC_BAUD_ADDR		((unsigned short *)0xC40010)
#define RD_BAUD_ADDR		((unsigned short *)0xC40012)
#define RFIDENT			((unsigned short *)0xC40014)

#endif

/*	RS-232 Ports K + L Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define K_DATA_ADDR		((unsigned short *)0xCF0000) /* R/W */
#define L_DATA_ADDR		((unsigned short *)0xCF0002) /* R/W */
#define K_CMND_ADDR		((unsigned short *)0xCF0004) /* WO */
#define L_CMND_ADDR		((unsigned short *)0xCF0006) /* WO */
#define KL_EX_CTRL_ADDR		((unsigned short *)0xCF0008) /* R/W */
#define KL_RESET		((unsigned short *)0xC7000A) /* WO */

/*	RS-232 Ports M + N Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define M_DATA_ADDR		((unsigned short *)0xCF1000) /* R/W */
#define N_DATA_ADDR		((unsigned short *)0xCF1002) /* R/W */
#define M_CMND_ADDR		((unsigned short *)0xCF1004) /* WO */
#define N_CMND_ADDR		((unsigned short *)0xCF1006) /* WO */
#define MN_EX_CTRL_ADDR		((unsigned short *)0xCF1008) /* R/W */
#define MN_RESET		((unsigned short *)0xC7000A) /* WO */

/*	RS-232 Ports O + P Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define O_DATA_ADDR		((unsigned short *)0xCF2000) /* R/W */
#define P_DATA_ADDR		((unsigned short *)0xCF2002) /* R/W */
#define O_CMND_ADDR		((unsigned short *)0xCF2004) /* WO */
#define P_CMND_ADDR		((unsigned short *)0xCF2006) /* WO */
#define OP_EX_CTRL_ADDR		((unsigned short *)0xCF2008) /* R/W */
#define OP_RESET		((unsigned short *)0xC7000A) /* WO */

/*	RS-232 Ports Q + R Registers  - 8274		*/
/*	Uses the least significant byte of 16 bit word */

#define Q_DATA_ADDR		((unsigned short *)0xCF3000) /* R/W */
#define R_DATA_ADDR		((unsigned short *)0xCF3002) /* R/W */
#define Q_CMND_ADDR		((unsigned short *)0xCF3004) /* WO */
#define R_CMND_ADDR		((unsigned short *)0xCF3006) /* WO */
#define QR_EX_CTRL_ADDR		((unsigned short *)0xCF3008) /* R/W */
#define QR_RESET		((unsigned short *)0xC7000A) /* WO */

/*	8253 timer for 8274 channel K	*/
/*	Control is Read only. Uses least significant byte of 16 bit word */
/*	Counter are Read/Write. Uses least significant byte of 16 bit word */
/*	Uses IJ_CNTL_WD as control word register */

#define K_BAUD_ADDR		((unsigned short *)0xC76004)
/*	SC bits of control word bits 6-7 */
#define SEL_K_BAUD		0x80		/* SC select K baud rate */

/*	8253 timer for 8274 channel L + M + N		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define LMN_CNTL_WD		((unsigned short *)0xCF4006)
#define L_BAUD_ADDR		((unsigned short *)0xCF4000)
#define M_BAUD_ADDR		((unsigned short *)0xCF4002)
#define N_BAUD_ADDR		((unsigned short *)0xCF4004)
/*	SC bits of control word bits 6-7 */
#define SEL_L_BAUD		0x00		/* SC select L baud rate */
#define SEL_M_BAUD		0x40		/* SC select M baud rate */
#define SEL_N_BAUD		0x80		/* SC select N baud rate */

/*	8253 timer for 8274 channel O + P + Q		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define OPQ_CNTL_WD		((unsigned short *)0xCF5006)
#define O_BAUD_ADDR		((unsigned short *)0xCF5000)
#define P_BAUD_ADDR		((unsigned short *)0xCF5002)
#define Q_BAUD_ADDR		((unsigned short *)0xCF5004)
/*	SC bits of control word bits 6-7 */
#define SEL_O_BAUD		0x00		/* SC select O baud rate */
#define SEL_P_BAUD		0x40		/* SC select P baud rate */
#define SEL_Q_BAUD		0x80		/* SC select Q baud rate */

/*	8253 timer for 8274 channel R		*/
/*	Control is Read only.	Uses least significant byte of 16 bit word */
/*	Counters are Read/Write. Uses least significant byte of 16 bit word */

#define R_CNTL_WD		((unsigned short *)0xCF6006)
#define R_BAUD_ADDR		((unsigned short *)0xCF6000)
/*	SC bits of control word bits 6-7 */
#define SEL_R_BAUD		0x00		/* SC select R baud rate */

/*	Extension RS-422 Bus interface registers - 2652		*/

#define	E_422_BASE		0xCF7000
#define E_RDSR_ADDR		((unsigned short *)(E_422_BASE))	/* RO */
#define E_TDSR_ADDR		((unsigned short *)(E_422_BASE+0x04)) /* R/W */
#define E_PCSAR_ADDR		((unsigned short *)(E_422_BASE+0x08)) /* R/W */
#define E_PCR_ADDR		((unsigned short *)(E_422_BASE+0x0C)) /* R/W */

#define E_RX_ENAB_ADDR		((unsigned short *)(E_422_BASE+0x20)) /* CTRL */
#define E_RX_DISAB_ADDR		((unsigned short *)(E_422_BASE+0x22)) /* CTRL */
#define E_DMA_ENAB_ADDR		((unsigned short *)(E_422_BASE+0x24)) /* CTRL */
#define E_DMA_DISAB_ADDR	((unsigned short *)(E_422_BASE+0x26)) /* CTRL */
#define E_SCLK_SEL_ADDR		((unsigned short *)(E_422_BASE+0x28)) /* CTRL */
#define E_FCLK_SEL_ADDR		((unsigned short *)(E_422_BASE+0x2A)) /* CTRL */
#define E_TX_ENAB_ADDR		((unsigned short *)(E_422_BASE+0x2C)) /* CTRL */
#define E_TX_DISAB_ADDR		((unsigned short *)(E_422_BASE+0x2E)) /* CTRL */
#define E_ENAB_CLK_OP_ADDR	((unsigned short *)(E_422_BASE+0x30)) /* CTRL */
#define E_DISAB_CLK_OP_ADDR	((unsigned short *)(E_422_BASE+0x32)) /* CTRL */
#define E_RESET_ADDR		((unsigned short *)(E_422_BASE+0x34)) /* CTRL */

/*	Extension RS-422 DMA registers - 2652	*/
/*	Uses full 16 bit word */

#define	E_DMA_BASE		0xCF8000
#define E_DMA_COUNT_ADDR	((unsigned short *)(E_DMA_BASE)) /* R/W */
#define E_DMA_LADDR_ADDR	((unsigned short *)(E_DMA_BASE+0x02)) /* WO */
#define E_SET_MEMDEV_ADDR	((unsigned short *)(E_DMA_BASE+0x06)) /* CTRL */
#define E_SET_DEVMEM_ADDR	((unsigned short *)(E_DMA_BASE+0x08)) /* CTRL */

#define	E_INT_VEC_ADDR		((unsigned short *) 0xCF9000)	/* WO */
