|	Convergent Technologies - System V - May 1983
|	"@(#)gdisk.m	1.8"

#ifndef gdisk_m
#define gdisk_m

DISKS		= 3	| the number of disks on MiniFrame
GDRETRIES	= 10	| the number of retries for an operation
GAPSZ		= 36	| size of gap1 and gap3 for format

|	defines for manipulating the minor node number
DRVSHIFT	= 4	| slice number occupies the ls 4 bits
DRVMSK		= 3	| drive number is 2 bits
SLCMSK		= 0xF	| slice number is 4 bits
MAXSLICE	= 16	| maximum number of slices

|	volume home block on disk
Vmagic		= 0x00		| miniframe disk format code
Vchksum		=Vmagic+4	| adjustment so that the 32 bit sum starting
				| from magic for 512 bytes sums to -1
Vname		=Vchksum+4	| printf name
Vcyls		=Vname+6	| the number of cylinders for this disk
Vheads		=Vcyls+2	| number of heads per cylinder
Vpsectrk	=Vheads+2	| number of physical sectors per track
Vpseccyl	=Vpsectrk+2	| number of physical sectors per cylinder
Vflags		=Vpseccyl+2	| floppy density and high tech drive flags
Vstep		=Vflags+1	| stepper motor rate to controller
Vsectorsz	=Vstep+1	| physical sector size
Vpartab		=Vsectorsz+2	| partition table
Vresmap		=Vpartab+64	| 8 reserved area special files (resmap)
				| start logical block #
				| length in logical blocks
				|	(zero implies not present)
|	resmap consists of the following entries:
|		loader area
|		bad block table
|		dump area
|		down load image file
|		Bootable program, size determined by a.out format. nblocks=1.

Vfpulled	=Vresmap+48	| dismounted last time?
Vtime		=Vfpulled+642	| time last came on line
Vrwcwpccyl	=Vtime+4	| value to program for RWC/WPC,
				| this is rqd cylinder/4
VHBend		=Vrwcwpccyl+2	| end of VHB

|	flags in gdswprt
FPDENSITY	=0x01		| 0=single 1=double density
FPMIXDENS	=0x02		| 0=all tracks are the same density
				| 1= cylinder zero is single density
HITECH		=0x04		| 0= reduced write current is valid,
				| 1= head select bit 3 is valid
NEWPARTTAB	=0x08		| 0= old style partition table,
				| 1= new style partition table
RWCWPC		=0x10		| 0= avoid reduced write current/write precomp,
				|  1= set reduced write current/write precomp.
				|  write precomp is selected by HITECH
EXCHANGEABLE	=0x20		| 0= not exchangeable (ignored for floppy)
				| 1= exchangeable disk

VHBMAGIC	= 0x55515651	| magic number in disk vhb

|	indexes into resmap
INDLOADER	= 0
INDBBTBL	= 1
INDDUMP		= 2
INDDOWNLOAD	= 3
INDBOOT		= 4

|	displacements from the start of resmap
DLOADER		= 00
DBBTBL		= 06
DDUMP		= 12
DDOWNLOAD	= 18
DBOOT		= 24

|	values for hwtype
HD		= 0		| Winchester
SY		= 1		| Syquest
FD		= 2		| floppy

|	drive numbers
GDDRV0	=0		| WD1010 drive 0 - Winchester.	type=HD
GDDRV1	=1		| WD1010 drive 1 - Winchester.	type=HD
			|		OR Syquest.	type=SY
GDDRV2	=2		| WD2797 drive 0 - Floppy.	type=FD

|	some defines for bad block support
MAXBOFBBT	=3			| BBT is max of 3 blks
NBBPERB 	=127	| the # of bad blocks in each block of the bbt
|MAXBBT		(MAXBOFBBT*1024)	| space in memory
MAXBBT		=3072			| space in memory
|MAXBB		(MAXBOFBBT*NBBPERB)	| max bad blocks
MAXBB		=381			| max bad blocks

|	values of flag bits in v_flags
F_OPENED	= 0x0001	| set when the first open is performed for
				| any slice on this disk, cleared when the
				| drive goes off line - indicates an
				| attempt has been made to read the vhb
F_CT_FMT	= 0x0002	| a valid vhb has been read for this disk,
				| this implies logical block=1024 bytes
				| and bad block handling
F_READY		= 0x0004	| ready from controller
F_PULLED	= 0x0008	| disk was removed without permission last
				| time, produces warning on open
PHYS_ADDR	= 0x0010	| alien disk. gdswprt supplied via ioctl.
				|   the flag is set by ioctl for reading non
				|   standard floppies. cleared by close.
				|   slice 0 is the only valid one
				|   in this mode the offset number is the
				|   physical sector number <<10, whether sector
				|   size is 1024, 512, 256 or 128. count is
				|   still the number of bytes.
F_MAYREMOVE	= 0x0020	| The drive may be taken off line.
WR_PROT		= 0x0040	| set after each transfer. 1=write protected
				|	disk. 0=not protected


|	bad block table
|
|	On the disk the bad block table consists of an array of cells, one per
|	used alternate physical sector.
|	cyl	is the cylinder containing the bad block badblk.
|	badblk	is the physical sector address (within the cylinder cyl)
|		of a bad block.
|	altblk	is the location of the alternate physical sector. It is
|		specified as the track number since the alternate sector is
|		always the last sector of a track.
|	nxtind	is a chain of bad blocks on the same cylinder. The number is
|		the index into this array of bad block cells. A value of zero
|		means the end of the chain for this cylinder. The zero'th
|		entry is not used, other than to hold the count of used cells).
|
|
|	In memory a similar array will be held in the appropriate gdbtab
|	together with an array containing an entry for each cylinder which
|	holds the index into the above array of cells for the head for that
|	cylinder.
|	This means that a zero entry indicates no bad blocks on that cylinder.
|
|	This mechanism implies a maximum of 255 bad blocks per disk which is
|	adequate for disks upto the 250 Mbyte range.
|	The bad block table is held as a chained set of logical blocks on
|	track zero. Each block can hold 256 entries.
|	The first bad block cell in each logical block of the bad block table
|	contains a chksum (in cyl and badblk) for the 1024 byte block, it is
|	a 32 bit sum which sums to -1. altblk contains the logical block
|	number of the next block in the bad block table, zero=end.
|	On a disk with an odd number of sectors per track, the last sector
|	is removed from the logical mapping and is used as an alternate area.
|
|	Bad block handling is disabled on floppies.

HDMAXBADBLK	= 256	| only support maximum of 256 bad blocks
HDMAXCYL	= 1024	| support a maximum of 1024 cylinders
SYMAXBADBLK	= 40	| only support maximum of 40 bad blocks
SYMAXCYL	= 1024	| support a maximum of 1024 cylinders
FPMAXBADBLK	= 0	| no bad block support on floppies
FPMAXCYL	= 0	| no bad block support on floppies

|	displacements in a bad block cell on disk
BBC_cyl		= 0x00		| the cylinder of the bad block
BBC_badblk	= 0x02		| the physical sector address of the bad block
				| within the cylinder cyl
BBC_altblk	= 0x04		| track number of alternate
BBC_nxtind	= 0x06		| index into the cell array for next bad block
				| cell for this cylinder

|	values in d_flags
F_ACTIVE	= 0x0001	| driver operation in progress
F_DMAON		= 0x0002	| DMA operation in progress
F_SEEKING	= 0x0004	| seek in progress
FDMTRON		= 0x0008	| floppy motor is on + up to speed
FDMTRSTRT	= 0x0010	| the floppy motor has been started but
				| is not up to speed yet
FDCHECKED	= 0x0020	| set when floppy has been verified as still
				| being the same one that was on line
				| before motor turned off
MAYGETFDINT	= 0x0040	| on reseting the floppy the 2797 may
				| or may not choose to give an
				| interrupt, so be prepared to
				| discard it
FDSPECIALRD	= 0x0080	| a read of the vhb from dismount
				| caused a special read to be be
				| performed in the disk driver
				| while checking if the floppy had
				| been changed
FDNEWQ		= 0x0100	| new disk maybe so use recal to
				| establish head position
FD_TIMEOUT	= 0x0200	| a timeout occurred on a floppy
				| transfer, floppy not in or in
				| backwards - so terminate with error


|	values in ctl (supplied from assembly interrupt code)
WD2797		= 1
WD1010		= 0
BIU		= 2

|
|	Internal commands

CMD_READ	= 0
CMD_WRITE	= 1
CMD_FORMAT	= 2

|
|	Command information for WD1010.

HDMASK		= 0x0007	| 3 bits for head size
W_RESTORE	= 0x0010	| restore command
W_SEEK		= 0x0070	| seek command
W_READ		= 0x0020	| read sector command
W_WRITE		= 0x0030	| write sector command
W_SCANID	= 0x0040	| scan id command
W_WR_FORMAT	= 0x0050	| write format command
W_RATEMSK	= 0x000F	| LS 4 bits of restore/seek command = rate
W_MULT		= 0x0004	| multi sector transfer flag for read/write
W_INTEOC	= 0x0008	| interrupt at end of command (read only)

|
|	Status information for WD1010.

W_ERR		= 0x0001	| logical or of bits in the error register
W_CIP		= 0x0002	| 1= command in progress
W_DRQ		= 0x0008	| 1= data request outstanding
W_SEKCMP	= 0x0010	| 1= seek complete
W_WRFLT		= 0x0020	| 1= write fault
W_RDY		= 0x0040	| 1= ready,frozen on error until status read
W_BUSY		= 0x0080	| 1= WD1010 is accessing the disk

|
|	Error status information for the WD1010.

W_BBD		= 0x0080	| bad block detected (not used)
W_CRC		= 0x0040	| 1= CRC error
W_ID		= 0x0010	| 1= id not found
W_ABC		= 0x0004	| 1= aborted command
W_TK		= 0x0002	| 1= restore command did not find track zero

|
|	Command information for the WD2797.

F_RESTORE	= 0x0000	| restore command
F_SEEK		= 0x0010	| seek command
F_STEP		= 0x0020	| step command
F_STEPIN	= 0x0040	| step-in command
F_STEPOUT	= 0x0060	| step-out command
F_READ		= 0x0080	| read sector command
F_WRITE		= 0x00a0	| write sector command
F_READADR	= 0x00c0	| read address command
F_READTRK	= 0x00e0	| read track command
F_WRITETRK	= 0x00f0	| write track command
F_FORCEINT	= 0x00d0	| force interrupt command

LOADHEAD	= 0x0008	| 1= load head at beginning (restore,seek,step,
				|   step-in, step-out)
VERIFYTRK	= 0x0004	| 1= verify on destination track (restore,seek,
				|   step, step-in, step-out)
STEPMSK		= 0x0003	| stepping motor rate (restore,seek,
				|   step, step-in, step-out)
F_UPDTRKRG	= 0x0010	| 1= update track register (step, step-in,
				|   step-out)
F_MULT		= 0x0010	| 1= multiple record flag(read/write sector)
F_LENGTH	= 0x0008	| 1= lsb sector length in sector id field means
				|   00=128 01=256 10=512 11=1024
				|   (read/write sector)
F_15MSDLY	= 0x0004	| 1= 15MS delay(30 MS for 1MHZ) (read/write
				|   sector, read/write track and read address)
F_UPDATESSO	= 0x0002	| 1= update SSO to 1 (read/write
				|   sector, read/write track and read address)
F_D_A_MRK	= 0x0001	| data address mark (write sector)
F_INT0		= 0x0001	| force interrupt on not ready to ready
				|   transition. (force interrupt)
F_INT1		= 0x0002	| force interrupt on ready to not ready
				|   transition. (force interrupt)
F_INT2		= 0x0004	| force interrupt on index pulse.
				|   (force interrupt)
F_INT3		= 0x0008	| force interrupt immediately (requires reset).
				|   (force interrupt)
F_INT_NO	= 0x0000	| terminate with no interrupt.(force interrupt)

|
|	Status information for the WD2797.

F_BUSY		= 0x0001	| 1= command under execution
F_DRQ		= 0x0002	| 1= data request line
F_LOSTDATA	= 0x0004	| 1= CPU didn't respond to DRQ
F_CRCERR	= 0x0008	| 1= error in one or more id fields or an error
				|   in the data field
F_RECNF		= 0x0010	| 1= requested side,trac, sector not found
F_RECTYP	= 0x0020	| 1= deleted data mark else data mark, on read.
				|   forced to zero on write.
F_WRPROT	= 0x0040	| 1= indicates a protected disk on write,
				|   not used on read
F_NOTRDY	= 0x0080	| 1= drive not ready
F_TRK0		= 0x0004	| 1= heads on track zero

#endif gdisk_m
