/*	Convergent Technologies - System V - Jun 1983	*/
/*	"@(#)exch.h	1.3"	*/

#ifndef exch_h
#define exch_h
/*
 * Template for the fixed portion of a request block.
 */

struct rqheader {
	unsigned short r_sCntInfo;	/* size of control information */
	unsigned char r_nReqPbCb;	/* number of request PbCb's */
	unsigned char r_nRespPbCb;	/* number of response PbCb's */
	unsigned short r_userNum;	/* user number: kernel fills in */
	unsigned short r_exchResp;	/* response exchange */
	unsigned short r_ercRet;	/* error return code */
	unsigned short r_rqCode;	/* request code */
};

struct PbCb {
	char *pc_offset;
	unsigned short pc_count;
};

/*
 * For processes that wish to copy in their own messages,
 * the msgret structure provides the m_cputype field
 * indicating what processor type the message originated on.
 * These are also the values that the master FP plugs
 * into the BusConfigurationTable at boot time, so that
 * each cpu may know the other's types.
 */
#define CPUTY_FP	((unsigned char)10)
#define CPUTY_TP	((unsigned char)11)
#define CPUTY_CP	((unsigned char)12)
#define CPUTY_SP	((unsigned char)13)
#define CPUTY_AP	((unsigned char)64)

/*
 * The following macro evaluates to zero if a cpu type uses
 * Motorola/IBM byte ordering (most significant byte at lowest address),
 * and evaluates to non-zero for Intel/DEC ordering (most significant
 * byte at highest address).
 */
#define BYTEORDER_INTEL(cputype) ((cputype) < 64)

struct msgret {
	unsigned short m_rqCode;	/* request code of just received msg. */
	unsigned short m_reqdes;	/* request descriptor handle */
	int m_size;			/* size req block + req or resp data */
	char m_flag;			/* just MREQUEST or MRESPONSE */
	unsigned short m_ercRet;	/* if (MRESPONSE) error return code */
	unsigned char m_cputype;	/* CPUTY_??: FP, TP, CP, SP, or AP. */
	unsigned char m_slot;		/* box/slot from whence msg came */
	struct request *m_offset;	/* 32 bit addr of req block in m_slot */
};

/*
 * values of m_flag:
 */
#define MREQUEST	((char)0)
#define MRESPONSE	((char)1)

/*
 * Request Code 0 is always illegal:
 */
#define RQC_INVALID ((unsigned short)0)	/* invalid request code */

/*
 * The value -1 is an invalid request descriptor:
 */
#define RQDES_INVALID ((unsigned short)-1)

/*
 * These are error codes taken from the CTOS manual.
 */

#define ercNoReserveBlk		((unsigned short)15)
#define ercServiceNotAvail	((unsigned short)33)
#endif exch_h
