/*	Convergent Technologies - System V - Jan 1984	*/
/*	"@(#)enet.h	1.7"	*/

/*
 *	This file contains the bit definitions used with the registers
 *	on the Am7990 LANCE chip and with the memory structures which
 *	it directly accesses.
 */

#ifndef enet_h
#define enet_h

/*	Am7990 - Ethernet expansion board registers */

#define ENET_RESET_ADDR		((unsigned short *)0xC78000)
#define STATUS_BLOCK_ADDR	((unsigned short *)0xC7800E)
#define RAP_WRITE_ADDR		((unsigned short *)0xC78010)
#define RDP_WRITE_ADDR		((unsigned short *)0xC78012)
#define RAP_FETCH_ADDR		((unsigned short *)0xC78014)
#define RDP_FETCH_ADDR		((unsigned short *)0xC78016)
#define READ_FETCH_ADDR		((unsigned short *)0xC78018)
#define ENET_LOAD_VECTOR	((unsigned short *)0xC7801A)

/* 
 *	These are the Register Address Port values which determine which 
 *	control/status register will be accessed next.
 */

#define CSR0_7990	0	/* select control/status register 0. */
#define CSR1_7990	1	/* select control/status register 1. */
#define CSR2_7990	2	/* select control/status register 2. */
#define CSR3_7990	3	/* select control/status register 3. */


/*
 *	Bit definitions for control/status register 0.
 */

#define ENET_ERROR	0x8000	/* error on ethernet transfer */
#define BABBLE		0x4000 	/* babble error (transmit > 1519) */
#define COLLISION	0x2000  /* Collision input failure. */
#define MISSED_PACKET	0x1000  /* missed packet error. */
#define MEM_ERR		0x800	/* memory error */
#define RX_INT		0x400 	/* receiver interrupt. */
#define TX_INT		0x200	/* transmitter interrupt. */
#define INIT_DONE	0x100	/* initialization sequence complete. */
#define INTR_ENET	0x80	/* interrupt pending */
#define ENET_INT_ENAB	0x40	/* interrupt enable */
#define RX_ON		0x20	/* receiver on */
#define TX_ON		0x10	/* transmitter on */
#define TX_DEMAND	0x8	/* transmit demand */
#define STOP_7990	0x4	/* stop the 7990 chip. */
#define START_7990	0x2	/* start i/o operations */
#define INIT_7990	0x1	/* do initialization sequence */

/*
 *	CSR1 and CSR2 contain the low word and high byte, respectively,
 *	of the pointer to the initialization block.
 */

/*
 *	Bit definitions for CSR3.
 *	For the MiniFrame this register never needs to be touched.
 */

#define BYTE_SWAP	0x4	/* indicates that byte swapping should be done */
#define ALE_CONTROL	0x2	/* 0 indicates ALE asserted high. */
#define BYTE_CONTROL	0x1	/* Byte mask and hold I/O pin definition. */

/*
 *	Bit definitions for mode register in initialization block.
 */

#define PROMISCUOUS	0x8000	/* set promiscuous receive mode. */
#define INTERNAL	0x40	/* set internal loopback mode, meaningful only if LOOPBACK bit = 1 */
#define RETRY_DISAB	0x20	/* disable automatic retry on collision. */
#define FORCE_COLLISION	0x10	/* test collision logic. */
#define TX_CRC_DISAB	0x8	/* disable CRC on transmit */
#define LOOPBACK	0x4	/* set loopback mode. */
#define TX_DISAB	0x2	/* disable the transmitter. */
#define RX_DISAB	0x1	/* disable the receiver. */

/*
 *	definitions for receive message descriptor 1 (RMD1).
 *	low byte is high byte of buffer address. 
 */

#define RX_OWN		0x8000	/* ownership bit, 0=host, 1=7990 */
#define RX_ERR		0x4000	/* error during the receive */
#define FRAME_ERR	0x2000
#define RX_OVFLOW	0x1000	/* overflow during receive. */
#define RX_ENCRC_ERR	0x800	/* CRC error on receive */
#define BUFFER_ERR	0x400	/* Out of buffers on receive */
#define	RX_STP		0x200	/* This buffer is start of packet. */
#define RX_ENP		0x100	/* This buffer is end of packet. */


/*
 *	definitions for transmit message descriptor 1 (TMD1)
 *	low byte is high byte of buffer address.
 */

#define TX_OWN		0x8000	/* ownership bit, 0=host, 1=7990 */
#define TX_ERR		0x4000	/* error during transmit */
				/* bit 13 is reserved, chip writes 0 */
#define TX_MORE		0x1000	/* more than one retry needed to transmit */
#define TX_ONE		0x800	/* exactly one retry was required. */
#define TX_DEFERRED	0x400	/* deferral was necessary. */
#define TX_STP		0x200	/* This buffer is start of packet. */
#define TX_ENP		0x100	/* This buffer is end of packet. */


/*
 *	definitions for Transmit Message Descriptor 3 (TMD3)
 */

#define TX_BUFFER_ERROR	0x8000	/* Can't get to next buffer and this isn't end*/
#define TX_UNDERFLOW	0x4000	/* data late from memory. */
				/* bit 13 is reserved, chip writes 0 */
#define LATE_COLLISION	0x1000	/* collision after slot time elapsed */
#define TX_CR_LOSS	0x800	/* carrier loss */
#define TX_RETRY_ERR	0x400	/* too many retries */
#define REFLECT_MASK	0x3FF	/* mask for time domain reflectometry count */

/*
 *	macros to provide the appropriate delays for using 7990 registers.
 */

#define ESETREG(reg, value) 	*RAP_WRITE_ADDR = reg;\
				asm("nop"); asm("nop");\
				*RDP_WRITE_ADDR = value;\
				asm("nop"); asm("nop");

#define EGETREG(reg, loc)	*RAP_WRITE_ADDR = reg;\
				asm("nop"); asm("nop");\
				*RDP_FETCH_ADDR = ACTIVATE;\
				asm("nop"); asm("nop");\
				loc = *READ_FETCH_ADDR;\
				asm("nop"); asm("nop");

#endif
