TITLE Monitor Memory Update
;
name monupd
;
pgroup group prog
dgroup group data
;
; data segment (dummy)
data segment word public 'data'
      extrn ssss:word, dsss:word
      extrn wr_buf:byte
data ends
;
      public M_update
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; Memupdate
;
prog segment byte public 'prog'
;
; M_update :
;   Update memory locations start from ssss.
;
      extrn steal_char_kb:near, put_str_kb:near
      extrn hexstr:near, get_hex:near
      extrn cr_:near, crlf_:near, clr_eoln:near, clr_scr:near
      extrn cur_up:near, cur_down:near, cur_fwd:near
      extrn bell_:near
      extrn up_arrow:abs, down_arrow:abs, upd_quit:abs
      extrn upd_rub:abs
      extrn seg_ovr:abs, cr:abs
      extrn upd_row:abs
;     extrn dot_quit:abs
;
M_update proc near
; Calculate the address relative to DS
; Loop until end
      call     clr_scr
      mov      dl, upd_row
      call     cur_down
M_upd_loop:
      call     M_upd_disp
      call     steal_char_kb
      cmp      dl, down_arrow
      jne      down_arr_jmp
; Down
      mov      dl, 1
      call     cur_down
      inc      ssss
      jmp      M_upd_lpend
down_arr_jmp:
      cmp      dl, up_arrow
      jne      up_arrow_jmp
; Up
      mov      dl, 1
      call     cur_up
      dec      ssss
      jmp      short M_upd_lpend
up_arrow_jmp:
      cmp      dl, upd_rub
      jne      rub_jmp
; Rub and enter
      call     rub_update
      jmp      short M_upd_lpend
rub_jmp:
      cmp      dl, upd_quit
      je       M_upd_end
; Error update code
      call     bell_
M_upd_lpend:
      jmp      M_upd_loop
M_upd_end:
      call     crlf_
      ret
M_update endp
;
; rub_update
;
rub_update proc near
rupd_loop:
      mov      dl, 10
      call     cur_fwd
      call     clr_eoln
      mov      cx, 2
      call     get_hex
; Exit code
      jc       hex_ok
      cmp      dl, cr
      jne      hex_quit
      call     cr_
      call     M_upd_disp
      jmp      short gh_lpend
hex_quit:
;     cmp      dl, dot_quit
;     jne      hex_err
      call     cr_
      jmp      short rupd_end
hex_ok:
; Store into memory
      push     ds
      lds      si, dword ptr ssss
      mov      [si], dl
      pop      ds
gh_lpend:
      call     crlf_
      inc      ssss
      call     M_upd_disp
      jmp      rupd_loop
rupd_end:
      ret
rub_update endp
;
; M_upd_disp
;
M_upd_disp proc near
      call     clr_eoln
; Display (DS)
      mov      dx, dsss
      mov      wr_buf, 5
      mov      di, offset wr_buf+1
      call     hexstr
      mov      byte ptr [di], seg_ovr
      mov      si, offset wr_buf
      call     put_str_kb
; Display ssss
      mov      dx, ssss
      mov      di, offset wr_buf+1
      call     hexstr
      mov      byte ptr [di], ' '
      mov      si, offset wr_buf
      call     put_str_kb
; Display content
      push     ds
      lds      si, dword ptr ssss
      mov      dl, [si]
      pop      ds
      mov      di, offset wr_buf
      call     hexstr
      mov      wr_buf+1, 2
      mov      si, offset wr_buf+1
      call     put_str_kb
      call     cr_
      ret
M_upd_disp endp
;
prog ends
;
end
