TITLE	Command Handler of Hard Disk


if1
%out Pass 1...
else
%out Pass 2...
endif

pgroup	group prog
dgroup	group data

include	\186\xinstr.mac
include	\gifi\rcd0.s86
include \gifi\gifmac.mac
include	src\hardisk.equ


data	segment word public 'data'
	extrn gdrv:byte, osmaddr:word, bytebuf:byte, fmtflg:byte
	extrn fmtunit:byte, fmtctlr:byte
	extrn dibsav:byte, dib:byte, tcmdbuf:byte
	extrn bbrtsav:byte, bbrtsec:dword, bbrt:byte, bbrtmp:byte
	extrn gifdic:dword

data	ends

prog	segment byte public 'prog'
	assume cs:pgroup, ds:dgroup, es:dgroup, ss:dgroup
	extrn showver:near, showdrv:near, crlf:near, dispchr:near
	extrn capschr:near, capsech:near, hexinp:near, hexout:near
	extrn cmdexit:near, ignexit:near
	extrn mapset:near, inixeb:near, hformat:near
	extrn chkbad:near, putbbrt:near, mrgbbrt:near


procedure H_cmd
	print	<'elp',esc,'H',esc,'JHard Disk Initialization Commands'>
	call	showver
irpc	p,123
	mov	dx, offset ds:H_msg&p
	mov	ah, prtmsg
	int	21h
	call	pagebrk
	jzm	hcexit
endm
	jmp	hcexit

H_msg1:
db lf
db lf
db cr,lf,'BASIC COMMANDS :'
db lf
db cr,lf,'H			Help - Print these instructions'
db lf
db cr,lf,'L			List the Format Specifications (DIB)'
db lf
db cr,lf,'R			Replace only the DIB'
db lf
db cr,lf,'F			Format the Hard Disk'
db lf
db cr,lf,'E m			Effective OS Map after quit'
db cr,lf,'			  m : Map Number (0-9)'
db lf
db cr,lf,'Q			Quit to the system'
db lf
db cr,lf,"^Z			Same as 'Q' but no confirmation"
db '$'
H_msg2:
db esc,'H',esc,'J'
db cr,lf,'DIB (Disk Identification Block) MODIFICATION COMMANDS :'
db lf
db cr,lf,"M m b s z o		Mapping of OS's:"
db cr,lf,'			  m : Map Number (0-9)'
db cr,lf,'			  b : Boot Offset'
db cr,lf,'			  s : Starting Absolute Sector'
db cr,lf,'			  z : Size in Sectors'
db cr,lf,'			  o : OS Name (2-char)'
db lf
db cr,lf,'C c p p p ...		Controller Parameters:'
db cr,lf,"			  c : Controller Code ('X' for XEBEC)"
db cr,lf,'			  p : One of the Parameter Bytes'
db cr,lf,"				(Enter '.' to terminate)"
db lf
db cr,lf,'S i s h c		Specifications of Disk Organization:'
db cr,lf,'			  i : Interleave Factor'
db cr,lf,'			  s : Number of Sectors per track'
db cr,lf,'			  h : Number of Heads'
db cr,lf,'			  c : Number of Cylinders'
db '$'
H_msg3:
db esc,'H',esc,'J'
db cr,lf,'BBRT (Bad-Block Remap Table) MANIPULATION COMMANDS :'
db lf
db cr,lf,'D			Display the BBRT (Bad-Block Remap Table)'
db lf
db cr,lf,'T s z			Test Bad Blocks and merge into the BBRT buffer:'
db cr,lf,'			  s : Start Absolute Sector'
db cr,lf,'			  z : Size in Sectors'
db lf
db cr,lf,'A b r b r b r ...	Add in Bad Blocks Manuelly:'
db cr,lf,'			  b : Bad Absolute Sector'
db cr,lf,"				(Enter '.' to terminate)"
db cr,lf,'			  r : Remap Sector'
db lf
db cr,lf,'P s			Put the BBRT the hard disk'
db cr,lf,'			  s : BBRT Sector'
db cr,lf,"				(Enter '.' for unchanged)"
db '$'
hcexit:
	jmp	cmdexit

pagebrk:
	print	<esc,'Y',' '+21,' '>
	anykey	"to continue or '.' to abort "
	cmp	al, '.'
	ret

H_cmd	endp


procedure L_cmd
	print	<'ist',esc,'H',esc,'JDisk Identification Block (DIB) of '>
	call	showdrv
	cmp	dibsav, 0
	jnz	lc1
	print	' (Unsaved)'
lc1:
	xor	cx, cx
	mov	cl, dib.nosm
	mov	di, offset es:dib.osm0
; OS Maps
	mov	dx, offset ds:lsm1
	mov	ah, prtmsg
	int	21h
	jmp	lsme1
lsm1:
db ' :',lf
db cr,lf,'Map    Boot    Start     Size OS'
db cr,lf,'--------------------------------'
db '$'
lsme1:
	mov	bytebuf, '0'
l1lp:
	push	cx
	print	<cr, lf, ' '>
	mov	al, bytebuf
	call	dispchr
	inc	bytebuf
	print	'     '
	hexoutz	4
	add	di, 2
	print	'   '
	hexoutz	6
	inc	di
	print	'   '
	hexoutz	6
	inc	di
	blank
	mov	al, [di]
	inc	di
	call	dispchr
	mov	al, [di]
	inc	di
	call	dispchr
	pop	cx
	loop	l1lp
; Hard Disk Parameters
	itlpar
	print	<cr,lf,lf,'Interleave'>
	hexoutz	2
	print	<cr,lf,'Sec/Trk '>
	hexoutz	4
	print	<cr,lf,'Heads   '>
	hexoutz	4
	print	<cr,lf,'Cyls    '>
	hexoutz	4
; Controller Parameter
	print	<cr,lf,lf,'Unit '>
	mov	al, fmtunit
	add	al, '0'
	call	dispchr
	print	<cr,lf,'Controller '>
	mov	al, fmtctlr
	add	al, '0'
	call	dispchr
	print	'    Parm : '
	hptpar
	mov	si, di
	cptpar
	mov	al, [di]
	inc	di
	mov	[si], al
	call	dispchr
	print	'  ['
	xor	cx, cx
	mov	cl, [di]
	inc	di
l2lp:
	push	cx
	blank
	hexoutm	2
	pop	cx
	loop	l2lp
	print	<' ]',cr,lf>
	jmp	cmdexit
L_cmd	endp


procedure R_cmd
	print	'eplace the DIB without formatting <Y/N> ? '
	confirm
	mov	ax, word ptr bbrtsec
	mov	word ptr dib.badr, ax
	mov	ax, word ptr bbrtsec[2]
	mov	word ptr dib.badr[2], ax
	mov	fmtflg, 0		; Indicating No Formatting
	call	crlf
	call	hformat
	jmp	cmdexit
R_cmd	endp


procedure F_cmd
	print	'ORMAT <Y/N> ? '
	confirm
	print	<cr, lf, 'Formatting -- Please Wait...',cr,lf>
	mov	fmtflg, -1
	call	hformat
	jmp	cmdexit
F_cmd	endp


procedure E_cmd
	print	'ffective OS Map '
	call	capsech
	sub	al, '0'
	jl	eovfl
	cmp	al, dib.nosm
	jl	ec1
eovfl:
	print	' Illegal'
	jmp	cmdexit
ec1:
	xor	ah, ah
	shl	ax, 1
	mov	si, ax
	mov	si, osmaddr[si]
	call	mapset
	jmp	cmdexit
E_cmd	endp


procedure Q_cmd
	print	'uit'
qcfm:
	mov	al, dibsav
	and	al, bbrtsav
	jnz	qcabort
	print	' with '
	cmp	dibsav, 0
	jnz	qc2
	print	'DIB'
	cmp	bbrtsav, 0
	jnz	qc1
	print	' and '
qc2:
	print	'BBRT'
qc1:
	print	' unsaved <Y/N> ? '
	confirm
qcabort:
	print	<cr, lf, 'Format Ended', cr, lf>
	stc
	ret
Q_cmd	endp


procedure M_cmd
	print	'ap '
	call	capsech
	sub	al, '0'
	jl	movfl
	cmp	al, dib.nosm
	jle	mc1
movfl:
	print	' Illegal'
	jmp	cmdexit
mc1:
	jl	mc4
; New OS Map
	cmp	al, numosm
	je	movfl
	print	'(New)'
	hptpar
	mov	si, di
	add	di, osmsize
	mov	cx, offset ds:dib[bps-1]
	sub	cx, di
	add	si, cx
	add	di, cx
	inc	cx
	std
	rep	movsb
	cld
	inc	si
	mov	di, si
	mov	cx, osmsize-2
	mov	al, -1
	rep	stosb
	mov	ax, nullosm
	stosw
	inc	dib.nosm
	add	dib.hpn, osmsize
	add	dib.cpn, osmsize
	mov	di, si
	jmp	short mc5
mc4:
	xor	ah, ah
	shl	ax, 1
	mov	di, ax
	mov	di, osmaddr[di]
mc5:
	prompt	': Boot Offset ', 4
	xor	ax, ax
	stosw
	prompt	', Start at ', 6
	xor	ax, ax
	stosb
	prompt	', Size ', 6
	xor	ax, ax
	stosb
	print	', OS '
	call	capschr
	cmp	al, cr
	jne	mc6
	mov	al, [di]
	call	dispchr
	mov	al, [di+1]
	call	dispchr
	jmp	mc2
mc6:
	call	dispchr
	stosb
	call	capsech
	cmp	al, cr
	jnz	mc3
	mov	al, ' '
mc3:
	stosb
mc2:
	mov	dibsav, 0
	jmp	cmdexit
M_cmd	endp


procedure C_cmd
	print	'ontroller Type = '
	cptpar
	call	capschr
	cmp	al, cr
	je	cc2
	mov	[di], al
cc2:
	mov	al, [di]
	hptpar
	mov	[di], al
	call	dispchr
	print	'  [ '
	xicpar
	hexinm	2
	mov	cx, 7		; 7 left
clp:
	push	cx
	blank
	hexinm	2
	pop	cx
	cmp	ah, abort
	jnz	cc1
	print	<bs,bs,bs>
	jmp	short clpend
cc1:
	loop	clp
clpend:
	print	' ] '
	sub	cx, 8
	neg	cx
	cplpar
	mov	[di], cl
	mov	dibsav, 0
	call	inixeb
	jmp	cmdexit
C_cmd	endp


procedure S_cmd
	print	'pecification: '
	itlpar
	prompt	'Interleave=', 2
	prompt	', Sec/Trk=', 4
	prompt	', Heads=', 4
	prompt	', Cyls=', 4
	mov	dibsav, 0
	jmp	cmdexit
S_cmd	endp


procedure D_cmd
	print	<'isplay the BBRT',cr,lf,lf>
	cmp	bbrt[3], -1
	jne	dc1
	print	'BBRT does not exist'
	call	crlf
	jmp	cmdexit
dc1:
	cmp	byte ptr bbrtsec[3], -1
	je	dc3
	print	'BBRT at Absolute Sector'
	mov	di, offset es:bbrtsec
	hexoutz	6
	cmp	bbrtsav, 0
	jnz	dc3
	print	'   (Unsaved)'
dc3:
	mov	di, offset es:bbrt
; Procedure Entry
bbrtdsp:
	mov	dx, offset ds:bbrtmsg
	mov	ah, prtmsg
	int	21h
	mov	bytebuf, 1
	jmp	short dclp
bbrtmsg:
db lf
db cr,lf,'No.   Bad Sector    Remap Sector'
db cr,lf,'--------------------------------',cr,lf
db '$'
dclp:
	cmp	word ptr [di], -1
	jne	dc2
	cmp	word ptr [di+2], -1
	je	dclpend
dc2:
	push	di
	mov	di, offset es:bytebuf
	hexoutm	2
	inc	bytebuf
	print	'     '
	pop	di
	hexoutz	6
	inc	di
	print	'          '
	hexoutz	6
	inc	di
	call	crlf
	jmp	dclp
dclpend:
	call	crlf
	jmp	cmdexit
D_cmd	endp


procedure T_cmd
	mov	di, offset es:tcmdbuf
	prompt	'esting Bad Blocks starting at Sector ', 6
	prompt	' for Size ', 6
	print	<cr,lf,'Please Wait'>
	mov	si, word ptr tcmdbuf
	mov	dl, tcmdbuf[2]
	mov	cx, word ptr tcmdbuf[3]
	mov	ah, tcmdbuf[5]
	mov	al, gdrv
	mov	di, offset es:bbrtmp
	call	chkbad
	jncm	tc2
; Overflow
	call	bbrtdsp
	print	<cr,lf,'More than 63 bad sectors.  Command ignored!'>
tovfl:
print <cr,lf,lf,'WARNING: THIS DISK IS VERY BAD.  PLEASE FORMAT IT AGAIN!'>
	jmp	cmdexit
tc2:
	cmp	bbrtmp[3], -1
	jne	tc1
	print	<cr,lf,lf,'No bad sectors in this range'>
	jmp	cmdexit
tc1:
	xor	ax, ax
	mov	dx, bbrtnew
	mov	bbrtsav, al
	mov	word ptr bbrtsec, dx
	mov	word ptr bbrtsec[2], ax
	mov	word ptr dib.badr, dx
	mov	dibsav, al
	mov	di, offset ds:bbrtmp
	call	bbrtdsp
; Merging
tcmerge:
	mov	si, offset ds:bbrtmp
	mov	di, offset es:bbrt
	call	mrgbbrt
	jnc	tcexit
	cmp	ah, mrgovfl
	jzm	tovfl
print <cr,lf,'WARNING: AMBIGUOUS REMAPPING.  PLEASE CHECK THE BBRT!'>
	jmp	cmdexit

tcexit:
	mov	bbrtsav, 0
	print	<cr,lf,'It has been merged to the BBRT buffer'>
	jmp	cmdexit
T_cmd	endp


procedure A_cmd
	print	'dd in Bad Blocks :'
	mov	dx, offset ds:bbrtmsg
	mov	ah, prtmsg
	int	21h
	mov	di, offset es:bbrtmp
	mov	cx, bps/2
	mov	ax, -1
	rep	stosw
	mov	bytebuf, 1
	mov	di, offset es:bbrtmp
	mov	cx, bbrtlen
aclp:
	push	cx
	push	di
	mov	di, offset es:bytebuf
	hexoutm	2
	inc	bytebuf
	print	'     '
	pop	di
	hexinm	6
	cmp	word ptr [di-3], -1
	jne	ac1
	cmp	byte ptr [di-1], -1
	jne	ac1
	pop	cx
	jmp	short aclpend
ac1:
	xor	al, al
	stosb
	print	'          '
	hexinm	6
	xor	al, al
	stosb
	cmp	word ptr [di-4], -1
	jne	ac2
	cmp	byte ptr [di-2], -1
	jne	ac2
	mov	byte ptr [di-1], -1
ac2:
	pop	cx
	call	crlf
	loop	aclp
aclpend:
	cmp	cx, bbrtlen
	jzm	ignexit
	jmp	tcmerge
A_cmd	endp


procedure P_cmd
	cmp	bbrt[3], -1
	jne	pc4
	print	'ut an empty BBRT!'
	jmp	ignexit
pc4:
	mov	di, offset es:bbrtsec
	prompt	'ut BBRT onto Sector ', 6
	mov	dx, word ptr bbrtsec
	mov	ah, byte ptr bbrtsec[2]
	cmp	ah, -1
	jne	pc1
	cmp	dx, -1
	jzm	ignexit
pc1:
	mov	byte ptr bbrtsec[3], 0
	cmp	dx, word ptr dib.badr
	jne	pc2
	cmp	ah, byte ptr dib.badr[2]
	je	pc3
pc2:
	mov	word ptr dib.badr, dx
	mov	byte ptr dib.badr[2], ah
	mov	byte ptr dib.badr[3], 0
	mov	dibsav, 0
pc3:
	call	crlf
	mov	dh, 80h
	dss	msgdmp
	mov	di, offset es:bbrt
	mov	al, gdrv
	mov	dx, word ptr bbrtsec
	mov	ah, byte ptr bbrtsec[2]
	call	putbbrt
	jc	pcerr
	mov	bbrtsav, -1
	jmp	short pcexit
pcerr:
	print	<cr,lf,lf,'Error in copying BBRT'>
pcexit:
	call	crlf
	xor	dh, dh
	dss	msgdmp
	jmp	cmdexit
P_cmd	endp


procedure CZ_cmd
	print	<cr, lf, 'End of File Encountered'>
	jmp	qcabort
CZ_cmd	endp


prog	ends

end
