TITLE	BBRT (Bad Block Remap Table) Utility Routines

; REMARK : Upon entering these routines, DS should be in DGROUP when it
;		is not an input parameter.

pgroup	group prog
dgroup	group data

include	\186\xinstr.mac
include	\gifi\gifmac.mac
include	\gifi\rcd0.s86


flag0	equ 4
flag1	equ 6

flag0v	equ 55ffh
flag1v	equ 00aah

bps	equ 512			; Byte per Sector
bbrtens	equ 8			; BBRT Entry Size
bbrtsen	equ bps/bbrtens-1	; BBRT Size in Entry


jnam	macro j
	local nj
	ja	nj
	jmp	j
nj:
endm

procedure	macro procname, nearfar
public	procname
procname	proc nearfar
endm

setosm	macro bootoff, basel, baseh, sizel, sizeh
	pusha
	mov	al, drive
	mov	bp, bootoff
	mov	di, basel
	mov	dh, baseh
	mov	cx, sizel
	mov	dl, sosmap
	push	es
	mov	es, bp
	gifcall	dskdev,sstatus,sizeh
	pop	es
	popa
endm

data	segment word public 'data'
	extrn gifdic:dword

drive	db ?

osmboot	dw ?
osmbasl	dw ?
osmbash	db ?
osmsizl	dw ?
osmsizh	db ?

bytebuf	db ?

cbsec	dw dmy		; CHKBAD upon end of each sector
cbbad	dw dmy		; CHKBAD upon bad sector

secbuf	db bps dup (?)
secbend	label byte

data	ends


prog	segment byte public 'prog'
	assume cs:pgroup, ds:dgroup, es:dgroup

dmy:
	ret


; SAVOSM	Save the OS Map
;	Input	: AL - Drive Number
;	Output	: DRIVE - Saved drive number
;	Destroy	: None
;	Remark	: This should be called before any OS Map setting
savosm	proc
	pusha
	push	es
	mov	drive, al
	gifcall	dskdev,reset,noopt
	mov	dl, gosmap
	gifcall	dskdev,gstatus,noopt
	mov	osmboot, es
	mov	osmbasl, di
	mov	osmbash, dh
	mov	osmsizl, cx
	mov	osmsizh, ah
	pop	es
	popa
	ret
savosm	endp


; RESOSM	Restore the OS Map (FCW are saved)
resosm	proc
	pushf
	setosm	osmboot, osmbasl, osmbash, osmsizl, osmsizh
	popf
	ret
resosm	endp


; RDDIB		Read the DIB from drive AL into [ES:DI]
;	Input	: AL - Drive Number
;		  ES:DI - DIB Buffer Pointer
;	Output	: AH - GIFDIC Error Code (0 means illegal DIB)
;		  CY - Set if error
;	Destroy	: None
procedure rddib
	push	cx
	push	dx
	call	savosm
	setosm	0,0,0,1,0
	xor	dx, dx
	mov	cx, 1
	gifcall	dskdev,read,noopt
	call	resosm
	jnc	rd1
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
	jmp	short rderr
rd1:
	cmp	word ptr [di.flag0], flag0v
	jne	rderr
	cmp	word ptr [di.flag1], flag1v
	clc
	je	rdexit
rderr:
	stc
rdexit:
	pop	dx
	pop	cx
	ret
rddib	endp


; WRDIB		Write the DIB into drive AL from [ES:DI]
;	Input	: AL - Drive Number
;		  ES:DI - DIB Buffer Pointer
;	Output	: AH - GIFDIC Error Code (0 means illegal DIB)
;		  CY - Set if error
;	Destroy	: None
procedure wrdib
	xor	ah, ah
	cmp	word ptr [di.flag0], flag0v
	jne	wderr
	cmp	word ptr [di.flag1], flag1v
	jne	wderr
;
	push	cx
	push	dx
	call	savosm
	setosm	0,0,0,1,0
	xor	dx, dx
	mov	cx, 1
	gifcall	dskdev,write,noopt
	jnc	wd1
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
	stc
wd1:
	call	resosm
	pop	dx
	pop	cx
	jmp	short wdexit
;
wderr:
	stc
wdexit:
	ret
wrdib	endp


; CHKBAD	Check the bad sectors on drive AL from sector DL+SI
;		for AH+CX sectors.  The BBT is put into [ES:DI].
;	Input	: AL - Drive Number
;		  DL+SI - Start Sector Absolute Address
;		  AH+CX - Sector Count
;	Output	: CY - Set if BBT overflow
;	Destroy	: None
procedure chkbad
	pusha
	call	savosm
	setosm	0,0,0,-1,-1	; Maximum count

; Disable Retry and ECC shsould be here

	xor	bx, bx
	mov	bl, dl
	mov	dx, si
	mov	si, offset ds:secbuf
	jcxz	chknest
chklp:
	stc
	call	cbsec
	jncm	cbcopy		; Abort
	push	bx
	shlbl	3
	and	al, 7
	or	al, bl
	push	ax
	push	cx
	mov	cx, 1
	gifcall	dskdev,read,noopt
	jnc	cb3
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
	stc
cb3:
	pop	cx
	pop	ax
	pop	bx
	jnc	chklpend
; Bad-Sector Found
	cmp	si, (offset ds:secbend)-bbrtens
	stc
	jz	cbcopy		; BBT Overflow
	mov	[si], dx
	mov	[si+2], bx
	mov	word ptr [si+4], -1
	mov	word ptr [si+6], -1
	call	cbbad
	add	si, bbrtens
chklpend:
	add	dx, 1
	adc	bl, bh		; BH=0
	loop	chklp
chknest:
	cmp	ah, 0
	jle	cb2
	dec	ah
	jmp	chklp
cb2:
	clc

; Copy the BBT
cbcopy:
	pushf
	mov	cx, si
	mov	si, offset ds:secbuf
	sub	cx, si
	push	cx
	rep	movsb
	pop	cx
	sub	cx, bps
	neg	cx
	mov	al, -1
	rep	stosb
	popf

cbexit:
	call	resosm
	popa
	ret
chkbad	endp


; SETCHKB	Set PGROUP external-routine addresses for CHKBAD
;	Input	: AX - CBSEC
;		  BX - CBBAD
;	Output	: None
;	Destroy	: None
procedure setchkb
	cmp	ax, -1
	je	sc1
	mov	cbsec, ax
sc1:
	cmp	bx, -1
	je	sc2
	mov	cbbad, bx
sc2:
	ret
setchkb	endp


; GETBBRT	Read the BBRT on drive AL into [ES:DI]
;	Input	: AL - Drive Number
;		  ES:DI - BBRT buffer pointer
;	Output	: AH - GIFDIC Error Code
;		  AH+DX - BBRT absolute sector address
;		  CY - Set if error
;	Destroy	: None
;	Error	: 00 - Illegal DIB
;		  FF - BBRT not exist
procedure getbbrt
	push	cx
	call	savosm
; Load DIB
	setosm	0,0,0,1,0
	xor	dx, dx
	mov	cx, 1
	gifcall	dskdev,read,noopt
	jnc	gb2
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
	jmp	short gberr
gb2:
	cmp	word ptr [di.flag0], flag0v
	jne	gberr
	cmp	word ptr [di.flag1], flag1v
	jne	gberr
	mov	dx, word ptr [di.badr]
	mov	ah, byte ptr [di.badr+2]
	cmp	dx, -1
	jne	gb1
	cmp	ah, -1
	je	gberr
gb1:
; Load BBRT
	mov	bytebuf, ah
	mov	al, drive
	shlah	3
	or	al, ah
	mov	cx, 1
	setosm	0,0,0,-1,-1	; Maximum count
	gifcall	dskdev,read,noopt
	jnc	gb3
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
gberr:
	stc
	jmp	short gbexit
gb3:
	mov	ah, bytebuf
gbexit:
	call	resosm
	mov	al, drive
	pop	cx
	ret
getbbrt	endp


; PUTBBRT	Write the BBRT onto absolute sector DL+SI in
;		drive AL from [ES:DI]
;	Input	: AL - Drive Number
;		  AH+DX - BBRT absolute sector address
;		  ES:DI - BBRT buffer pointer
;	Output	: AH - GIFDIC Error Code
;		  CY - Set if error
;	Destroy	: None
procedure putbbrt
	push	cx
	call	savosm
	setosm	0,0,0,-1,-1
	shlah	3
	or	al, ah
	mov	cx, 1
	gifcall	dskdev,write,noopt
	jnc	pb1
	push	ax
	gifcall	dskdev,reset,noopt
	pop	ax
	stc
pb1:
	call	resosm
	mov	al, drive
	pop	cx
	ret
putbbrt	endp



; MRGBBRT	Merge the BBT in [DS:SI] into the one in [ES:DI]
;		and sort it.
;	Input	: DS:SI source BBT pointer
;		  ES:DI destination BBT pointer
;	Output	: CY - if entries overflow (more than 63)
;	Destroy	: None
;	Error	: 0 - No error
;		  1 - Entries Overflow
;		  2 - Same bad sector maps differently
ovfl	equ 1
samap	equ 2
procedure mrgbbrt
	push	ds
	pusha

	mov	bx, si		; Save SI
	mov	dx, di		; Save DI
	xor	cx, cx
; Scan Source BBT Loop
scslp:
	cmp	word ptr [bx+2], -1
	jne	scslpend
	cmp	word ptr [bx], -1
	je	scslpex
scslpend:
	add	bx, bbrtens
	inc	cx
	cmp	cx, bbrtsen
	jbe	scslp
; Overflow
	jmp	short mbov
scslpex:
; Scan Destination BBRT Loop
scdlp:
	cmp	word ptr es:[di+2], -1
	jne	scdlpend
	cmp	word ptr es:[di], -1
	je	scdlpex
scdlpend:
	add	di, bbrtens
	inc	cx
	cmp	cx, bbrtsen
	jbe	scdlp
; Overflow
mbov:
	mov	ah, ovfl
	stc
	jmp	mbexit
scdlpex:

; COPY:	SI at source begin; BX at source end; DI at destination end
	mov	cx, bx
	sub	cx, si
	rep	movsb
	lea	bx, [di-bbrtens]

	mov	ax, es
	mov	ds, ax
; SORT:	In DS(=ES) Segment, DX points to the first entry;
;	Within the Loop, BX points to the last one;
;	Method used : Bobble sort 
;		AX+CX - Current Min Value
;		SI - Current Min Pointer
;		DI - Current Compare Pointer
;		DX moving downward (Higher address)
;		Entries above DX are sorted
sortlp1:
	cmp	bx, dx
	jnam	sortlp1ex
	mov	si, bx
	lea	di, [bx-bbrtens]
	mov	cx, [si]
	mov	ax, [si+2]
sortlp2:
	cmp	cx, [di]
	ja	sortxchg2
	jb	sort3
; Lower word equal
	cmp	ax, [di+2]
	ja	sortxchg2
	jb	sort3
; Entry equal
	mov	cx, [si+4]
	mov	ax, [si+6]
	cmp	cx, [di+4]
	jne	sort1
	cmp	ax, [di+6]
	je	sortxsi
; Remap not the same. Check which is null
sort1:
	cmp	ax, -1
	jne	sort5
	cmp	cx, -1
	je	sortxsi
sort5:
	cmp	word ptr [di+6], -1
	jne	sort6
	cmp	word ptr [di+4], -1
	je	sort7
sort6:
	mov	ah, samap
	stc
	jmp	short mbexit
sort7:
	mov	[di+4], cx
	mov	[di+6], ax
; SORTXSI	Same remap, cancel [SI]
;	If SI=BX (last entry), simply delete [BX]
;	Otherwise, copy [BX] to [SI] before deleting
;	Condition: DI<SI<=BX
sortxsi:
	cmp	si, bx
	jae	sort4
	xchg	di, bx
	xchg	si, di
	mov	cx, bbrtens/2
	rep	movsw
	sub	si, bbrtens
	mov	di, bx
	mov	bx, si
; Fill [BX] with FF's and decreament BX by one entry
sort4:
	mov	ax, -1
	mov	cx, bbrtens/2
	xchg	bx, di
	rep	stosw
	xchg	bx, di
	sub	bx, 2*bbrtens
; SORTXSI ENDP
sortxchg2:
	cmp	di, dx
	jbe	sortlp1end
	mov	si, di
	mov	cx, [si]
	mov	ax, [si+2]
sortlp2end:
	sub	di, bbrtens
	jmp	sortlp2
sort3:
	cmp	di, dx
	ja	sortlp2end
	xchg	cx, [di]
	xchg	ax, [di+2]
	mov	[si], cx
	mov	[si+2], ax
	mov	cx, [si+4]
	mov	ax, [si+6]
	xchg	cx, [di+4]
	xchg	ax, [di+6]
	mov	[si+4], cx
	mov	[si+6], ax
sortlp1end:
	add	dx, bbrtens
	jmp	sortlp1

sortlp1ex:
	xor	ah, ah


mbexit:
	mov	dx, dgroup
	mov	ds, dx
	mov	bytebuf, ah
	popa	
	mov	ah, bytebuf
	pop	ds
	ret
mrgbbrt	endp


prog	ends

end
e

b

