	page	60,80
TITLE INITIAL I/O INTERFACE FOR UNIX

	include	gifdic.mac
	include	xinstr.mac	;80186.mac
	.lall				; list macro expansion

csb_main	struc

devno	db ?		; device number
devtyp	db ?		; major device type ( 0 = tty, 1 = disc, 2 = rtc
device	dw ?		; device description
maxrq	db ?		; max simultanious requests
nowrq	db ?		; current request count

csb_main	ends

csb_disk	struc

secsize	dw ?		; physical sector size
sizmsw	dw ?		; msb of last sector
sizlsw	dw ?		; last sector number
sectrk	dw ?		; sectors per track
headno	dw ?		; number of heads
	dw 2 dup (?)
errcod	dw ?		; error status code
	dw ?		; spare error status

	dw 4 dup (?)

csb_disk	ends


csb_tty	struc

	dw 7 dup (?)
conerr	dw ?
	dw ?

	dw 4 dup (?)

csb_tty	ends


crb_main	struc

rdevno	db ?		; request on device number
rdevtyp	db ?		; request on major device type
comand	dw ?		; operation code
rqcount	dw ?		; request count
com1	dw ?		; 1st parameter
com2	dw ?		; 2nd parameter
com3	dw ?		; 3rd parameter
com4	dw ?		; 4th parameter
com5	dw ?		; 5th parameter
com6	dw ?		; 6th parameter
	dw ?
	dw ?

crb_main	ends


PGROUP	GROUP	PROG

debug	equ	0			; option unix/debug io
				; 0 = unix ??

stmmcpu segment at 0b000h
stmrf	equ	0bbh			; register file access
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu	segment at 4000h
mmcrf	equ	043h
	org	0
ssp0	dw ?
ssp1	dw ?
pc0	dw ?
pc1	dw ?
mmcpu ends

mailbox segment at 4000h
mailrf	equ	043h			; register file access

		; CRB progress flags
	org	0400h
mailstart	db ?
	db ?
	db ?
start	db ?		; unix, active = 1, start request

	db ?
	db ?
	db ?
busy	db ?		; syscon, active = 0, request in progress

	db ?
	db ?
	db ?
done	db ?		; syscon, active = 1, request complete

	db ?
	db ?
	db ?
ready	db ?		; unix, active = 0, acknowledge completion

	db ?
	db ?
	db ?
status	db ?		; syscon, active = 1, status report on task

	db ?
	db ?
	db ?
gotst	db ?		; unix, active = 0, status received

	db ?
	db ?
	db ?
abort	db ?		; unix, active = 1, abort task

	db ?
	db ?
	db ?
aborted	db ?		; syscon, active = 0, aborted task


		; CSB starts
	org	0420h

csb1	csb_main	<>
	csb_disk	<>	; csb1.device 1 = disk drive

csb2	csb_main	<>
	csb_tty		<>	; device 2 = console tty

csb3	csb_main	<>
	csb_tty		<>	; device 3 = dte

csb4	csb_main	<>
	csb_tty		<>	; device 4 = dce





	org	0500h
			; start of CRBs

crb1	crb_main	<>	; initially the disk crb

crb2	crb_main	<>	; initially the console out

crb3	crb_main	<>	; initially the console in

crb4	crb_main	<>	; initially the dte out

crb5	crb_main	<>	; initially the dte in

crb6	crb_main	<>	; initially the dce out

crb7	crb_main	<>	; initially the dce in

	org	06e0h
	db ?
inptr	db ?
	db ?
outptr	db ?

	org	06f0h
fifo	db 256 dup(?)




	org	07f0h
			; byte space for simple io
charin	db ?
charout db ?

	org	07fch
bytein	db ?
flagin	db ?
bytout	db ?		; output byte
flagout	db ?		; bit 0 = output

mailbox	ends


		; my equates for the interface

unix_drive	equ	3		; use drive D:

unix_start	equ	0800h		; starting address
unix_stack	equ	0800h		; initial stack pointer

rfport	equ	0e204h			; access to register file
rfdma	equ	0e206h			; access to dma r file

cr	equ	0dh
lf	equ	0ah
etx	equ	04h

exit	equ	4c00h

crb_size	equ	32		; size of one crb
crbmax	equ	7
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	assume cs:pgroup

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;
;
	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;
	mov	al,unix_drive

	mov	bx,dskdev
	gifcall ,reset,0		; reset the disk
;
;
	mov	dx,rfport		; register file port
	mov	al,mmcrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mmcpu		; access address
	mov	ds,ax
	assume	ds:mmcpu

	mov	cl,8			; for swap
	mov	ssp0,0			; initial stack pointer upper
	mov	ssp1,unix_stack		; initial stack
	ror	ssp1,cl			; swap
	mov	pc0,0			; initial code start upper
	mov	pc1,unix_start		; initial code start
	ror	pc1,cl			; swap


	call	set_mail		; point to mailboxes
	assume	ds:mailbox

	xor	ax,ax			; zero ax
	mov	di,offset mailbox:mailstart
	mov	cx,200h			; 400h - 7ffh / 2
	push	ds
	pop	es
	rep	stosw			; clear mailboxes

	mov	bx,0ffh
	mov	busy,bl
	mov	gotst,bl
	mov	aborted,bl

	mov	cl,8

	mov	csb1.devno,1
	mov	csb1.devtyp,1
	mov	csb1.device,0
	mov	csb1.maxrq,1
	mov	csb1.nowrq,0
	mov	csb1.secsize,512
	ror	csb1.secsize,cl		; swap
	mov	csb1.sizmsw,0
	mov	csb1.sizlsw,088aah
	ror	csb1.sizlsw,cl		; swap
	mov	csb1.sectrk,11
	ror	csb1.sectrk,cl
	mov	csb1.headno,6
	ror	csb1.headno,cl		; swap
	mov	csb1.errcod,0

	mov	csb2.devno,2
;	mov	csb2.devtyp,0
;	mov	csb2.device,0
	mov	csb2.maxrq,2
;	mov	csb2.nowrq,0

	mov	csb3.devno,3
;	mov	csb3.devtyp,0
;	mov	csb3.device,0
	mov	csb3.maxrq,2
;	mov	csb3.nowrq,0

	mov	csb4.devno,4
;	mov	csb4.devtyp,0
;	mov	csb4.device,0
	mov	csb4.maxrq,2
;	mov	csb4.nowrq,0

	mov	crb1.rqcount,0
	mov	crb2.rqcount,0
	mov	crb3.rqcount,0
	mov	crb3.rqcount,0
	mov	crb4.rqcount,0


	mov	flagin,01		; no input
					; all mailbox set up.


	push	cs
	pop	es
	mov	di,offset signon	; say hello to the folks
	call	ptext


	mov	dx,rfport		; start up the 68k cpu
	mov 	al,stmrf
	out	dx,al
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu
	mov	ax,stmmcpu0

	mov	cs:pending,0		; no done pending

domailbox:			; check round the mailboxes

	call	set_mail		; point to mailboxes
	assume	ds:mailbox

	test	flagout,01h		; any output ?
	jz	no_bytes
	mov	al,bytout		; get it
	push	ds
	gifcall	kvddev,write,waitnr	; print it
	pop	ds
	and	flagout,0feh		; clear flag
no_bytes:

	test	flagin,01h		; input
	jnz	no_inbyte
	push	ds
	gifcall	kvddev,read,noopt	; read it
	pop	ds
	jc	no_inbyte
	mov	ds:bytein,al
	or	ds:flagin,01
no_inbyte:

	mov	si,cs:concnt		; get pointer
reconout:
	cmp	si,cs:consiz		; anything ??
	jz	noconout
	mov	al,cs:[si]
	gifcall	kvddev,write,noopt	; try to output it
	jc	noconout

	inc	cs:concnt
	inc	si			; point to next
	jmp	reconout

noconout:

	mov	si,cs:dtecnt		; get pointer
redteout:
	cmp	si,cs:dtesiz		; anything ??
	jz	nodteout
	mov	al,cs:[si]
	gifcall	dtedev,write,noopt	; try to output it
	jc	nodteout

	inc	cs:dtecnt
	inc	si			; point to next
	jmp	redteout

nodteout:

	mov	si,cs:dcecnt		; get pointer
redceout:
	cmp	si,cs:dcesiz		; anything ??
	jz	nodceout
	mov	al,cs:[si]
	gifcall	dcedev,write,noopt	; try to output it
	jc	nodceout

	inc	cs:dcecnt
	inc	si			; point to next
	jmp	redceout

nodceout:

	mov	ah,0

	mov	al,ready		; 0 if no activity
	and	done,al			; then clear any at idle

	mov	al,start		; get any
	mov	bl,cs:pending		; waiting for no start
	and	cs:pending,al		; update pending if no start
	xor	bl,cs:pending		; whats new ?
	xor	busy,bl			; clear busy
	xor	done,bl			; set done

	not	al
	and	busy,al			; force busy if start

	mov	al,busy			; get it
	or	al,cs:pending		; pick out actions required

	xor	al,0ffh			; inverse logic
	jnz	do_this_bit
	jmp	domailbox
do_this_bit:
	mov	cx,crbmax		; how many matter

	mov	si,offset mailbox:crb1	; point to first crb

	mov	bx,1

check_crb:
	test	ax,bx			; this crb ?
	jz	not_this
	pusha				; save the state
	call	do_crb			; do the crb
	pushf
	call	set_mail		; point to mailbox again
	popf
	popa				; restore all
	jc	not_this		; not finished
	or	cs:pending,bl		; flag it done
	xor	ax,bx			; clear this bit
	jnz	not_this
	jmp	domailbox		; any more bits ??
not_this:
	shl	bx,1			; next bit
	add	si,crb_size		; point to next
	loop	check_crb		; do all crbs
	jmp	domailbox		; repeat


do_crb:
	cmp	[si].rdevtyp,00		; tty ??
	jnz	notcon
	jmp	console
notcon:
	cmp	[si].rdevtyp,01		; disk ??
	jz	is_disk
	call	badcrb
	clc
	ret				; clear request and exit

is_disk:
	cmp	[si].devno,01		; disk csb
	jz	gooddev
	cmp	[si].devno,02
	jz	gooddev
	call	badcrb
	clc
	ret				; error exit
gooddev:
	mov	al,[si].devno
	mov	cs:drvno,al		; save number
	mov	ax,[si].comand		; get command\
	cmp	al,01			; disk command ?
	jnz	baddisk
	and	ah,7fh			; mask flush bit
	cmp	ah,01			; read
	jz	disk_read
	cmp	ah,02
	jz	disk_write
baddisk:
	call	badcomand
	clc
	ret

disk_read:
	call	set_disk		; test & set parameters
	mov	dx,rfdma		; own rf
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	cmp	cs:drvno,01
	jz	isdrva
	mov	al,1			; drive b:
isdrva:
	gifcall	dskdev,read,noopt	; do it
	jmp	disk_exit

disk_write:
	call	set_disk		; test & set parameters
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	cmp	cs:drvno,01
	jz	isdrv1
	mov	al,01
isdrv1:
	gifcall	dskdev,write,noopt	; do it
	jmp	disk_exit

console:
	cmp	[si].rdevno,02		; console device ??
	jz	ok_con
	cmp	[si].rdevno,03		; dte
	jz	ok_dte
	cmp	[si].rdevno,04		; dce
	jz	ok_dce
	call	badcrb
	clc
	ret
ok_con:
	mov	bx,kvddev
	cmp	[si].comand,0302h	; fifo mode
	jnz	notconfin
	jmp	dtefin
notconfin:
	cmp	[si].comand,0102h	; input ?
	jz	conin
	cmp	[si].comand,0202h	; output ??
	jnz	notconout
	jmp	conout
notconout:
	call	badcomand
	clc
	ret

ok_dte:
	mov	bx,dtedev
	cmp	[si].comand,0302h	; fifo mode
	jz	dtefin
	cmp	[si].comand,0102h	; input ?
	jz	dtein
	cmp	[si].comand,0202h	; output ??
	jnz	baddte
	jmp	dteout
baddte:
	call	badcomand
	clc
	ret

ok_dce:
	mov	bx,dtedev
	cmp	[si].comand,0302h	; fifo mode
	jnz	notdcefin
	jmp	dtefin
notdcefin:
	cmp	[si].comand,0102h	; input ?
	jnz	tryother
	jmp	dcein
tryother:
	cmp	[si].comand,0202h	; output ??
	jnz	baddce
	jmp	dceout
baddce:
	call	badcomand
	clc
	ret

conin:
	push	ds
	gifcall	kvddev,read,noopt	; try it
	pop	ds
	jc	no_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
no_input:
	ret

dtein:
	push	ds
	gifcall	dtedev,read,noopt	; try it
	pop	ds
	jc	dte_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dte_input:
	ret


dtefin:			; input to fifo
	push	bx
	mov	cx,8

	mov	ax,[si].com1		; in pointer
	mov	bx,[si].com2		; out pointer
	mov	dx,[si].com3		; fifo size
	ror	ax,cl
	ror	bx,cl
	ror	dx,cl			; adjust hi lo
	mov	cx,bx
	pop	bx
	push	ax			; old pointer
	inc	ax			; next
	cmp	ax,dx			; wrap round ?
	jnz	nowrap
	xor	ax,ax			; restart
nowrap:
	push	ax			; next pointer
	cmp	ax,cx			; pointers same ??
	jnz	tryinput
fifexit:
	pop	ax
	pop	ax			; clear stack
	stc				; not finished
	ret

tryinput:
	push	ds
	gifcall	,read,noopt		; bx is channel
	pop	ds
	jc	fifexit			; no data
	push	ax
	push	si			; save pointer to crb
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	si			; recover crb
	pop	ax			; recover data
	pop	dx			; new pointer
	pop	bx			; old pointer
	mov	es:[bx.di],al		; set it up
	mov	bl,dh			; save pointer
	mov	bh,dl			; with swap
	call	set_mail		; restore mailboxes
	mov	[si].com1,bx		; new pointer
	stc
	ret				; not finished

dcein:
	push	ds
	gifcall	dcedev,read,noopt	; try it
	pop	ds
	jc	dce_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dce_input:
	ret


conout:
	mov	ax,cs:concnt		; pointer
	cmp	ax,cs:consiz		; busy ?
	jnz	con_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:conbuf
	mov	cs:consiz,cx
	mov	cs:concnt,offset pgroup:conbuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:conbuf
	pop	cx
	rep	movsb
	clc
	ret

con_busy:
	stc
	ret				; return busy

dteout:
	mov	ax,cs:dtecnt		; pointer
	cmp	ax,cs:dtesiz		; busy ?
	jnz	dte_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:dtebuf
	mov	cs:dtesiz,cx
	mov	cs:dtecnt,offset pgroup:dtebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dtebuf
	pop	cx
	rep	movsb
	clc
	ret

dte_busy:
	stc
	ret				; return busy

dceout:
	mov	ax,cs:dcecnt		; pointer
	cmp	ax,cs:dcesiz		; busy ?
	jnz	dce_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:dcebuf
	mov	cs:dcesiz,cx
	mov	cs:dcecnt,offset pgroup:dcebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dcebuf
	pop	cx
	rep	movsb
	clc
	ret

dce_busy:
	stc
	ret				; return busy


set_addr:				; point to vme address
	call	get_addr		; calculate
	mov	dx,rfport		; rf port address
	out	dx,al			; set up rf
	ret				; done

get_addr:				; calculate vme address

	mov	cx,8			; for byte swap
	mov	ax,[si]			; upper address
	ror	ax,cl
	add	ax,40h			; start address offset on vme
	and	ax,00f8h		; upper 5 bits
	mov	bx,[si+4]		; vme access code
	ror	bx,cl
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	mov	bx,[si]			; upper address
	ror	bx,cl
	mov	dx,[si+2]		; lower address
	ror	dx,cl
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,[si+2]		; lower address
	mov	cx,8
	ror	di,cl
	and	di,0fh			; offset
	ret



set_disk:
	push	si			; save our pointer
	lea	si,[si].com4		; address data
	call	get_addr		; get vme data
	pop	si
	mov	cx,8			; byte swap
	mov	bx,[si].com3		; sector count
	ror	bx,cl
	push	bx
	mov	bx,[si].com2		; start sector number
	ror	bx,cl
	pop	cx
	ret

disk_exit:
	push	ax
	call	set_mail		; point to mail boxes
	pop	ax
	mov	al,0			; not valid status in al
	mov	csb1.errcod,ax		; send it
	clc
	ret

set_mail:				; access mailboxes
	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	ret
errfull:
	mov	di,offset fifoflow
	jmp	perr

badcrb:
	mov	di,offset crberr
	jmp	perr
badcomand:
	mov	di,offset comerr
	jmp	perr
badsect:
	mov	di,offset secerr
	jmp	perr
baddev:
	mov	di,offset deverr
	jmp	perr
badtype:
	mov	di,offset typerr

perr:
ptext:		; print all characters from es:di to 04h ( etx )
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	gifcall	kvddev,write,waitnr	; print 1, no return till done
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	ret


signon:	db	lf,lf,cr,'1st level UNIX I/O System',cr,lf
	db	'Starting UNIX now.',lf,cr,etx

crberr:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disc sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disc device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disc type.',cr,lf,etx

fifoflow:	db	'.',etx

;
gifdic	label	dword
gifl	dw	?
gifh	dw	?
;
;
drvno	db	?
	db ?
	db ?
	db ?
pending db ?

conbuf	db	400h dup (?)	; output buffer
concnt	dw	?
consiz	dw	?

dtebuf:	db	400h dup (?)	; output buffer
dtecnt	dw	?
dtesiz	dw	?

dcebuf:	db	400h dup (?)	; output buffer
dcecnt	dw	?
dcesiz	dw	?

		; space for system stack

	dw	80h dup (?)
STACKE:

PROG	ENDS

	end	begin		; program start address
