TITLE MMCPU 68000 DEBUGGER

	include	gifdic.mac
	include	80186.mac

openfile equ 0fh
readfile equ 14h
setdma equ 1ah
prtmsg	equ 9
exit equ 4c00h
cr	equ 0dh
lf	equ 0ah

stmmcpu segment at 0b000h
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu segment at 04000h
	org	03feh
crtdat	db ?
	org	03ffh
flags   db ?
	org	03fch
kbddat  db ?
mmcpu ends

vector  segment at 4000h
	org	0
vector ends

code segment
	assume cs:code

start:
	xor	cx,cx
	int	99h
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax

	push	cs
	pop	ds
	lea	dx, filename
	mov	ah, openfile
	int	21h
	jc	filerror
; File opened
	mov	bx, ax
	lea	dx, wtmsg
	mov	ah, prtmsg
	int	21h

savefile:
	mov	dx, 0e204h
	mov	ax, 43h
	out	dx, al
	mov	ax,04000h
	mov	ds,ax
	mov	dx, 0
read_loop:
	push	ds
	push	dx
	mov	ah,setdma
	int	21h
	push	cs
	pop	ds
	mov	dx,offset cs:filename
	mov	ah,readfile
	int	21h
	pop	dx
	pop	ds
	add	dx,80h
	cmp	al,0
	jz	read_loop
	mov	ax,seg vector
	mov	ds,ax
	assume  ds:vector
	mov	dx, 0e204h
	mov 	ax, 043h
	out	dx, al

	mov	dx, 0e204h
	mov 	ax, 0bbh
	out	dx, al
	mov	ax, seg stmmcpu
	mov	ds, ax
	assume	ds:stmmcpu
	mov	ax, stmmcpu0
	call	sendmes
	mov	ax, seg mmcpu
	mov	ds, ax
	assume	ds:mmcpu

	mov	dx, 0e204h
	mov	ax, 43h
	out	dx, al
	jmp	rdwait
filerror:
	jmp	filerr			; staging post
rdwait:
;	mov	wrtprt,al
	test	byte ptr [flags], 1
	jz	wrtwait
	mov	al, crtdat
	and	byte ptr [flags], 0feh
	push	ax
	push	bx
	push	cx
	gifcall	kvddev,write,waitrdy
	pop	cx
	pop	bx
	pop	ax
;	jmp	rdwait
wrtwait:
	test	byte ptr [flags],2
	jne	rdwait
	gifcall	kvddev,read,noopt
	jc	rdwait
	mov	kbddat, al
	or	byte ptr[flags], 02h
	mov	ax, 0
	jmp	rdwait

ending:
	mov	ax, exit
	int	21h


filerr:
	lea	dx, filerrmsg
	mov	ah, prtmsg
	int	21h
	jmp	ending
sendmes:
	push	ds
	push	dx
	push	cs
	pop	ds
	lea	dx, okmsg
	mov	ah, prtmsg
	int	21h
	pop	dx
	pop	ds
	ret

gifdic	label	dword
gifl	dw ?
gifh	dw ?


filename db 0,'68KDEBUGBIN',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
filerrmsg db 'FILE ERROR!', cr, lf, '$'
wtmsg db '68000 DEBUGGER.', cr, lf, 'Loading on MMCPU at offset 0.$'
okmsg db cr, lf, 'DEBUGGER LOADED$'

code ends

stack segment stack
	dw	80 dup (?)
stack ends

end start
