TITLE -- THIS IS THE MODULE CONTAINING ROUTINES TO SWITCH BETWEEN
;	 DIFFERENT MODES



include xinstr.mac
include texin.equ
include ledtor.equ
pgroup group prog

	public nchrhdlr
prog segment byte public 'prog'

	assume cs:pgroup

	extrn dispchr:near, dispubuf:near, shbufl:near

; function : to switch among different modes in the editor
; input parameter : al -- the input character
; output parameter : nil , CY if error
; destroyed : bx, di, ax if it is a control code


nprocedure lookcct

	push si
	push cx
	mov si, [bp.cctptr]	; get the CCT base address
	mov cx, ss:[si]		; get # of entries in the table
	inc si
	inc si
lpsearchtab:			; use a loop to compare character in the table
	cmp byte ptr ss:[si], al
	je jmphdlr	; if a character is matched, try to jump to its handler
	inc si
	inc si
	loop lpsearchtab
	cmp al, ctlfirst	     ; check whether al content within
				     ; control char bound
	jl lookcctcont
	cmp al, ctllast
	jg lookcctcont
	stc
	jmp lookcctret
lookcctcont:
	jmp word ptr ss:[bp.curmode] ; if no character is matched, give it the
				     ; last chance to be interpreted by the
				     ; handler of current mode
jmphdlr:
	xor bx, bx	; use the control code as index into the handler add.
			; table
	mov bl, ss:[si+1]
	shl bl, 1
	add bx, offset pgroup:cchdlrtab
	jmp word ptr cs:[bx]
lookcctret:
	pop cx
	pop si
	ret
lookcct endp


cchdlrtab  dw  offset pgroup:bolhdlr	; beginning of line handler
	   dw  offset pgroup:eolhdlr	; end of line handler
	   dw  offset pgroup:curhdlr	; current cursor handler
	   dw  offset pgroup:clfhdlr	; cursor left handler
	   dw  offset pgroup:crthdlr	; cursor right handler
	   dw  offset pgroup:exthdlr	; exit handler
	   dw  offset pgroup:udohdlr	; undo handler
	   dw  offset pgroup:udshdlr	; undo single char. handler
	   dw  offset pgroup:dlshdlr	; delete single char. handler
	   dw  offset pgroup:apphdlr	; append handler
	   dw  offset pgroup:inshdlr	; insert handler
	   dw  offset pgroup:chghdlr	; change handler
	   dw  offset pgroup:delhdlr	; delete handler



	   
bolhdlr:		; beginning of line handler

	mov [bp.msuffix], bolc ;set up the code for beginning of line
	jmp word ptr [bp.curmode]




eolhdlr:		; end of line handler

	mov [bp.msuffix], eolc ;set up the code for end of line
	jmp word ptr [bp.curmode]




curhdlr:		; current cursor handler

	mov [bp.msuffix], curc ;set up the code for current cursor
	jmp word ptr [bp.curmode]



clfhdlr:		; cursor left handler
	
	cmp [bp.curposn], 0	; check whether it is at the left boundary
	jle clfend
	mov al, bsp_c
	mov bx, [bp.gifdev]
	call dispchr		; display a backspace
	jnc clfcont
	mov [bp.errorf], itserr
	jmp lookcctret
clfcont:
	dec [bp.curposn]
clfend:
	mov [bp.curmode], offset pgroup:nchrhdlr
	stc
	jmp lookcctret



crthdlr:		; cursor right handler

	pop cx			; get character count
	push cx
	cmp [bp.curposn], cl	; check whether it exceeds character count
	jge crtend
	xor bx, bx
	mov bl, [bp.curposn]	; get the char at the current cursor posn and
	add bx, [bp.usrbufirst] ; display it so that the cursor will advance
	mov al, ds:[bx]
	mov bx, [bp.gifdev]
	call dispchr
	jnc crtcont
	mov [bp.errorf], itserr ; if error, set error flag
	jmp lookcctret
crtcont:
	cmp [bp.curposn], (linlen-1)
	jl crtcont1
	mov al, bsp_c
	call dispchr
	jnc crtend
	mov [bp.errorf], itserr  ; if error, set error flag
	jmp lookcctret
crtcont1:
	inc [bp.curposn]
crtend:
	mov [bp.curmode], offset pgroup:nchrhdlr
	stc
	jmp lookcctret



exthdlr:		; exit handler
	pop cx
	push cx		; get the character count
	mov di, [bp.defbufirst] ; move back cx characters from user buffer to
	mov si, [bp.usrbufirst] ; default buffer
	rep movsb
	mov [bp.exitf], toexit  ; set exit flag
	stc
	jmp lookcctret


udohdlr:		; undo handler
	pop cx
	mov cx, [bp.defbuflen]  ; set character count to default length
	push cx
	mov [bp.exitf], toexit ; set exit flag
	mov ax, es		; exchange ds and es
	push ds
	pop es
	mov ds, ax
	mov al, sp_c		; clear the user buffer
	mov di, [bp.usrbufirst]
	mov cx, linlen
	rep stosb
	mov cx, [bp.defbuflen]  ; transfer chars of defbuflen from default
				; buffer to user buffer
	mov si, [bp.defbufirst]
	mov di, [bp.usrbufirst]
	rep movsb
	mov ax, es		; resume original ds and es
	push ds			
	pop es
	mov ds, ax
	xor cx, cx
	mov cl, [bp.curposn]
	jcxz udocont
	mov bx, [bp.gifdev]
udobcur:			; move cursor to bol
	mov al, bsp_c
	call dispchr
	jnc bcurnxt
	stc
	mov [bp.errorf], itserr
	jmp lookcctret
bcurnxt:
	loop udobcur
udocont:
	mov cx, linlen
	mov si, [bp.usrbufirst]
	call dispubuf		; display the content of user buffer
	jnc udohdlrcont
	mov [bp.errorf], itserr
udohdlrcont:
	stc
	jmp lookcctret



udshdlr:		; undo single char handler
	xor bx, bx		; get the cursor position
	mov bl, [bp.curposn]	
	cmp bx, [bp.defbuflen]	; check whether it exceeds the default buffer
	jge udsret		; length
	add bx, [bp.defbufirst] ; if it is not, get the character from default
	mov al, es:[bx]		; buffer
	sub bx, [bp.defbufirst] ; replace that in user buffer by the char in
	add bx, [bp.usrbufirst] ; default buffer
	mov [bx], al
	mov bx, [bp.gifdev]
	call dispchr
	jnc udscont
	mov [bp.errorf], itserr
	jmp lookcctret
udscont:
	mov al, bsp_c		; don't advance the cursor
	call dispchr
	jnc udscont1
	mov [bp.errorf], itserr
	jmp lookcctret
udscont1:
	pop cx
	cmp [bp.curposn], cl
	je udscont2
	push cx
	jmp udsret
udscont2:
	inc cx
	push cx
udsret:
	stc
	mov [bp.curmode], offset pgroup:nchrhdlr ; reset to normal char handler
	jmp lookcctret




dlshdlr:		; delete single char handler
	pop cx		; check whether it exceeds the character count
	cmp cx, 1
	jge dlscont1
	push cx
	jmp dlsret
dlscont1:
	cmp [bp.curposn], cl	; check whether cursor posn exceeds
	jl dlscont2		; character count
	push cx
	jmp dlsret
dlscont2:
	dec cx
	push cx
	xor bx, bx		; get the offset of the cursor in the user
	mov bl, [bp.curposn]	; buffer
	mov si, [bp.usrbufirst]
	add si, bx		; shift all the chars to the right of current
				; cursor 1 chars left
	inc si
	mov bx, 1
	call shbufl
	dec si
	mov cx, linlen		; get the number of characters to display
	xor bx, bx		; get the offset of the cursor in the user
	mov bl, [bp.curposn]	; buffer
	sub cx, bx
	call dispubuf		; display user buffer, starting at posn 
				; pointed by si
	jnc dlscont
	mov [bp.errorf], itserr
	jmp lookcctret
dlscont:
	mov bx, [bp.gifdev]
dlsretreat:			; don't advance the cursor
	mov al, bsp_c
	call dispchr
	jnc dlsretlp
	mov [bp.errorf], itserr
	jmp lookcctret
dlsretlp:
	loop dlsretreat
dlsret:
	mov [bp.curmode], offset pgroup:nchrhdlr
	stc
	jmp lookcctret


apphdlr:			; append handler
	mov [bp.curmode], offset pgroup:appsubdisp
	stc
	jmp lookcctret

appsubdisp:			; append subhandlers dispatcher
	mov [bp.curmode], offset pgroup:nchrhdlr
	cmp [bp.msuffix], nchrc  ; check whether the char received is normal char
	jne appsubcont
	mov [bp.putmode], appendm
	clc
	jmp lookcctret
appsubcont:
	xor bx, bx		; get the offset of subhandler address
	mov bl, [bp.msuffix]
	mov [bp.msuffix], nchrc	; reset mode suffix to normal character
	shl bx, 1
	add bx, offset pgroup: appsubhdlrtab
	jmp cs:[bx]

appsubhdlrtab   dw  appcurc
		dw  appeol
		dw  appcurc

appcurc:			; append from the current cursor
	mov [bp.putmode], appendm
	stc
	jmp lookcctret

appeol:
	mov [bp.putmode], appendm
	pop cx
	push cx
	mov ax, cx
	sub cl, [bp.curposn]
	jz appeolret
	xor bx, bx
	mov bl, [bp.curposn]
	add bx, [bp.usrbufirst]
	mov si, bx		; set start display position
	call dispubuf
	jnc appeolcont		; if error, set error flag
	mov [bp.errorf], itserr
	jmp lookcctret
appeolcont:
	mov [bp.curposn], al	; set cursor position to char count
	cmp [bp.curposn], linlen ; check whether cursor posn exceeds line limit
	jl appeolret
	dec [bp.curposn]
	mov al, bsp_c
	mov bx, [bp.gifdev]
	call dispchr
	jnc appeolret
	mov [bp.errorf], itserr
appeolret:
	stc
	jmp lookcctret


inshdlr:
	mov [bp.curmode], offset pgroup:inssubdisp ;set current mode to insert 
						   ;subdispatcher
	stc
	jmp lookcctret


inssubdisp:			;insert subdispatcher

	mov [bp.curmode], offset pgroup:nchrhdlr
	cmp [bp.msuffix], nchrc		; check whether a normal char is
					; received
	jne inscont
	mov [bp.putmode], insertm	; if a normal char is received
	mov [bp.insflag], iccurs	; just set it insert from current
	clc				; cursor
	jmp lookcctret
inscont:
	xor bx, bx
	mov bl, [bp.msuffix]
	mov [bp.msuffix], nchrc
	shl bx, 1
	add bx, offset pgroup:inssubhdlrtab
	jmp cs:[bx]

inssubhdlrtab  dw offset pgroup:insbol
	       dw offset pgroup:inscur
	       dw offset pgroup:inscur
	
insbol:			; insert from beginning of line
	xor cx, cx
	mov cl, [bp.curposn]
	jcxz insbolret
	mov bx, [bp.gifdev]
lpbcurs:		; don't advance cursor
	mov al, bsp_c
	call dispchr
	jnc insbolcont
	mov [bp.errorf], itserr
	jmp lookcctret
insbolcont:
	loop lpbcurs
insbolret:
	mov [bp.curposn], 0
	mov [bp.putmode], insertm
	mov [bp.insflag], ibegin
	stc
	jmp lookcctret

inscur:			; insert from current cursor
	mov [bp.putmode], insertm
	mov [bp.insflag], iccurs
	stc
	jmp lookcctret



chghdlr:		; change char handler
	mov [bp.curmode], offset pgroup:chgsubdisp
	stc
	jmp lookcctret


chgsubdisp:		; change mode subdispatcher
	mov [bp.curmode], offset pgroup:nchrhdlr
	cmp [bp.msuffix], nchrc
	je chgchar
	cmp [bp.msuffix], bolc
	jne chgcont
	call tobol
	jnc chgcont2
	mov [bp.errorf], itserr
	jmp short chgcont2
chgcont:
	cmp [bp.msuffix], eolc
	jne chgcont2
	pop cx
	call toeol
	push cx
	mov [bp.insflag], iccurs
	jnc chgcont2
	mov [bp.errorf], itserr
chgcont2:
	mov [bp.msuffix], nchrc
	stc
	jmp lookcctret

chgchar:		; change to specific char
;	pop cx
;	push cx
;	mov ah, al
;	call searchchar
;	jnc chgcret
;	cmp [bp.curposn], al
;	je chgccont
;	mov [bp.mtchr], ah
;	mov al, [bp.curposn]
;	sub [bp.edcnt], al
;	mov [bp.putmode], changem
;	jmp short chgcret
	pop cx
	call del2char
	push cx
	jnc chgccont
	mov [bp.errorf], itserr
	jmp chgcret
chgccont:
	mov [bp.putmode], insertm
	mov [bp.insflag], iccurs
chgcret:
	stc
	jmp lookcctret



delhdlr:			; delete handler

	mov [bp.curmode], offset pgroup:delsubdisp
	stc
	jmp lookcctret


delsubdisp:			; delete subdispatcher

	mov [bp.curmode], offset pgroup:nchrhdlr
	cmp [bp.msuffix], nchrc ; check whether it is a normal char
	je delnchr
	xor bx, bx
	mov bl, [bp.msuffix]
	mov [bp.msuffix], nchrc
	shl bx, 1
	add bx, offset pgroup:delsubhdlrtab
	jmp cs:[bx]

delsubhdlrtab  dw offset pgroup: delbol
	       dw offset pgroup: deleol
	       dw offset pgroup: delignore


delignore:			; do nothing
	
	stc
	jmp lookcctret


delbol:				; only move cursor to beginning of line
	call tobol
	jnc delbolret
	mov [bp.errorf], itserr
delbolret:
	stc
	jmp lookcctret


deleol:				; delete to end of line
	
	xor bx, bx		; get the cursor relative position
	mov bl, [bp.curposn]
	pop cx
	mov ax, cx		; get number of chars to delete
	sub cx, bx
	sub ax, cx		; update character count
	push ax
	jcxz deleolret
	add bx, [bp.usrbufirst]
	mov si, bx
	push cx
	mov bx, [bp.gifdev]
lpdelbuf:			; display and fill the buffer area with spaces
	mov al, sp_c
	mov [si], al
	call dispchr
	jnc lpdelcont
	mov [bp.errorf], itserr
	stc
	jmp lookcctret
lpdelcont:
	inc si
	loop lpdelbuf
	pop cx
lpbcur:				; display backspace because the cursor does not
	mov al, bsp_c		; advance
	call dispchr		
	loop lpbcur
deleolret:
	stc
	jmp lookcctret
	

delnchr:
	pop cx
	call del2char
	push cx
	jnc delnchrret
	mov [bp.errorf], itserr
delnchrret:
	stc
	jmp lookcctret
	
	

nchrhdlr:			; normal character handler
	cmp [bp.msuffix], nchrc	; check whether it is normal char
	je nchrcont
	cmp [bp.msuffix], bolc
	jne nchrcont1
	call tobol
	jnc nchrcont2
	mov [bp.errorf], itserr
nchrcont1:
	cmp [bp.msuffix], eolc
	jne nchrcont2
	pop cx
	call toeol
	push cx
	mov [bp.insflag], iccurs
	jnc nchrcont2
	mov [bp.errorf], itserr
nchrcont2:
	mov [bp.msuffix], nchrc
	stc
	jmp lookcctret
nchrcont:
	clc
	jmp lookcctret

; function : to delete from current cursor to a specified char
; input parameter : al -- the specified char
;		    cx -- original character count
; output parameter : cx -- updated character count
; destroyed : ax, bx, si

nprocedure del2char

;	pop cx	
	call searchchar		; search whether the character is in the buffer
	jc delnchrcont		; carry clear means character not found
;	push cx
	jmp delret
delnchrcont:
;	cmp [bp.curposn], al	; if the char is in the current cursor posn,
;	jne delnchrcont1	; also do nothing
;	push cx
;	jmp delret
delnchrcont1:
	inc al
	xor bx, bx		; get the offset of one next to that character
	mov bl, al
	mov si, bx
	add si, [bp.usrbufirst]
	sub al, [bp.curposn]	; calculate the no. of chars to delete
	mov bl, al
	call shbufl		; shift the characters, starting from the
				; specific character to eol, bx column left
	mov ax, cx		; update character count
	sub ax, bx
;	push ax
	sub cl, [bp.curposn]	; display the buffer content, from current
	sub si, bx		; cursor to end of line
	call dispubuf
	jc delret
	mov si, ax
	mov bx, [bp.gifdev]
delbcur:			; do not advance the cursor 
	mov al, bsp_c
	call dispchr
	jc delret
	loop delbcur
	mov cx, si
	clc
delret:
	ret

del2char endp


; function : to move the cursor to beginning of line
; input : nil
; output : nil, CY if error
; destroyed : cx, ax, bx


nprocedure tobol
	xor cx, cx
	mov cl, [bp.curposn]
	jcxz tobolret
	mov bx, [bp.gifdev]
tobolbcurs:		; don't advance cursor
	mov al, bsp_c
	call dispchr
	jnc tobolcont
	mov [bp.errorf], itserr
	jmp lookcctret
tobolcont:
	loop tobolbcurs
tobolret:
	mov [bp.curposn], 0
	ret
tobol endp


; function : to move cursor to end of line
; input : cx -- character count
; output : nil, CY if error
; destroyed : ax, si, bx

nprocedure toeol

	push cx
	mov ax, cx
	sub cl, [bp.curposn]
	jz toeolret
	xor bx, bx
	mov bl, [bp.curposn]
	add bx, [bp.usrbufirst]
	mov si, bx		; set start display position
	call dispubuf
	jnc toeolcont 		; if error, set error flag
	mov [bp.errorf], itserr
	pop cx
	ret
toeolcont:
	mov [bp.curposn], al	; set cursor position to char count
	cmp [bp.curposn], linlen ; check whether cursor posn exceeds line limit
	jnl toeolcont1
	clc
	jmp short toeolret
toeolcont1:
	dec [bp.curposn]
	mov al, bsp_c
	mov bx, [bp.gifdev]
	call dispchr
	jnc toeolret
	mov [bp.errorf], itserr
toeolret:
	pop cx
	ret
toeol endp


; function : to search and match a char in the user buffer
; input : al -- the character to be matched
;	  cx -- character count
; output : CY if character found otherwise NC
;	   al contains its relative position in buffer if found
; destroyed : nil

nprocedure searchchar

	push bx
	push cx
	xor bx, bx
	mov bl, [bp.curposn]
	sub cx, bx
	jcxz charnfound
	add bx, [bp.usrbufirst]
lpschar:
	cmp [bx], al
	je charfound
	inc bx
	loop lpschar
charnfound:
	clc
	pop cx
	pop bx
	ret
charfound:
	sub bx, [bp.usrbufirst]
	mov al, bl
	stc
	pop cx
	pop bx
	ret

searchchar endp
	
		


prog ends

end


