	TITLE MOUSE DRIVE
	PAGE	60,132
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\186.EQU
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\186\MPROC.MAC
;
;
XMAX	EQU	639
YMAX	EQU	259
;
NEWCORD	EQU	1
;
;
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA

DATA	SEGMENT WORD PUBLIC 'DATA'
	ASSUME	DS:DGROUP
;
;	EXTRN	XDAT:ABS
;
	PUBLIC	MOUXCORD,MOUYCORD,MOUSTAT,MOUSKEYS
;
MOUSDX	DW	?
MOUSDY	DW	?
MOUXCORD DW	?
MOUYCORD DW	?
MOUSTAT	DW	?
MOUSKEYS DW	?
MOUSENF	DB	?
DATA	ENDS
;
;
;
PROG	SEGMENT BYTE PUBLIC 'PROG'
	ASSUME CS:PGROUP
;
;
;
;
;
;
;
	PUBLIC	MOUSINIT,MOUSREAD

;
;
;
MOUSINIT PROC			;INIT MOUSE INTERUPT
	MOV	WORD PTR MOUXCORD,0	;CLR MOUSECOORD RGS
	MOV	WORD PTR MOUYCORD,0	;CLR MOUSECOORD RGS
	MOV	WORD PTR MOUSTAT,0	;CLR MOUSESTAT REG
	MOV	MOUSDX,0
	MOV	MOUSDY,0
	MOV	MOUSENF,0
	MOV	MOUSKEYS,0
	INITVC	TINT0,MOUSEX	;INIT VECTORS
	INITVC	TINT1,MOUSEY
	CLI
	MOV	DX,MAXA0
	MOV	AX,1
	OUT	DX,AX
	MOV	DX,MAXA1
	OUT	DX,AX
	MOV	DX,MD0
	MOV	AX,TIMEXT	;TIMERS EXTERNAL TRIGGERED
	OUT	DX,AX
	MOV	DX,MD1
	OUT	DX,AX
	MOV	DX,TIMINT	;ENABLE INTERUPTS
	MOV	AX,0
	OUT	DX,AX
	STI
	RET
MOUSINIT ENDP
;
;
MOUSREAD PROC
	AND	MOUSTAT,NOT NEWCORD
	TEST	MOUSENF,1
;	JZ	MRD5
	XOR	AX,AX		;TEST FOR DX,DY
	CLI
	MOV	CX,MOUSDX
	MOV	MOUSDX,AX
	MOV	DX,MOUSDY
	MOV	MOUSDY,AX
	STI
	OR	AX,CX
	OR	AX,DX
	JZ	MRD5
	ADD	CX,MOUXCORD
	JNS	MRD1
	CMP	CX,XMAX+1
	JC	MRD2
	XOR	CX,CX		;X=0
MRD1:
	CMP	CX,XMAX+1	;IF OVERFLOW
	JC	MRD2
	MOV	CX,XMAX		;X=XMAX
MRD2:
	ADD	DX,MOUYCORD
	JNS	MRD3		;IF UNDERFLOW
	CMP	DX,YMAX+1
	JC	MRD4
	XOR	DX,DX		;Y=0
MRD3:
	CMP	DX,YMAX+1		;OTHERWISE IF OVERFLOW
	JC	MRD4
	MOV	DX,YMAX		;Y=YMAX
MRD4:
	MOV	MOUXCORD,CX
	MOV	MOUYCORD,DX
	OR	MOUSTAT,NEWCORD ;FLAG NEW COORDINATES VALID
RDKEYS	PROC
MRD5:
	MOV	DX,SYSSTAT	;READ KEYS
	MOV	CX,500		;DEOUNCE DELAY CNTR
	MOV	BX,CX
MRD6:
	IN	AX,DX
	SHR	AX,1
	SHR	AX,1
	NOT	AX
	AND	AX,7		;TEST FOR ANY KEY
	JZ	MRD9		;EXIT IF NO KEY
	CMP	AX,MOUSKEYS	;OR SAME COMBINATION
	JZ	MRD8
	MOV	MOUSKEYS,8
	CMP	AX,BX
	MOV	BX,AX		;ELSE DEBOUNCE
	LOOP	MRD6
	JNZ	MRD5		;TRY AGAIN IF NOT EQUAL
MRD7:
	MOV	MOUSKEYS,AX	;ELSE STORE STATUS
MRD8:
;	MOV	MOUSENF,1
	RET
MRD9:
	if	0
	MOV	MOUSDX,0
	MOV	MOUSDY,0
	MOV	MOUSENF,0
	endif
	MOV	MOUSKEYS,0
	RET
RDKEYS	ENDP
MOUSREAD ENDP
;
;
MOUSEX:				;INTAS FOR MOUSEX INTERUPT
	PUSH	AX
	PUSH	DX
	PUSH	DS
	mov	ax,data
 	MOV	DS,AX
	MOV	DX,MD0
	MOV	AX,TIMEXT	;START TIMER AGAIN
	OUT	DX,AX
	MOV	DX,SYSSTAT
	IN	AX,DX		;TEST DIRECTION
	TEST	AX,1 SHL MX1
	JZ	MOUSEXD		;IF NEG THEN DEC X COORDINATE
	INC	 MOUSDX
MOUSEN:
	MOV	DX,EOIRG	;REENABLE COUNTER
	MOV	AX,TINT0
	OUT	DX,AX
	POP	DS
	POP	DX
	POP	AX
	IRET
MOUSEXD:
	DEC	 MOUSDX
	JMP	MOUSEN
;
;
MOUSEY:				;INTAS FOR MOUSEY INTERUPT
	PUSH	AX
	PUSH	DX
	PUSH	DS
	MOV	AX,DATA
 	MOV	DS,AX
	MOV	DX,MD1
	MOV	AX,TIMEXT	;START TIMER AGAIN
	OUT	DX,AX
	MOV	DX,SYSSTAT
	IN	AX,DX		;TEST DIRECTION
	TEST	AX,1 SHL MY1
	JZ	MOUSEYD		;IF NEG THEN DEC Y COORDINATE
	INC	 MOUSDY
	JMP	MOUSEN
MOUSEYD:
	DEC	 MOUSDY
	JMP	MOUSEN

PROG	ENDS
	END
