.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)w.1	6.3 (Berkeley) 4/28/87
.\"
.TH W 1 "April 28, 1987"
.UC 4
.SH NAME
w \- who is on and what they are doing
.SH SYNOPSIS
.B w
[
.B \-hls
] [ user ]
.SH PLEASE NOTE:
There is no man page for the MACH 3.0
.I w,
this is the man page for the Berkeley 6.3 version.
.SH DESCRIPTION
.I W
prints a summary of the current activity on the system,
including what each user is doing.
The heading line shows the current time of day,
how long the system has been up,
the number of users logged into the system,
and the load averages.
The load average numbers give the number of jobs in the run queue
averaged over 1, 5 and 15 minutes.
.PP
The fields output are:
the users login name,
the name of the tty the user is on,
the host from which the user is logged in,
the time the user logged on,
the time since the user last typed anything,
the CPU time used by all processes and their children on that terminal,
the CPU time used by the currently active processes,
the name and arguments of the current process.
.PP
The
.B \-h
flag suppresses the heading.
The
.B \-s
flag asks for a short form of output.
In the short form, the tty is abbreviated, the login time and cpu times
are left off, as are the arguments to commands.
.B \-l
gives the long output, which is the default.
The
.B \-f
option suppresses the ``from'' field.
.PP
If a
.I user
name is included,
the output will be restricted to that user.
.SH FILES
.ta 1i
/etc/utmp
.br
/dev/kmem
.br
/dev/drum
.SH "SEE ALSO"
who(1), finger(1), ps(1)
.SH AUTHOR
Mark Horton
.SH BUGS
The notion of the ``current process'' is muddy.
The current algorithm is ``the highest numbered process on
the terminal that is not ignoring interrupts,
or, if there is none, the highest numbered process on the terminal''.
This fails, for example, in critical sections of programs
like the shell and editor,
or when faulty programs running in the background
fork and fail to ignore interrupts.
(In cases where no process can be found,
.I w
prints ``\-''.)
.PP
The CPU time is only an estimate, in particular, if someone leaves a
background process running after logging out, the person currently
on that terminal is ``charged'' with the time.
.PP
Background processes are not shown, even though they account for
much of the load on the system.
.PP
Sometimes processes, typically those in the background, are
printed with null or garbaged arguments.
In these cases, the name of the command is printed in parentheses.
.PP
W does not know about the new conventions for detection of background jobs.
It will sometimes find a background job instead of the right one.
