.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)vlp.1	6.1 (Berkeley) 4/29/85
.\"
.TH VLP 1 "April 29, 1985"
.UC 5
.SH NAME
vlp \- Format Lisp programs to be printed with nroff, vtroff, or troff
.SH SYNOPSIS
.B vlp
[
.B \-p
.I pointsize
] [
.B \-d
] [
.B \-f
] [
.B \-l
] [
.B \-v
] [
.B \-T
.I title1
] file1 [
.B \-T
.I title2
] file2 ...
.SH DESCRIPTION
\fIVlp\fR
formats the named files so that they can be run through nroff, vtroff, or
troff to produce listings that line-up and are attractive.
The first non-blank character of each line is lined-up vertically,
as in the source file.
Comments (text beginning with a semicolon)
are printed in italics.
Each function's name is printed in bold face next to the function.
This format makes Lisp code look attractive when it is printed with a 
variable width font.
.PP
Normally,
\fIvlp\fR works as a filter and sends its output to the standard output.
However,
the 
.B \-v
switch pipes the output directly to vtroff.
If no files are specified,
then \fIvlp\fR reads from the standard input.
.PP
The following options are available:
.TP
.B \-p
The
.B \-p
switch changes the size of the text from its default value of 8 points
to one of 6, 8, 10, or 12 points.
Once set, the point size is used for all subsequent files.
This point size does not apply to embedded text (see \fI\-f\fR below).
.TP
.B \-d
The 
.B \-d
switch puts \fIvlp\fR into debugging mode.
.TP
.B \-f
.I Vlp
has a filtered mode
in which all lines are passed unmodified,
except those lines between the directives \fB.Ls\fR and \fB.Le\fR.
This mode can be used to format Lisp code that is embedded in a document.
The directive \fB.Ls\fR takes an optional argument that gives the point
size for the embedded code.
If not size is specified,
the size of the surrounding text is used.
.TP
.B \-l
The
.B \-l
switch prevents \fIvlp\fR from placing labels next to functions.
This switch is useful for embedded Lisp code,
where the labels would be distracting.
.TP
.B \-v
This switch cause \fIvlp\fR to send its output to vtroff rather than the
standard output.
.TP
.B \-T
A title to be printed on each page may be specified by using the 
.B \-T
switch.
The 
.B \-T
switch applies only to the next file name given.
Titles are not printed for embedded text (see 
.BR \-f ,
above).
This switch may not be used if \fIvlp\fR is reading from the standard input.
.SH FILES
/usr/lib/vlpmacs		troff/nroff macros
.SH AUTHOR
Originally written by John K. Foderaro, with additional changes by
Kevin Layer and James Larus.
.SH SEE ALSO
vgrind(1), lisp(1)
.SH BUGS
\fIvlp\fR transforms \\ into \\\\ so that it will be printed out.
Hence, troff commands cannot be embedded in Lisp code.
