.\" Copyright (c) 1986 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)tn3270.1	1.3 (Berkeley) 1/11/86
.\"
.TH TN3270 1 "January 11, 1986"
.UC 6
.SH NAME
tn3270 \- full-screen remote login to IBM VM/CMS
.SH SYNOPSIS
.B tn3270
sysname
.SH DESCRIPTION
.I Tn3270
permits a full-screen, full-duplex connection
from a VAX UNIX machine
to an IBM machine running VM/CMS
giving the appearance of being logged in
directly to the remote machine
on an IBM 3270 terminal.
Of course you must have an account on the machine
to which you wish to connect in order to log in.
.I Tn3270
looks to the user in many respects
like the Yale ASCII Terminal Communication System II.
.I Tn3270
is actually a modification of the Arpanet TELNET user interface (see
.IR telnet (1))
that interprets and generates raw 3270 control streams.
.PP
Emulation of the 3270 terminal is done in the Unix process.
This emulation involves mapping
3270-style commands from the host
into appropriate sequences to control the user's terminal screen.
.I Tn3270
uses
.IR curses (3x)
and the
.I /etc/termcap
file to do this.
The emulation also involves simulating the special 3270 keyboard keys
(program function keys, etc.)
by mapping sequences of keystrokes
from the ASCII keyboard into appropriate 3270 control strings.
This mapping is terminal dependent and is specified
in a description file,
.IR /etc/map3270 ,
(see
.IR map3270 (5))
or in an environment variable
.I MAP3270
(see
.IR mset (1)).
Any special function keys on the ASCII keyboard are used whenever possible.
If an entry for the user's terminal
is not found,
.I tn3270
looks for an entry for the terminal type
.B unknown.
If this is not found,
.I tn3270
uses a default keyboard mapping
(see
.IR map3270 (5)).
.PP
The first character of each special keyboard mapping sequence 
is either an ASCII escape (ESC),
a control character, or an ASCII delete (DEL).
If the user types an unrecognized function key sequence,
.I tn3270
sends an ASCII bell (BEL), or a visual bell if
defined in the user's termcap entry, to the user's terminal
and nothing is sent to the IBM host.
.PP
If
.I tn3270 
is invoked without specifying a remote host system name,
it enters local command mode,
indicated by the prompt ``tn3270>''.
In this mode,
.I tn3270
accepts and executes
the following
commands:
.sp 
.nf
.ta 0.5i 1.5i
	open	connect to a remote host
	close	close the current connection
	quit	exit tn3270
	z	suspend tn3270
	status	print connection status
	?	print help information
.fi
.sp
Other common
.I telnet
commands are not available in
.I tn3270.
.I Tn3270
command mode may also be entered, after connecting to a host, by typing
a special escape character
(typically control-C).
.PP
While in command mode, any host login session is still alive
but temporarily suspended.
The host login session may be resumed by entering an empty line
(press the RETURN key)
in response to the command prompt.
A session may be terminated by logging off the foreign host,
or by typing ``quit'' or ``close'' while in local command mode.
.SH FILES
/etc/termcap
.br
/etc/map3270
.SH AUTHOR
Greg Minshall
.SH SEE ALSO
mset(1), telnet(1), termcap(3x), termcap(5), map3270(5),
\fIYale ASCII Terminal Communication
System II Program Description/Operator's Manual\fR
(IBM SB30-1911)
.SH BUGS
Performance is slow and uses system resources prodigiously.
.PP
Not all 3270 functions are supported,
nor all Yale enhancements.
