.\" Copyright (c) 1986 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)tftp.1c	1.2 (Berkeley) 4/20/86
.\"
.TH TFTP 1C "April 20, 1986"
.UC 6
.SH NAME
tftp \- trivial file transfer program
.SH SYNOPSIS
.B tftp
[
host
]
.SH DESCRIPTION
.I Tftp
is the user interface to the Internet TFTP
(Trivial File Transfer Protocol),
which allows users to transfer files to and from a remote machine.
The remote
.I host
may be specified on the command line, in which case
.I tftp
uses
.I host
as the default host for future transfers (see the
.B connect
command below).
.SH COMMANDS
Once
.I tftp
is running, it issues the prompt
.B tftp>
and recognizes the following commands:
.TP
\fBconnect\fP \fIhost-name\fP [ \fIport\fP ]
Set the
.I host
(and optionally
.IR port )
for transfers.
Note that the TFTP protocol, unlike the FTP protocol,
does not maintain connections betweeen transfers; thus, the
.I connect
command does not actually create a connection,
but merely remembers what host is to be used for transfers.
You do not have to use the 
.I connect
command; the remote host can be specified as part of the
.I get
or
.I put
commands.
.TP
\fBmode\fP \fItransfer-mode\fP
Set the mode for transfers; 
.I transfer-mode
may be one of
.IR ascii
or
.IR binary .
The default is
.IR ascii .
.TP
\fBput\fP \fIfile\fP
.ns
.TP
\fBput\fP \fIlocalfile remotefile\fP
.ns
.TP
\fBput\fP \fIfile1 file2 ... fileN remote-directory\fP
Put a file or set of files to the specified
remote file or directory.
The destination
can be in one of two forms:
a filename on the remote host, if the host has already been specified,
or a string of the form
.I host:filename
to specify both a host and filename at the same time.
If the latter form is used,
the hostname specified becomes the default for future transfers.
If the remote-directory form is used, the remote host is
assumed to be a
.I UNIX
machine.
.TP
\fBget\fP \fIfilename\fP
.ns
.TP
\fBget\fP \fIremotename\fP \fIlocalname\fP
.ns
.TP
\fBget\fP \fIfile1\fP \fIfile2\fP ... \fIfileN\fP
Get a file or set of files from the specified
.IR sources .
.I Source
can be in one of two forms:
a filename on the remote host, if the host has already been specified,
or a string of the form
.I host:filename
to specify both a host and filename at the same time.
If the latter form is used,
the last hostname specified becomes the default for future transfers.
.TP
.B quit
Exit
.IR tftp .
An end of file also exits.
.TP
.B verbose
Toggle verbose mode.
.TP
.B trace
Toggle packet tracing.
.TP
.B status
Show current status.
.TP
\fBrexmt\fP \fIretransmission-timeout\fP
Set the per-packet retransmission timeout, in seconds.
.TP
\fBtimeout\fP \fItotal-transmission-timeout\fP
Set the total transmission timeout, in seconds.
.TP
.B ascii
Shorthand for "mode ascii"
.TP
.B binary
Shorthand for "mode binary"
.TP
\fB?\fP \ [ \fIcommand-name\fP ... ]
Print help information.
.SH BUGS
.PP
Because there is no user-login or validation within
the
.I TFTP
protocol, the remote site will probably have some
sort of file-access restrictions in place.  The
exact methods are specific to each site and therefore
difficult to document here.
