.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)talk.1	6.4 (Berkeley) 11/24/87
.\"
.TH TALK 1 "November 24, 1987"
.UC 5
.SH NAME
talk \- talk to another user
.SH SYNOPSIS
.B talk
person [ ttyname ]
.SH DESCRIPTION
\fITalk\fP is a visual communication program which copies lines from your
terminal to that of another user.
.PP 
If you wish to talk to someone on your own machine, then \fIperson\fP
is just the person's login name.  If you wish to talk to a user on
another host, then \fIperson\fP is of the form \fIuser@host\fP.
.PP
If you want to talk to a user who is logged in more than once, the
\fIttyname\fP argument may be used to indicate the appropriate terminal
name, where \fIttyname\fP is of the form ``ttyXX''.
.PP
When first called, \fItalk\fP sends the message
.PP
     Message from TalkDaemon@his_machine...
     talk: connection requested by your_name@your_machine.
     talk: respond with: talk your_name@your_machine
.PP
to the user you wish to talk to. At this point, the recipient
of the message should reply by typing
.PP
     talk \ your_name@your_machine
.PP
It doesn't matter from which machine the recipient replies, as
long as his login-name is the same.  Once communication is established,
the two parties may type simultaneously, with their output appearing
in separate windows.  Typing control L (^L) will cause the screen to
be reprinted, while your erase, kill, and word kill characters will
behave normally.  To exit, just type your interrupt character; \fItalk\fP
then moves the cursor to the bottom of the screen and restores the
terminal to its previous state.
.PP
Permission to talk may be denied or granted by use of the \fImesg\fP
command.  At the outset talking is allowed.  Certain commands, in
particular \fInroff\fP and \fIpr\fP, disallow messages in order to
prevent messy output.
.PP
.SH FILES
/etc/hosts	to find the recipient's machine
.br
/etc/utmp		to find the recipient's tty
.SH "SEE ALSO"
mail(1), mesg(1), who(1), write(1)
.SH BUGS
The version of \fItalk\fP(1) released with 4.3BSD uses a protocol that
is incompatible with the protocol used in the version released with 4.2BSD.
