.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)soelim.1	6.2 (Berkeley) 5/7/86
.\"
.TH SOELIM 1 "May 7, 1986"
.UC
.SH NAME
soelim \- eliminate \&.so's from nroff input
.SH SYNOPSIS
.B soelim
[
file ...
]
.SH DESCRIPTION
.I Soelim
reads the specified files or the standard input and performs the textual
inclusion implied by the
.I nroff
directives of the form
.PP
.DT
	\&.so somefile
.PP
when they appear at the beginning of input lines.
This is useful since programs such as
.I tbl
do not normally do this; it allows the placement of individual tables
in separate files to be run as a part of a large document.
.PP
An argument consisting of a single minus
.RB ( \- )
is taken to be
a file name corresponding to the standard input.
.PP
Note that inclusion can be suppressed by using `\'' instead of `\.', i.e.
.PP
.DT
	\'so /usr/lib/tmac.s
.PP
A sample usage of
.I soelim
would be
.PP
	soelim exum?.n | tbl | nroff \-ms | col | lpr
.SH SEE\ ALSO
colcrt(1), more(1)
.SH BUGS
The format of the source commands must involve no strangeness \-
exactly one blank must precede and no blanks follow the file name.
