.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rsh.1c	6.1 (Berkeley) 4/29/85
.\"
.TH RSH 1C "April 29, 1985"
.UC 5
.SH NAME
rsh \- remote shell
.SH SYNOPSIS
.B rsh
host
[
.B \-l
username
] [
.B \-n
] command
.br
host
[
.B \-l
username
] [
.B \-n
] command
.SH DESCRIPTION
.I Rsh
connects to the specified
.I host,
and executes the specified \fIcommand\fR.
.I Rsh
copies its standard input to the remote command, the standard
output of the remote command to its standard output, and the
standard error of the remote command to its standard error.
Interrupt, quit and terminate signals are propagated to the remote
command; \fIrsh\fP normally terminates when the remote command does.
.PP
The remote username used is the same as your local username,
unless you specify a different remote name with the
.B \-l
option.
This remote name must be equivalent (in the sense of
.IR rlogin (1C))
to the originating account; no provision
is made for specifying a password with a command.
.PP
If you omit
.I command,
then instead of executing a single command, you will be logged in
on the remote host using
.IR rlogin (1C).
.PP
Shell metacharacters which are not quoted are interpreted
on local machine, while quoted metacharacters are interpreted on
the remote machine.
Thus the command
.PP
\ \ \ rsh otherhost cat remotefile >> localfile
.PP
appends the remote file
.I remotefile
to the localfile
.I localfile,
while
.PP
\ \ \ rsh otherhost cat remotefile ">>" otherremotefile
.PP
appends
.I remotefile
to
.I otherremotefile.
.PP
Host names are given in the file /etc/hosts.  Each host
has one standard name (the first name given in the file), which
is rather long and unambiguous, and optionally one or more nicknames.
The host names for local machines are also commands in the directory
/usr/hosts; if you put this directory in your search path
then the
.B rsh
can be omitted.
.SH FILES
.ta 2i
/etc/hosts
.br
/usr/hosts/*
.DT
.SH SEE ALSO
rlogin(1C)
.SH BUGS
If you are using
.IR csh (1)
and put a
.IR rsh (1C)
in the background without redirecting its input
away from the terminal, it will block even if no reads
are posted by the remote command.  If no input is desired
you should redirect the input of
.I rsh
to /dev/null using the
.B \-n
option.
.PP
You cannot run an interactive command
(like
.IR rogue (6)
or
.IR vi (1));
use
.IR rlogin (1C).
.PP
Stop signals stop the local \fIrsh\fP process only; this is arguably
wrong, but currently hard to fix for reasons too complicated to
explain here.
