.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rlogin.1c	6.8 (Berkeley) 5/12/86
.\"
.TH RLOGIN 1C "May 12, 1986"
.UC 5
.SH NAME
rlogin \- remote login
.SH SYNOPSIS
.B rlogin
rhost [
\fB\-e\fR\fI\|c\fR
] [
.B \-8
] [
.B \-L
] [
.B \-l
username ]
.br
rhost [
\fB\-e\fR\fIc\fR
] [
.B \-8
] [
.B \-L
] [
.B \-l
username ]
.SH DESCRIPTION
.I Rlogin
connects your terminal on the current local host system
.I lhost
to the remote host system
.I rhost.
.PP
Each host has a file
.I /etc/hosts.equiv
which contains a list of \fIrhost\fR's with which it shares account names.
(The host names must be the standard names as described in
.IR rsh (1C).)
When you
.I rlogin
as the same user on an equivalent host, you don't need
to give a password.
Each user may also have a private equivalence list in a file \&.rhosts
in his login directory.  Each line in this file should contain an \fIrhost\fP
and a \fIusername\fP separated by a space, giving additional cases
where logins without passwords are to be permitted.
If the originating user is not equivalent to the remote user, then
a login and password will be prompted for on the remote machine as in
.IR login (1).
To avoid some security problems, the \&.rhosts file must be owned by
either the remote user or root.
.PP
The remote terminal type is the same as your local
terminal type (as given in your environment TERM variable).
The terminal or window size is also copied to the remote system
if the server supports the option,
and changes in size are reflected as well.
All echoing takes place at the remote site, so that (except for
delays) the rlogin is transparent.  Flow control via ^S and ^Q and
flushing of input and output on interrupts are handled properly.
The optional argument
.B \-8
allows an eight-bit input data path at all times;
otherwise parity bits are stripped except when the remote side's
stop and start characters are other than ^S/^Q.
The argument
.B \-L
allows the rlogin session to be run in litout mode.
A line of the form ``~.'' disconnects from the remote host, where
``~'' is the escape character.
Similarly, the line ``~^Z'' (where ^Z, control-Z, is the suspend character)
will suspend the rlogin session.
Substitution of the delayed-suspend character (normally ^Y)
for the suspend character suspends the send portion of the rlogin,
but allows output from the remote system.
A different escape character may
be specified by the
.B \-e
option.
There is no space separating this option flag and the argument
character.
.SH SEE ALSO
rsh(1C)
.SH FILES
/usr/hosts/*		for \fIrhost\fP version of the command
.SH BUGS
More of the environment should be propagated.
