.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)msgs.1	6.3 (Berkeley) 5/9/86
.\"
.TH MSGS 1 "May 9, 1986"
.UC 4
.SH NAME
msgs \- system messages and junk mail program
.SH SYNOPSIS
.B msgs
[
.B \-fhlpq
] [
number
] [
\-number
]
.LP
.B msgs
.B \-s
.LP
.B msgs
.B \-c
[
\-days
]
.SH DESCRIPTION
.I Msgs
is used to read system messages.
These messages are
sent by mailing to the login `msgs' and should be short
pieces of information which are suitable to be read once by most users
of the system.
.PP
.I Msgs
is normally invoked each time you login, by placing it in the file
.I \&.login
.I (\&.profile
if you use
.IR /bin/sh ).
It will then prompt you with the source and subject of each new message.
If there is no subject line, the first few non-blank lines of the
message will be displayed.
If there is more to the message, you will be told how
long it is and asked whether you wish to see the rest of the message.
The possible responses are:
.TP 7
.B y
type the rest of the message.
.TP 7
RETURN
synonym for y.
.TP 7
.B n
skip this message
and go on to the next message.
.TP 7
.B \-
redisplay the last message.
.TP 7
.B q
drops you out of
.I msgs;
the next time you run the program it will pick up where you left off.
.TP 7
.B s
append the current message to the file ``Messages'' in the current directory;
`s\-' will save the previously displayed message. A `s' or `s\-' may
be followed by a space and a file name to receive the message replacing
the default ``Messages''.
.TP 7
.B m
or `m\-' causes a copy of the specified message to be placed in a temporary
mailbox and 
.IR mail (1)
to be invoked on that mailbox.
Both `m' and `s' accept a numeric argument in place of the `\-'.
.PP
.I Msgs
keeps track of the next message you will see by a number in the file
.I \&.msgsrc
in your home directory.
In the directory
.I /usr/msgs
it keeps a set of files whose names are the (sequential) numbers
of the messages they represent.
The file
.I /usr/msgs/bounds
shows the low and high number of the messages in the directory
so that
.I msgs
can quickly determine if there are no messages for you.
If the contents of
.I bounds
is incorrect it can be fixed by removing it;
.I msgs
will make a new
.I bounds
file the next time it is run.
.PP
The
.B \-s
option is used for setting up the posting of messages.  The line
.IP
.DT
msgs: "| /usr/ucb/msgs \-s"
.PP
should be include in
.I /usr/lib/aliases
to enable posting of messages.
.PP
The
.B \-c
option is used for performing cleanup on
.I /usr/msgs.
An entry with the
.B \-c
option should be placed in
.I /usr/lib/crontab
to run every night.  This will remove all messages over 21 days old.
A different expiration may be specified on the command line to override
the default.
.PP
Options when reading messages include:
.TP 7
.B \-f
which causes it not to say ``No new messages.''.
This is useful in your
.I \&.login
file since this is often the case here.
.TP 7
.B \-q
Queries whether there are messages, printing
``There are new messages.'' if there are.
The command ``msgs \-q'' is often used in login scripts.
.TP 7
.B \-h
causes
.I msgs
to print the first part of messages only.
.TP 7
.B \-l
option causes only locally originated messages to be reported.
.TP 7
\fInum\fR
A message number can be given
on the command line, causing
.I msgs
to start at the specified message rather than at the next message
indicated by your
.I \&.msgsrc
file.
Thus
.IP "" 7
    msgs \-h 1
.IP "" 7
prints the first part of all messages.
.TP 7
.I "\-number"
will cause
.I msgs
to start
.I number
messages back from the one indicated by your 
.I \&.msgsrc
file, useful for reviews of recent messages.
.TP 7
.B \-p
causes long messages to be piped through
.IR more (1).
.PP
Within
.I msgs
you can also go to any specific message by typing its number when
.I msgs
requests input as to what to do.
.SH FILES
.ta 2i
/usr/msgs/*	database
.br
~/.msgsrc	number of next message to be presented
.SH AUTHORS
William Joy
.br
David Wasley
.SH SEE ALSO
aliases(5), crontab(5), mail(1), more(1)
.SH BUGS
