.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mkstr.1	6.2 (Berkeley) 5/7/86
.\"
.TH MKSTR 1 "May 7, 1986"
.UC
.SH NAME
mkstr \- create an error message file by massaging C source
.SH SYNOPSIS
.B mkstr
[
.B \-
]
messagefile prefix file ...
.SH DESCRIPTION
.I Mkstr
is used to create files of error messages.
Its use can make programs with large numbers of error diagnostics much
smaller, and reduce system overhead in running the program as the
error messages do not have to be constantly swapped in and out.
.PP
.I Mkstr
will process each of the specified
.I files,
placing a massaged version of the input file in a file whose name
consists of the specified
.I prefix 
and the original name.
A typical usage of
.I mkstr
would be
.DT
.PP
	mkstr pistrings xx *.c
.PP
This command would cause all the error messages from the C source
files in the current directory to be placed in the file
.I pistrings
and processed copies of the source for these files to be placed in
files whose names are prefixed with
.I xx.
.PP
To process the error messages in the source to the message file
.I mkstr
keys on the string
\%`error("'
in the input stream.
Each time it occurs, the C string starting at the `"' is placed
in the message file followed by a null character and a new-line character;
the null character terminates the message so it can be easily used
when retrieved, the new-line character makes it possible to sensibly
.I cat
the error message file to see its contents.
The massaged copy of the input file then contains a
.I lseek
pointer into the file which can be used to retrieve the message, i.e.:
.IP
.DT
.nf
\fBchar\fR	efilname[] =  "/usr/lib/pi_strings";
\fBint\fR	efil = -1;
.sp
error(a1, a2, a3, a4)
{
	\fBchar\fR buf[256];

	\fBif\fR (efil < 0) {
		efil = open(efilname, 0);
		\fBif\fR (efil < 0) {
oops:
			perror(efilname);
			exit(1);
		}
	}
	\fBif\fR (lseek(efil, (long) a1, 0) |\|| read(efil, buf, 256) <= 0)
		\fBgoto\fR oops;
	printf(buf, a2, a3, a4);
}
.fi
.PP
The optional
.B \-
causes the error messages to be placed at the end of the specified
message file for recompiling part of a large
.IR mkstr \|ed
program.
.SH SEE\ ALSO
lseek(2), xstr(1)
