.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)grep.1	6.3 (Berkeley) 10/8/87
.\"
.TH GREP 1 "October 8, 1987"
.UC 4
.SH NAME
grep, egrep, fgrep \- search a file for a pattern
.SH SYNOPSIS
.B grep
[ option ] ...
expression [ file ] ...
.LP
.B egrep 
[ option ] ...
[ expression ]
[ file ] ...
.LP
.B fgrep
[ option ] ...
[ strings ]
[ file ]
.SH DESCRIPTION
Commands of the
.I grep
family search the input
.I files
(standard input default) for lines matching a pattern.
Normally, each line found is copied to the standard output.
.I Grep
patterns are limited regular expressions in the style of
.IR ex (1);
it uses a compact nondeterministic algorithm.
.I Egrep
patterns are full regular expressions; it uses a fast deterministic
algorithm that sometimes needs exponential space.
.I Fgrep
patterns are fixed strings; it is fast and compact.
The following options are recognized.
.TP
.B \-v
All lines but those matching are printed.
.TP
.B \-x
(Exact) only lines matched in their entirety are printed
.RI ( fgrep
only).
.TP
.B \-c
Only a count of matching lines is printed.
.TP
.B \-l
The names of files with matching lines are listed (once) separated by newlines.
.TP
.B \-n
Each line is preceded by its relative line number in the file.
.TP
.B \-b
Each line is preceded by the block number on which it was found.
This is sometimes useful in locating disk block numbers by context.
.TP
.B \-h
Never print filename headers with output lines.
.TP
.B \-o
Always print filename headers with output lines.
.TP
.B \-i
The case of letters is ignored in making comparisons \(em that is, upper and
lower case are considered identical.
.TP
.B \-s
Silent mode.  Nothing is printed (except error messages).
This is useful for checking the error status.
.TP
.B \-w
The expression is searched for as a word
(as if surrounded by `\e<' and `\e>', see
.IR ex (1).)
(\fIgrep\fR\| only)
.TP
.BI \-e " expression"
Same as a simple
.I expression 
argument, but useful when the
.I expression
begins with a \-.
.TP
.BI \-f " file"
The regular expression (\fIegrep\fP) or string list
.RI ( fgrep ) 
is taken from the
.I file.
.LP
In all cases the file name is shown if there is more than one input file.
Care should be taken when using the characters $ * [ ^ | ( ) and \\ in the
.I expression
as they are also meaningful to the Shell.  It is safest to enclose the entire
.I expression
argument in single quotes \' \'.
.LP
.I Fgrep
searches for lines that contain one of the (newline-separated)
.I strings.
.LP
.I Egrep
accepts extended regular expressions.
In the following description `character' excludes newline:
.IP
A \e followed by a single character other than newline matches that character.
.IP
The character ^ matches the beginning of a line.
.IP
The character $ matches the end of a line.
.IP
A 
.B .
(period) matches any character.
.IP
A single character not otherwise endowed with special
meaning matches that character.
.IP
A string enclosed in brackets [\|] matches any single character from the string.
Ranges of ASCII character codes may be abbreviated as in `a\-z0\-9'.
A ]
may occur only as the first character of the string.
A literal \- must be placed where it can't be mistaken as a range indicator.
.IP
A regular expression followed by an * (asterisk) matches a sequence of 0
or more matches of the regular expression.
A regular expression followed by a + (plus) matches a sequence of 1 or more
matches of the regular expression.
A regular expression followed by a ? (question mark) matches a sequence of
0 or 1 matches of the regular expression.
.IP
Two regular expressions concatenated match a match of the first followed
by a match of the second.
.IP
Two regular expressions separated by | or newline
match either a match for the first or a match for the second.
.IP
A regular expression enclosed in parentheses
matches a match for the regular expression.
.LP
The order of precedence of operators at the same parenthesis level
is [\|] then *+? then concatenation then | and newline.
.LP
Ideally there should be only one
.I grep,
but we don't know a single algorithm that spans a wide enough
range of space-time tradeoffs.
.SH "SEE ALSO"
ex(1),
sed(1),
sh(1)
.SH DIAGNOSTICS
Exit status is 0 if any matches are found,
1 if none, 2 for syntax errors or inaccessible files.
.SH BUGS
Lines are limited to 256 characters; longer lines are truncated.
