.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ftp.1	6.9 (Berkeley) 6/27/88
.\"
.TH FTP 1C "April 29, 1985"
.UC 5
.SH NAME
ftp \- ARPANET file transfer program
.SH SYNOPSIS
.B ftp
[ 
.B \-v
] [
.B \-d
] [
.B \-i
] [
.B \-n
] [
.B \-g
] [
.B host
]
.SH DESCRIPTION
.I Ftp
is the user interface to the ARPANET standard File Transfer Protocol.
The program allows a user to transfer files to and from a
remote network site.
.PP
The client host with which 
.I ftp
is to communicate may be specified on the command line.
If this is done,
.I ftp
will immediately attempt to establish a connection to an FTP
server on that host; otherwise, 
.I ftp
will enter its command interpreter and await instructions
from the user.  When 
.I ftp
is awaiting commands from the user the prompt \*(lqftp>\*(rq
is provided to the user.  The following commands are recognized
by
.IR ftp :
.TP
\fB\&!\fP [ \fIcommand\fP [ \fIargs\fP ] ]
Invoke an interactive shell on the local machine.
If there are arguments, the first is taken to be a command to execute
directly, with the rest of the arguments as its arguments.
.TP
\fB\&$\fP \fImacro-name\fP [ \fIargs\fP ]
Execute the macro \fImacro-name\fP that was defined with the
\fBmacdef\fP command.
Arguments are passed to the macro unglobbed.
.TP
\fBaccount\fP [ \fIpasswd\fP ]
Supply a supplemental password required by a remote system for access
to resources once a login has been successfully completed.
If no argument is included, the user will be prompted for an account
password in a non-echoing input mode.
.TP
\fBappend\fP \fIlocal-file\fP [ \fIremote-file\fP ]
Append a local file to a file on the remote machine.  If
.I remote-file
is left unspecified, the local file name is used in naming the
remote file after being altered by any
.I ntrans
or
.I nmap
setting.
File transfer uses the current settings for
.IR type ,
.IR format ,
.IR mode ,
and
.IR structure .
.TP
.B ascii
Set the file transfer 
.I type
to network ASCII.  This is the default type.
.TP
.B bell
Arrange that a bell be sounded after each file transfer
command is completed.
.TP
.B binary
Set the file transfer
.I type
to support binary image transfer.
.TP
.B bye
Terminate the FTP session with the remote server
and exit
.IR ftp .
An end of file will also terminate the session and exit.
.TP
.B case
Toggle remote computer file name case mapping during
.B mget
commands.
When
.B case
is on (default is off), remote computer file names with all letters in
upper case are written in the local directory with the letters mapped
to lower case.
.TP
.BI cd " remote-directory"
Change the working directory on the remote machine
to 
.IR remote-directory .
.TP
.B cdup
Change the remote machine working directory to the parent of the
current remote machine working directory.
.TP
.B close
Terminate the FTP session with the remote server, and
return to the command interpreter.
Any defined macros are erased.
.TP
.B cr
Toggle carriage return stripping during
ascii type file retrieval.
Records are denoted by a carriage return/linefeed sequence
during ascii type file transfer.
When
.B cr
is on (the default), carriage returns are stripped from this
sequence to conform with the UNIX single linefeed record
delimiter.
Records on non-UNIX remote systems may contain single linefeeds;
when an ascii type transfer is made, these linefeeds may be
distinguished from a record delimiter only when
.B cr
is off.
.TP
.BI delete " remote-file"
Delete the file
.I remote-file
on the remote machine.
.TP
\fBdebug\fP [ \fIdebug-value\fP ]
Toggle debugging mode.  If an optional
.I debug-value
is specified it is used to set the debugging level.
When debugging is on,
.I ftp
prints each command sent to the remote machine, preceded
by the string \*(lq-->\*(rq.
.TP
\fBdir\fP [ \fIremote-directory\fP ] [ \fIlocal-file\fP ]
Print a listing of the directory contents in the
directory,
.IR remote-directory ,
and, optionally, placing the output in
.IR local-file .
If interactive prompting is on,
.I ftp
will prompt the user to verify that the last argument is indeed the
target local file for receiving
.B dir
output.
If no directory is specified, the current working
directory on the remote machine is used.  If no local
file is specified, or \fIlocal-file\fP is \fB-\fP,
output comes to the terminal.
.TP
.B disconnect
A synonym for
.BR close .
.TP
.BI form " format"
Set the file transfer 
.I form
to 
.IR format .
The default format is \*(lqfile\*(rq.
.TP
\fBget\fP \fIremote-file\fP [ \fIlocal-file\fP ]
Retrieve the 
.I remote-file
and store it on the local machine.  If the local
file name is not specified, it is given the same
name it has on the remote machine, subject to
alteration by the current
.IR case ,
.IR ntrans ,
and
.I nmap
settings.
The current settings for 
.IR type ,
.IR form ,
.IR mode ,
and
.I structure
are used while transferring the file.
.TP
\fBglob\fP
Toggle filename expansion for \fBmdelete\fP, \fBmget\fP and \fBmput\fP.
If globbing is turned off with \fBglob\fP, the file name arguments
are taken literally and not expanded.
Globbing for \fBmput\fP is done as in \fBcsh\fP(1).
For \fBmdelete\fP and \fBmget\fP, each remote file name is expanded
separately on the remote machine and the lists are not merged.
Expansion of a directory name is likely to be 
different from expansion of the name of an ordinary file:
the exact result depends on the foreign operating system and ftp server,
and can be previewed by doing `\fBmls\fP\ \fIremote-files\fP\ \fB-\fP'.
Note:  \fBmget\fP and \fBmput\fP are not meant to transfer
entire directory subtrees of files.  That can be done by
transferring a \fBtar\fP(1) archive of the subtree (in binary mode).
.TP
\fBhash\f
Toggle hash-sign (``#'') printing for each data block
transferred.  The size of a data block is 1024 bytes.
.TP
\fBhelp\fP [ \fIcommand\fP ]
Print an informative message about the meaning of
.IR command .
If no argument is given, 
.I ftp
prints a list of the known commands.
.TP
\fBlcd\fP [ \fIdirectory\fP ]
Change the working directory on the local machine.  If
no 
.I directory
is specified, the user's home directory is used.
.TP
\fBls\fP [ \fIremote-directory\fP ] [ \fIlocal-file\fP ]
Print an abbreviated listing of the contents of a
directory on the remote machine.  If
.I remote-directory
is left unspecified, the current working directory is used.
If interactive prompting is on,
.I ftp
will prompt the user to verify that the last argument is indeed the
target local file for receiving
.B ls
output.
If no local file is specified, or if \fIlocal-file\fR is \fB-\fR,
the output is sent to the terminal.
.TP
\fBmacdef\fP \fImacro-name\fP
Define a macro.
Subsequent lines are stored as the macro
\fImacro-name\fP; a null line (consecutive newline characters
in a file or
carriage returns from the terminal) terminates macro input mode.
There is a limit of 16 macros and 4096 total characters in all
defined macros.
Macros remain defined until a
.B close
command is executed.
The macro processor interprets '$' and '\\' as special characters.
A '$' followed by a number (or numbers) is replaced by the
corresponding argument on the macro invocation command line.
A '$' followed by an 'i' signals that macro processor that the
executing macro is to be looped. On the first pass '$i' is
replaced by the first argument on the macro invocation command line,
on the second pass it is replaced by the second argument, and so on.
A '\\' followed by any character is replaced by that character.
Use the '\\' to prevent special treatment of the '$'.
.TP
\fBmdelete\fP [ \fIremote-files\fP ]
Delete the \fIremote-files\fP on the remote machine.
.TP
\fBmdir\fP \fIremote-files\fP \fIlocal-file\fP
Like \fBdir\fP, except multiple remote files may be specified.
If interactive prompting is on,
.I ftp
will prompt the user to verify that the last argument is indeed the
target local file for receiving
.B mdir
output.
.TP
\fBmget\fP \fIremote-files\fP
Expand the \fIremote-files\fP on the remote machine
and do a \fBget\fP for each file name thus produced.
See \fBglob\fR for details on the filename expansion.
Resulting file names will then be processed according to
.IR case ,
.IR ntrans ,
and
.I nmap
settings.
Files are transferred into the local working directory,
which can be changed with `\fBlcd\fP\ directory';
new local directories can be created with `\fB!\fP\ mkdir\ directory'.
.TP
\fBmkdir\fP \fIdirectory-name\fP
Make a directory on the remote machine.
.TP
\fBmls\fP \fIremote-files\fP \fIlocal-file\fP
Like \fBls\fP, except multiple remote files may be specified.
If interactive prompting is on,
.I ftp
will prompt the user to verify that the last argument is indeed the
target local file for receiving
.B mls
output.
.TP
\fBmode\fP [ \fImode-name\fP ]
Set the file transfer
.I mode
to
.IR mode-name .
The default mode is \*(lqstream\*(rq mode.
.TP
\fBmput\fP \fIlocal-files\fP
Expand wild cards in the list of local files given as arguments
and do a \fBput\fR for each file in the resulting list.
See \fBglob\fP for details of filename expansion.
Resulting file names will then be processed according to
.I ntrans
and
.I nmap
settings.
.TP
\fBnmap\fP [ \fIinpattern\fP \fIoutpattern\fP ]
Set or unset the filename mapping mechanism.
If no arguments are specified, the filename mapping mechanism is unset.
If arguments are specified, remote filenames are mapped during
.B mput
commands and
.B put
commands issued without a specified remote target filename.
If arguments are specified, local filenames are mapped during
.B mget
commands and
.B get
commands issued without a specified local target filename.
This command is useful when connecting to a non-UNIX remote computer
with different file naming conventions or practices.
The mapping follows the pattern set by
.I inpattern
and
.IR outpattern .
.I Inpattern
is a template for incoming filenames (which may have already been
processed according to the
.B ntrans
and
.B case
settings).
Variable templating is accomplished by including the sequences '$1', '$2', ..., '$9' in
.IR inpattern .
Use '\\' to prevent this special treatment of the '$' character.
All other characters are treated literally, and are used to determine the
.B nmap
.I inpattern
variable values.
For exmaple, given
.I inpattern
$1.$2 and the remote file name "mydata.data", $1 would have the value
"mydata", and $2 would have the value "data".
The
.I outpattern
determines the resulting mapped filename.
The sequences '$1', '$2', ...., '$9' are replaced by any value resulting
from the
.I inpattern
template.
The sequence '$0' is replace by the original filename.
Additionally, the sequence '[\fIseq1\fP,\fIseq2\f\P]' is replaced by
.I seq1
if
.I seq1
is not a null string; otherwise it is replaced by
.IR seq2 .
For example, the command "nmap $1.$2.$3 [$1,$2].[$2,file]" would yield
the output filename "myfile.data" for input filenames "myfile.data" and
"myfile.data.old", "myfile.file" for the input filename "myfile", and
"myfile.myfile" for the input filename ".myfile".
Spaces may be included in
.IR outpattern ,
as in the example: nmap $1 |sed "s/  *$//" > $1 .
Use the '\\' character to prevent special treatment
of the '$', '[', ']', and ',' characters.
.TP
\fBntrans\fP [ \fIinchars\fP [ \fIoutchars\fP ] ]
Set or unset the filename character translation mechanism.
If no arguments are specified, the filename character
translation mechanism is unset.
If arguments are specified, characters in
remote filenames are translated during
.B mput
commands and
.B put
commands issued without a specified remote target filename.
If arguments are specified, characters in
local filenames are translated during
.B mget
commands and
.B get
commands issued without a specified local target filename.
This command is useful when connecting to a non-UNIX remote computer
with different file naming conventions or practices.
Characters in a filename matching a character in
.I inchars
are replaced with the corresponding character in
.IR outchars .
If the character's position in
.I inchars
is longer than the length of
.IR outchars ,
the character is deleted from the file name.
.TP
\fBopen\fP \fIhost\fP [ \fIport\fP ]
Establish a connection to the specified
.I host
FTP server.  An optional port number may be supplied,
in which case, 
.I ftp
will attempt to contact an FTP server at that port.
If the 
.I auto-login
option is on (default), 
.I ftp
will also attempt to automatically log the user in to
the FTP server (see below).
.TP
.B prompt
Toggle interactive prompting.  Interactive prompting
occurs during multiple file transfers to allow the
user to selectively retrieve or store files.
If prompting is turned off (default is on), any \fBmget\fP or \fBmput\fP
will transfer all files, and any \fBmdelete\fP will delete all files.
.TP
\fBproxy\fP \fIftp-command\fP
Execute an ftp command on a secondary control connection.
This command allows simultaneous connection to two remote ftp
servers for transferring files between the two servers.
The first
.B proxy
command should be an
.BR open ,
to establish the secondary control connection.
Enter the command "proxy ?" to see other ftp commands executable on the
secondary connection.
The following commands behave differently when prefaced by
.BR proxy :
.B open
will not define new macros during the auto-login process,
.B close
will not erase existing macro definitions,
.B get
and
.B mget
transfer files from the host on the primary control connection
to the host on the secondary control connection, and
.BR put ,
.BR mput ,
and
.B append
transfer files from the host on the secondary control connection
to the host on the primary control connection.
Third party file transfers depend upon support of the ftp protocol
PASV command by the server on the secondary control connection.
.TP
\fBput\fP \fIlocal-file\fP [ \fIremote-file\fP ]
Store a local file on the remote machine.  If 
.I remote-file
is left unspecified, the local file name is used
after processing according to any
.I ntrans
or
.I nmap
settings
in naming the remote file.  File transfer uses the
current settings for
.IR type ,
.IR format ,
.IR mode ,
and
.IR structure .
.TP
.B pwd
Print the name of the current working directory on the remote
machine.
.TP
.B quit
A synonym for
.BR bye .
.TP
.BI quote " arg1 arg2 ..."
The arguments specified are sent, verbatim, to the remote FTP
server.
.TP
\fBrecv\fP \fIremote-file\fP [ \fIlocal-file\fP ]
A synonym for get.
.TP
\fBremotehelp\fP [ \fIcommand-name\fP ]
Request help from the remote FTP server.  If a 
.I command-name
is specified it is supplied to the server as well.
.TP
\fBrename\fP [ \fIfrom\fP ] [ \fIto\fP ]
Rename the file
.I from
on the remote machine, to the file
.IR to .
.TP
.B reset
Clear reply queue.
This command re-synchronizes command/reply sequencing with the remote
ftp server.
Resynchronization may be neccesary following a violation of the ftp protocol
by the remote server.
.TP
.BI rmdir " directory-name"
Delete a directory on the remote machine.
.TP
.B runique
Toggle storing of files on the local system with unique filenames.
If a file already exists with a name equal to the target
local filename for a
.B get
or
.B mget
command, a ".1" is appended to the name.
If the resulting name matches another existing file,
a ".2" is appended to the original name.
If this process continues up to ".99", an error
message is printed, and the transfer does not take place.
The generated unique filename will be reported.
Note that
.B runique
will not affect local files generated from a shell command
(see below).
The default value is off.
.TP
\fBsend\fP \fIlocal-file\fP [ \fIremote-file\fP ]
A synonym for put.
.TP
.B sendport
Toggle the use of PORT commands.  By default, 
.I ftp
will attempt to use a PORT command when establishing
a connection for each data transfer.
The use of PORT commands can prevent delays
when performing multiple file transfers. If the PORT
command fails, 
.I ftp
will use the default data port.  When the use of PORT
commands is disabled, no attempt will be made to use
PORT commands for each data transfer.  This is useful
for certain FTP implementations which do ignore PORT
commands but, incorrectly, indicate they've been accepted.
.TP
.B status
Show the current status of
.IR ftp .
.TP
\fBstruct\fP [ \fIstruct-name\fP ]
Set the file transfer
.I structure
to
.IR struct-name .
By default \*(lqstream\*(rq structure is used.
.TP
.B sunique
Toggle storing of files on remote machine under unique file names.
Remote ftp server must support ftp protocol STOU command for
successful completion.
The remote server will report unique name.
Default value is off.
.TP
.B tenex
Set the file transfer type to that needed to
talk to TENEX machines.
.TP
.B trace
Toggle packet tracing.
.TP
\fBtype\fP [ \fItype-name\fP ]
Set the file transfer
.I type
to
.IR type-name .
If no type is specified, the current type
is printed.  The default type is network ASCII.
.TP
\fBuser\fP \fIuser-name\fP [ \fIpassword\fP ] [ \fIaccount\fP ]
Identify yourself to the remote FTP server.  If the
password is not specified and the server requires it,
.I ftp
will prompt the user for it (after disabling local echo).
If an account field is not specified, and the FTP server
requires it, the user will be prompted for it.
If an account field is specified, an account command will
be relayed to the remote server after the login sequence
is completed if the remote server did not require it
for logging in.
Unless
.I ftp
is invoked with \*(lqauto-login\*(rq disabled, this
process is done automatically on initial connection to
the FTP server.
.TP
.B verbose
Toggle verbose mode.  In verbose mode, all responses from
the FTP server are displayed to the user.  In addition,
if verbose is on, when a file transfer completes, statistics
regarding the efficiency of the transfer are reported.  By default,
verbose is on.
.TP
\fB?\fP [ \fIcommand\fP ]
A synonym for help.
.PP
Command arguments which have embedded spaces may be quoted with
quote (") marks.
.SH "ABORTING A FILE TRANSFER"
To abort a file transfer, use the terminal interrupt key
(usually Ctrl-C).
Sending transfers will be immediately halted.
Receiving transfers will be halted by sending a ftp protocol ABOR
command to the remote server, and discarding any further data received.
The speed at which this is accomplished depends upon the remote
server's support for ABOR processing.
If the remote server does not support the ABOR command, an "ftp>"
prompt will not appear until the remote server has completed
sending the requested file.
.PP
The terminal interrupt key sequence will be ignored when
.I ftp
has completed any local processing and is awaiting a reply
from the remote server.
A long delay in this mode may result from the ABOR processing described
above, or from unexpected behavior by the remote server, including
violations of the ftp protocol.
If the delay results from unexpected remote server behavior, the local
.I ftp
program must be killed by hand.
.SH "FILE NAMING CONVENTIONS"
Files specified as arguments to
.I ftp
commands are processed according to the following rules.
.TP
1)
If the file name \*(lq\-\*(rq is specified, the
.B stdin
(for reading) or
.B stdout
(for writing) is used.
.TP
2)
If the first character of the file name is \*(lq|\*(rq, the
remainder of the argument is interpreted as a shell command.
.I Ftp
then forks a shell, using 
.IR popen (3)
with the argument supplied, and reads (writes) from the stdout
(stdin).  If the shell command includes spaces, the argument
must be quoted; e.g. \*(lq"| ls -lt"\*(rq.  A particularly
useful example of this mechanism is: \*(lqdir |more\*(rq.
.TP
3)
Failing the above checks, if ``globbing'' is enabled, 
local file names are expanded
according to the rules used in the 
.IR csh (1);
c.f. the 
.I glob
command. 
If the
.I ftp
command expects a single local file ( .e.g.
.BR put ),
only the first filename generated by the "globbing" operation is used.
.TP
4)
For
.B mget
commands and
.B get
commands with unspecified local file names, the local filename is
the remote filename, which may be altered by a
.BR case ,
.BR ntrans ,
or
.B nmap
setting.
The resulting filename may then be altered if
.B runique
is on.
.TP
5)
For
.B mput
commands and
.B put
commands with unspecified remote file names, the remote filename is
the local filename, which may be altered by a
.B ntrans
or
.B nmap
setting.
The resulting filename may then be altered by the remote server if
.B sunique
is on.
.SH "FILE TRANSFER PARAMETERS"
The FTP specification specifies many parameters which may
affect a file transfer.  The 
.I type
may be one of \*(lqascii\*(rq, \*(lqimage\*(rq (binary),
\*(lqebcdic\*(rq, and \*(lqlocal byte size\*(rq (for PDP-10's
and PDP-20's mostly).
.I Ftp
supports the ascii and image types of file transfer,
plus local byte size 8 for \fBtenex\fP mode transfers.
.PP
.I Ftp
supports only the default values for the remaining
file transfer parameters: 
.IR mode ,
.IR form ,
and
.IR struct .
.SH OPTIONS
Options may be specified at the command line, or to the 
command interpreter.
.PP
The
.B \-v
(verbose on) option forces
.I ftp
to show all responses from the remote server, as well
as report on data transfer statistics.
.PP
The
.B \-n
option restrains 
.I ftp
from attempting \*(lqauto-login\*(rq upon initial connection.
If auto-login is enabled, 
.I ftp
will check the
.I .netrc
(see below) file in the user's home directory for an entry describing
an account on the remote machine.  If no entry exists,
.I ftp
will prompt for the remote machine login name (default is the user
identity on the local machine), and, if necessary, prompt for a password
and an account with which to login.
.PP
The
.B \-i
option turns off interactive prompting during
multiple file transfers.
.PP
The
.B \-d
option enables debugging.
.PP
The
.B \-g
option disables file name globbing.
.SH "THE .netrc FILE"
The .netrc file contains login and initialization information
used by the auto-login process.
It resides in the user's home directory.
The following tokens are recognized; they may be separated by spaces,
tabs, or new-lines:
.TP
\fBmachine\fP \fIname\fP
Identify a remote machine name.
The auto-login process searches the .netrc file for a
.B machine
token that matches the remote machine specified on the
.I ftp
command line or as an
.B open
command argument.
Once a match is made, the subsequent .netrc tokens are processed,
stopping when the end of file is reached or another
.B machine
token is encountered.
.TP
\fBlogin\fP \fIname\fP
Identify a user on the remote machine.
If this token is present, the auto-login process will initiate
a login using the specified name.
.TP
\fBpassword\fP \fIstring\fP
Supply a password.
If this token is present, the auto-login process will supply the
specified string if the remote server requires a password as part
of the login process.
Note that if this token is present in the .netrc file,
.I ftp
will abort the auto-login process if the .netrc is readable by
anyone besides the user.
.TP
\fBaccount\fP \fIstring\fP
Supply an additional account password.
If this token is present, the auto-login process will supply the
specified string if the remote server requires an additional
account password, or the auto-login process will initiate an
ACCT command if it does not.
.TP
\fBmacdef\fP \fIname\fP
Define a macro.
This token functions like the
.I ftp
.B macdef
command functions.
A macro is defined with the specified name; its contents begin with the
next .netrc line and continue until a null line (consecutive new-line
characters) is encountered.
If a macro named
.I init
is defined, it is automatically executed as the last step in the
auto-login process.
.SH "SEE ALSO"
ftpd(8)
.SH BUGS
Correct execution of many commands depends upon proper behavior
by the remote server.
.PP
An error in the treatment of carriage returns
in the 4.2BSD UNIX ascii-mode transfer code
has been corrected.
This correction may result in incorrect transfers of binary files
to and from 4.2BSD servers using the ascii type.
Avoid this problem by using the binary image type.
