.TH DSH 1X "10 November 1982"
.UC 4
.SH NAME
dsh \- distributed shell
.SH SYNOPSIS
.B dsh
[
.B \-a
] [
.B \-v
] [
.B \-h
host
] [
.B \-n
] [
.B \-i
copyto
] [
.B \-o
copyback
] command
.SH DESCRIPTION
.I Dsh
selects a host and executes the specified \fIcommand\fR on it.
If the command specifies a host using the 
.B \-h
option,  that host is used.
Otherwise the selection algorithm attempts to select the
least loaded of the hosts.  At the moment "least loaded" corresponds
to the lowest load average.
.I Dsh
copies its standard input to the remote command, the standard
output of the remote command to its standard output, and the
standard error of the remote command to its standard error.
Interrupt is propogated to the remote system.
\fIDsh\fP normally terminates when the remote command does.
.PP 
The host is selected from a list of hosts.  A default for this list
exists on each system in a file called 
.I /usr/lib/dshrc.
This list can be overridden by an entry in a 
.I .dshrc
file in the user's home directory.  The format of the entry is:
.PP
\ \ \ hosts = [<weight>]<host>, ... , [<weight>]<host>
.PP
where <host> can be simply a host name or a binary tuple of the form:
.PP
\ \ \ (<host name>, <account name>)
.PP
where <weight> is a multiplier of the form:
.PP
\ \ \ <decimal number>*
.PP
The account used to run the command is by default the account of
the user executing the dsh.  This can be overridden using the second
form of the host specification shown above.  For example a user "mini"
that wanted to execute commands on HOST1 as herself and on HOST2 as
"mickey" would have a 
.I .dshrc
file with the entry:
.PP
\ \ \ hosts = HOST1, (HOST2, mickey)
.PP
Of course "mickey" must have an entry in his .rhosts file to allow "mini"
to use his account.
.PP
If "mini" wanted to wieght HOST1 so that it 
would be used even when its load average was twice that of HOST2
she would use:
.PP
\ \ \ hosts = 2.1*HOST1, (HOST2, mickey)
.PP
The directory created to run the command in on the remote machine is 
normally in 
the account's login directory.  This can be overridden by another entry 
in the 
.I .dshrc
file of the format:
.PP
\ \ \ dir = <directory name>
.PP
If the 
.I \-v
option is specified
.I dsh
reports the name of the machine the command is executed on.
.PP
Shell metacharacters which are not quoted are interpreted
on local machine, while quoted metacharacters are interpreted on
the remote machine.
Thus the command
.PP
\ \ \ dsh cat remotefile >> localfile
.PP
appends the remote file
.I remotefile
to the localfile
.I localfile,
while
.PP
\ \ \ dsh cat remotefile ">>" otherremotefile
.PP
appends
.I remotefile
to
.I otherremotefile.
.PP
The
.I \-i 
option is used to transfer the 
.I copyto
file to the remote host before the command is executed.  More
than one 
.I \-i 
option may be specified.
.PP
The
.I \-o 
option is used to transfer the 
.I copyback
file back from the remote host after the command is executed.  More
than one 
.I \-o
option may be specified.
.PP
The 
.I \-a
option causes 
.I dsh
to try to execute the command on as many hosts as it can.
.PP
Host names are given in the file 
.I /usr/lib/hosts.
Each host
has one standard name (the first name given in the file), which
is rather long and unambiguous, and optionally one or more nicknames.
.SH FILES
.ta 2i
~/.dshrc	the user's initialization file
.br
/usr/lib/dshrc	the system defaults
.br
/usr/ucb/dbid	the bidder (must exist on each machine)
.DT
.SH SEE ALSO
rlogin(1x), rpasswd(1x), rsh(1x)
.SH BUGS
If you are using
.IR csh (1)
and put a
.IR dsh (1x)
in the background without redirecting its input
away from the terminal, it will block even if no reads
are posted by the remote command.  If no input is desired
you should redirect the input of
.I dsh
to /dev/null using the
.B \-n
option.
.PP
You cannot run an interactive command
(like
.IR rogue (6)
or
.I vi (6));
use
.IR rlogin (1x).
.PP
Stop signals stop the local \fIdsh\fP process only; this is arguably
wrong, but currently hard to fix for reasons too complicated to
explain here.
