.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ctags.1	6.4 (Berkeley) 3/16/87
.\"
.TH CTAGS 1 "March 16, 1987"
.UC 4
.SH NAME
ctags \- create a tags file
.SH SYNOPSIS
.B ctags
[ 
.B \-BFadtuwvx
] [
.B \-f
.I tagsfile
]
name ...
.SH DESCRIPTION
\fICtags\fP makes a tags file for \fIex\fP(1) from the specified C,
Pascal, Fortran, YACC, lex, and lisp sources.  A tags file gives the
locations of specified objects in a group of files.  Each line of the
tags file contains the object name, the file in which it is defined,
and a search pattern for the object definition, separated by white-space.
Using the \fItags\fP file, \fIex\fP(1) can quickly locate these object
definitions.  Depending on the options provided to \fIctags\fP,
objects will consist of subroutines, typedefs, defines, structs,
enums and unions.
.PP
Yacc and lex files each have a special tag.  \fIYyparse\fP is the start
of the second section of the yacc file, and \fIyylex\fP is the start of
the second section of the lex file.
.PP
If the \fB-x\fP flag is given, \fIctags\fP produces a list of object
names, the line number and file name on which each is defined, as well
as the text of that line and prints this on the standard output.  This
is a simple index which can be printed out as an off-line readable
function index.
.PP
If the \fB-v\fP flag is given, an index of the form expected by
\fIvgrind\fP(1) is produced on the standard output.  This listing
contains the object name, file name, and page number (assuming 64
line pages).  Since the output will be sorted into lexicographic order,
it may be desired to run the output through \fBsort -f\fP.
Sample use:
.nf
	ctags \-v files | sort \-f > index
	vgrind \-x index
.fi
.PP
Normally \fIctags\fP places the tag descriptions in a file called
\fItags\fP; this may be overridden with the \fB-f\fP option.
.PP
Files whose names end in \fB.c\fP or \fB.h\fP are assumed to be C
source files and are searched for C style routine and macro definitions.
Files whose names end in \fB.y\fP are assumed to be YACC source files.
Files whose names end in \fB.l\fP are assumed to be lisp files if their
first non-blank character is `;', `(', or `[', otherwise, they are
treated as lex files.  Other files are first examined to see if they
contain any Pascal or Fortran routine definitions, and, if not, are
searched for C style definitions.
.PP
Other options are:
.TP 5
.B \-F
use forward searching patterns (/.../) (the default).
.TP 5
.B \-B
use backward searching patterns (?...?).
.TP 5
.B \-a
append to \fItags\fP file.
.TP 5
.B \-d
create tags for \fI#defines\fP that don't take arguments; \fI#defines\fP
that take arguments are tagged automatically.
.TP 5
.B \-t
create tags for typedefs, structs, unions, and enums.
.TP 5
.B \-w
suppress warning diagnostics.
.TP 5
.B \-u
update the specified files in the \fItags\fP file, that is, all
references to them are deleted, and the new values are appended to the
file.  (Beware: this option is implemented in a way which is rather
slow; it is usually faster to simply rebuild the \fItags\fP file.)
.PP
The tag \fImain\fP is treated specially in C programs.  The tag formed
is created by prepending \fIM\fP to the name of the file, with the
trailing \fB.c\fP and any leading pathname components removed.  This
makes use of \fIctags\fP practical in directories with more than one
program.
.SH FILES
.DT
tags		default output tags file
.SH DIAGNOSTICS
\fICtags\fP exits with a value of 1 if an error occurred, where
duplicate objects are not considered errors, 0 otherwise.
.SH SEE ALSO
ex(1), vi(1)
.SH AUTHOR
Ken Arnold; FORTRAN added by Jim Kleckner; Bill Joy added Pascal and
\fB-x\fP, replacing \fIcxref\fP; C typedefs added by Ed Pelegri-Llopart.
.SH BUGS
Recognition of \fBfunctions\fR, \fBsubroutines\fR and \fBprocedures\fR
for FORTRAN and Pascal is done is a very simpleminded way.  No attempt
is made to deal with block structure; if you have two Pascal procedures
in different blocks with the same name you lose.  \fICtags\fP doesn't
understand about Pascal types.
.PP
The method of deciding whether to look for C, Pascal or FORTRAN
functions is a hack.
.PP
\fICtags\fP relies on the input being well formed, and any syntactical
errors will completely confuse it.  It also finds some legal syntax
confusing; for example, as it doesn't understand \fI#ifdef\fP's,
(incidentally, that's a feature, not a bug) any code with unbalanced
braces inside \fI#ifdef\fP's will cause it to become somewhat disoriented.
In a similar fashion, multiple line changes within a definition will
cause it to enter the last line of the object, rather than the first, as
the searching pattern.  The last line of multiple line \fItypedef\fP's
will similarly be noted.
