.\"	@(#)compress.1	6.5 (Berkeley) 5/11/86
.\"
.TH COMPRESS 1 "May 11, 1986"
.UC 6
.SH NAME
compress, uncompress, zcat \- compress and expand data
.SH SYNOPSIS
.PU
.ll +8
.B compress
[
.B \-f
] [
.B \-v
] [
.B \-c
] [
.B \-r
] [
.B \-b
.I bits
] [
.I "name \&..."
]
.ll -8
.br
.B uncompress
[
.B \-f
] [
.B \-v
] [
.B \-c
] [
.B \-r
] [
.I "name \&..."
]
.br
.B zcat
[
.B \-r
]
[
.I "name \&..."
]
.SH DESCRIPTION
.I Compress
reduces the size of the named files using adaptive Lempel-Ziv coding.
Whenever possible,
each file is replaced by one with the extension
.B "\&.Z,"
while keeping the same ownership modes, access and modification times.
If no files are specified, the standard input is compressed to the
standard output.
Compressed files can be restored to their original form using
.I uncompress
or
.I zcat.
.PP
The
.B \-f
option will force compression of
.IR name ,
even if it does not actually shrink
or the corresponding
.IR name .Z
file already exists.
Except when run in the background under
.IR /bin/sh ,
if
.B \-f
is not given the user is prompted as to whether an existing
.IR name .Z
file should be overwritten.
.PP
The
.B \-c
(``cat'') option makes
.I compress/uncompress
write to the standard output; no files are changed.
The nondestructive behavior of
.I zcat
is identical to that of
.I uncompress
.B \-c.
.PP
.I Compress
uses the modified Lempel-Ziv algorithm popularized in
"A Technique for High Performance Data Compression",
Terry A. Welch,
.I "IEEE Computer,"
vol. 17, no. 6 (June 1984), pp. 8-19.
Common substrings in the file are first replaced by 9-bit codes 257 and up.
When code 512 is reached, the algorithm switches to 10-bit codes and
continues to use more bits until the
limit specified by the
.B \-b
flag is reached (default 16).
.I Bits
must be between 9 and 16.  The default can be changed in the source to allow
.I compress
to be run on a smaller machine.
.PP
After the
.I bits
limit is attained,
.I compress
periodically checks the compression ratio.  If it is increasing,
.I compress
continues to use the existing code dictionary.  However,
if the compression ratio decreases,
.I compress
discards the table of substrings and rebuilds it from scratch.  This allows
the algorithm to adapt to the next "block" of the file.
.PP
Note that the
.B \-b
flag is omitted for
.I uncompress,
since the 
.I bits
parameter specified during compression
is encoded within the output, along with
a magic number to ensure that neither decompression of random data nor
recompression of compressed data is attempted. 
.PP
.ne 8
The amount of compression obtained depends on the size of the
input, the number of
.I bits
per code, and the distribution of common substrings.
Typically, text such as source code or English
is reduced by 50\-60%.
Compression is generally much better than that achieved by
Huffman coding (as used in
.IR pack ),
or adaptive Huffman coding
.RI ( compact ),
and takes less time to compute.
.PP
Symbolic links are handled by adding or removing the
.B .Z
suffix from both the link and its contents.  The file linked to
is not affected.  This, along with the
.B \-r
option allows large groups of files to be manipulated consistantly.
.PP
The
.B \-v
option causes
the printing of the percentage reduction of each file.
.PP
When the
.B \-r
option is given,
.I compress
,
.I uncompress
or
.I zcat
recursively descends any directory arguments.
.PP
If an error occurs, exit status is 1, else
if the last file was not compressed because it became larger, the status
is 2; else the status is 0.
.SH "DIAGNOSTICS"
Usage: compress [\-fvcr] [\-b maxbits] [file ...]
.in +8
Invalid options were specified on the command line.
.in -8
Missing maxbits
.in +8
Maxbits must follow
.BR \-b \.
.in -8
.IR file :
not in compressed format
.in +8
The file specified to
.I uncompress
has not been compressed.
.in -8
.IR file :
compressed with 
.I xx
bits, can only handle 
.I yy
bits
.in +8
.I File
was compressed by a program that could deal with
more 
.I bits
than the compress code on this machine.
Recompress the file with smaller
.IR bits \.
.in -8
.IR file :
already has .Z suffix -- no change
.in +8
The file is assumed to be already compressed.
Rename the file and try again.
.in -8
.IR file :
filename too long to tack on .Z
.in +8
The file cannot be compressed because its name is longer than
12 characters.
Rename and try again.
This message does not occur on BSD systems.
.in -8
.I file
already exists; do you wish to overwrite (y or n)?
.in +8
Respond "y" if you want the output file to be replaced; "n" if not.
.in -8
uncompress: corrupt input
.in +8
A SIGSEGV violation was detected which usually means that the input file is
corrupted.
.in -8
Compression: 
.I "xx.xx%"
.in +8
Percentage of the input saved by compression.
(Relevant only for
.BR \-v \.)
.in -8
-- not a regular file: unchanged
.in +8
When the input file is not a regular file,
(e.g. a directory), it is
left unaltered.
.in -8
-- has 
.I xx 
other links: unchanged
.in +8
The input file has links; it is left unchanged.  See
.IR ln "(1)"
for more information.
.in -8
-- file unchanged
.in +8
No savings is achieved by
compression.  The input remains virgin.
.in -8
.SH "BUGS"
Although compressed files are compatible between machines with large memory,
.BR \-b \12
should be used for file transfer to architectures with 
a small process data space (64KB or less, as exhibited by the DEC PDP
series, the Intel 80286, etc.)
.PP
.I compress
should be more flexible about the existence of the `.Z' suffix.
