.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mail.1	6.6 (Berkeley) 5/9/86
.\"
.TH MAIL 1 "May 9, 1986"
.UC 4
.SH NAME
mail \- send and receive mail
.SH SYNOPSIS
.B mail
[
.B \-v
]
[
.B \-i
]
[
.B \-n
]
[
.B \-s
subject
]
[
user ...
]
.br
.B mail
[
.B \-v
]
[
.B \-i
]
[
.B \-n
]
.B \-f
[
name
]
.br
.B mail
[
.B \-v
]
[
.B \-i
]
[
.B \-n
]
.B \-u
user
.SH INTRODUCTION
.I Mail
is a intelligent mail processing system, which has
a command syntax reminiscent of
.I ed
with lines replaced by messages.
.PP
The
.B \-v
flag puts mail into verbose mode; the details of
delivery are displayed on the users terminal.
The
.B \-i
flag causes tty interrupt signals to be ignored. This is
particularly useful when using
.I mail
on noisy phone lines.
The
.B \-n
flag inhibits the reading of /usr/lib/Mail.rc.
.PP
.I "Sending mail.\ "
To send a message to one or more people,
.I mail
can be invoked with arguments which are the names of people to 
whom the mail will be sent.  You are then expected to type in 
your message, followed
by an \s-2EOT\s0 (control\-D) at the beginning of a line.
A subject may be specified on the command line by using the
.B \-s
flag. (Only the first argument after the
.B \-s
flag is used as a subject; be careful to quote subjects
containing spaces.)
The section below, labeled
.I "Replying to or originating mail,"
describes some features of
.I mail
available to help you compose your letter.
.PP
.I "Reading mail.\ "
In normal usage
.I mail
is given no arguments and checks your mail out of the
post office, then
prints out a one line header of each message there.
The current message is initially the first message (numbered 1)
and can be printed using the
.B print
command (which can be abbreviated \fBp\fR).
You can move among the messages much as you move between lines in
.IR ed ,
with the commands `+' and `\-' moving backwards and forwards, and
simple numbers.
.PP
.I "Disposing of mail.\ "
After examining a message you can
.B delete
(\fBd\fR)
the message or
.B reply
(\fBr\fR)
to it.
Deletion causes the
.I mail
program to forget about the message.
This is not irreversible; the message can be
.B undeleted
(\fBu\fR)
by giving its number, or the
.I mail
session can be aborted by giving the
.B exit
(\fBx\fR)
command.
Deleted messages will, however, usually disappear never to be seen again.
.PP
.I "Specifying messages.\ "
Commands such as
.B print
and
.B delete
can be given a list of message numbers as arguments to apply
to a number of messages at once.
Thus ``delete 1 2'' deletes messages 1 and 2, while ``delete 1\-5''
deletes messages 1 through 5.
The special name ``*'' addresses all messages, and ``$'' addresses
the last message; thus the command
.B top
which prints the first few lines of a message could be used in
``top *'' to print the first few lines of all messages.
.PP
.I "Replying to or originating mail.\ "
You can use the
.B reply
command to
set up a response to a message, sending it back to the
person who it was from.
Text you then type in, up to an end-of-file,
defines the contents of the message.
While you are composing a message,
.I mail
treats lines beginning with the character `~' specially.
For instance, typing ``~m'' (alone on a line) will place a copy
of the current message into the response right shifting it by a tabstop.
Other escapes will set up subject fields, add and delete recipients
to the message and allow you to escape to an editor to revise the
message or to a shell to run some commands.  (These options
are given in the summary below.)
.PP
.I "Ending a mail processing session.\ "
You can end a
.I mail
session with the
.B quit
(\fBq\fR)
command.
Messages which have been examined go to your
.I mbox
file unless they have been deleted in which case they are discarded.
Unexamined messages go back to the post office.
The
.B \-f
option causes
.I mail
to read in the contents of your
.I mbox
(or the specified file)
for processing; when you
.BR quit ,
.I mail
writes undeleted messages back to this file.
The
.B \-u
flag is a short way of doing
"mail
.B \-f
/usr/spool/mail/user".
.PP
.I "Personal and systemwide distribution lists.\ "
It is also possible to create a personal distribution lists so that,
for instance, you can send mail to ``cohorts'' and have it go
to a group of people.
Such lists can be defined by placing a line like
.IP
alias cohorts bill ozalp jkf mark kridle@ucbcory
.PP
in the file \&.mailrc in your home directory.
The current list of such aliases can be displayed with the
.B alias
.B (a)
command in
.IR mail .
System wide distribution lists can be created by editing
/usr/lib/aliases, see
.IR aliases (5)
and
.IR sendmail (8);
these are kept in a different syntax.
In mail you send, personal aliases will be expanded in mail sent
to others so that they will be able to \fBreply\fR to the recipients.
System wide \fIaliases\fR are not expanded when the mail is sent,
but any reply returned to the machine will have the system wide
alias expanded as all mail goes through
.IR sendmail .
.PP
.I "Network mail (ARPA, UUCP, Berknet)\ "
See
.IR mailaddr(7)
for a description of network addresses.
.PP
.I Mail
has a number of options which can be set in the
.I \&.mailrc
file to alter its behavior; thus ``set askcc'' enables the ``askcc''
feature.  (These options are summarized below.)
.SH SUMMARY
(Adapted from the `Mail Reference Manual')
.PP
Each command is typed on a line by itself, and may take arguments
following the command word.  The command need not be typed in its
entirety \- the first command which matches the typed prefix is used.
For commands which take message lists as arguments, if no message
list is given, then the next message forward which satisfies the
command's requirements is used.  If there are no messages forward of
the current message, the search proceeds backwards, and if there are no
good messages at all,
.I mail
types ``No applicable messages'' and
aborts the command.
.TP 12n
.B \-
Goes to the previous message and prints it out.  If given a numeric
argument
.IR n ,
goes to the
.IR n -th
previous message and prints it.
.TP
.B ?
Prints a brief summary of commands.
.TP
.B !
Executes the \s-2UNIX\s0 shell command which follows.
.TP
.B Print
(\fBP\fR)
Like
.B print
but also prints out ignored header fields. See also
.B print
,
.B ignore
and
.B retain.
.TP
.B Reply
(\fBR\fR)
Reply to originator. Does not reply to other
recipients of the original message.
.TP
.B Type
(\fBT\fR)
Identical to the
.B Print
command.
.TP
.B alias
(\fBa\fR) With no arguments, prints out all currently-defined aliases.  With one
argument, prints out that alias.  With more than one argument, creates
an new or changes an on old alias.
.TP
.B alternates
(\fBalt\fR)
The
.B alternates
command is useful if you have accounts on several machines.
It can be used to inform
.I mail
that the listed addresses are really you. When you
.B reply
to messages,
.I mail
will not send a copy of the message to any of the addresses
listed on the
.I alternates
list. If the
.B alternates
command is given with no argument, the current set of alternate
names is displayed.
.TP
.B chdir
(\fBc\fR) Changes the user's working directory to that specified, if given.  If
no directory is given, then changes to the user's login directory.
.TP
.B copy
(\fBco\fR)
The
.B copy
command does the same thing that
.B save 
does, except that it does not mark the messages it
is used on for deletion when you quit.
.TP
.B delete
(\fBd\fR) Takes a list of messages as argument and marks them all as deleted.
Deleted messages will not be saved in
.IR mbox ,
nor will they be available for most other commands.  
.TP
.B dp
(also \fBdt\fR) Deletes the current message and prints the next message.
If there is no next message, 
.I mail
says ``at EOF.''
.TP
.B edit
(\fBe\fR) Takes a list of messages and points the text editor at each one in
turn.  On return from the editor, the message is read back in.
.TP
.B exit
(\fBex\fR or \fBx\fR) Effects an immediate return to the Shell without
modifying the user's system mailbox, his
.I mbox
file, or his edit file in
.BR \-f .
.TP
.B file
(\fBfi\fR)
The same as
.BR folder .
.TP
.B folders
List the names of the folders in your folder directory.
.TP
.B folder
(\fBfo\fR)
The
.B folder
command switches to a new mail file or folder. With no
arguments, it tells you which file you are currently reading.
If you give it an argument, it will write out changes (such
as deletions) you have made in the current file and read in
the new file. Some special conventions are recognized for
the name. # means the previous file, % means your system
mailbox, %user means user's system mailbox, & means
your \~/mbox file, and +folder means a file in your folder
directory.
.TP
.B from
(\fBf\fR) Takes a list of messages and prints their message headers.
.TP
.B headers
(\fBh\fR) Lists the current range of headers, which is an 18 message group.  If
a ``+'' argument is given, then the next 18 message group is printed, and if
a ``\-'' argument is given, the previous 18 message group is printed.
.TP
.B help
A synonym for ?
.TP
.B hold
(\fBho\fR, also \fBpreserve\fR) Takes a message list and marks each
message therein to be saved in the
user's system mailbox instead of in
.IR mbox .
Does not override the
.B delete
command.
.TP
.B ignore
.B N.B.:
.I Ignore
has been superseded by
.I retain.
.br
Add the list of header fields named to the
.IR "ignored list" .
Header fields in the ignore list are not printed
on your terminal when you print a message. This
command is very handy for suppression of certain machine-generated
header fields. The
.B Type
and
.B Print
commands can be used to print a message in its entirety, including
ignored fields. If
.B ignore
is executed with no arguments, it lists the current set of
ignored fields.
.TP
.B mail
(\fBm\fR) Takes as argument login names and distribution group names and sends
mail to those people.
.TP
.B mbox
Indicate that a list of messages be sent to
.I mbox
in your home directory when you quit. This is the default
action for messages if you do
.I not
have the
.I hold
option set.
.TP
.B next
(\fBn\fR like \fB+\fR or CR) Goes to the next message in sequence and types it.
With an argument list, types the next matching message.
.TP
.B preserve
(\fBpre\fR)
A synonym for
.BR hold .
.TP
.B print
(\fBp\fR)
Takes a message list and types out each message on the user's terminal.
.TP
.B quit
(\fBq\fR) Terminates the session, saving all undeleted, unsaved messages in
the user's
.I mbox
file in his login directory, preserving all messages marked with
.B hold
or
.B preserve
or never referenced
in his system mailbox, and removing all other messages from his system
mailbox.  If new mail has arrived during the session, the message
``You have new mail'' is given.  If given while editing a
mailbox file with the
.B \-f
flag, then the edit file is rewritten.  A return to the Shell is
effected, unless the rewrite of edit file fails, in which case the user
can escape with the
.B exit
command.
.TP
.B reply
(\fBr\fR)
Takes a message list and sends mail to the sender and all
recipients of the specified message.
The default message must not be deleted.
.TP
.B respond
A synonym for
.BR reply .
.TP
.B retain
Add the list of header fields named to the
.IR "retained list" .
Only the header fields in the retain list
are shown on your terminal when you print a message.
All other header fields are suppressed.
The
.B Type
and
.B Print
commands can be used to print a message in its entirety.
If
.B retain
is executed with no arguments, it lists the current set of
retained fields.
.TP
.B save
(\fBs\fR) Takes a message list and a filename and appends each message in
turn to the end of the file.  The filename in quotes, followed by the line
count and character count is echoed on the user's terminal.  
.TP
.B set
(\fBse\fR) With no arguments, prints all variable values.  Otherwise, sets
option.  Arguments are of the form
``option=value''
(no space before or after =) or
``option.''
.TP
.B shell
(\fBsh\fR) Invokes an interactive version of the shell.
.TP
.B size
Takes a message list and prints out the size in characters of each
message.
.TP
.B source
(\fBso\fR)
The
.B source
command reads
.I mail
commands from a file.
.TP
.B top
Takes a message list and prints the top few lines of each.  The number of
lines printed is controlled by the variable
.B toplines
and defaults to five.
.TP
.B type
(\fBt\fR) A synonym for
.BR print .
.TP
.B unalias
Takes a list of names defined by
.B alias
commands and discards the remembered groups of users.  The group names
no longer have any significance.
.TP
.B undelete
(\fBu\fR) Takes a message list and marks each message as
.I not
being deleted.
.TP
.B unread
(\fBU\fR) Takes a message list and marks each message as
.I not
having been read.
.TP
.B unset
Takes a list of option names and discards their remembered values;
the inverse of
.BR set .
.TP
.B visual
(\fBv\fR) Takes a message list and invokes the display editor on each message.
.TP
.B write
(\fBw\fR) Similar to
.BR save ,
except that
.I only
the message body (\fIwithout\fP the header) is saved.
Extremely useful for such tasks as sending and receiving source
program text over the message system.
.TP
.B xit
(\fBx\fR) A synonym for
.BR exit .
.TP
.B z
.I Mail
presents message headers in windowfuls as described under the
.B headers
command. You can move
.IR mail 's
attention forward to the next window with the
.B z
command. Also, you can move to the previous window by using
.BR z\- .
.PP
Here is a summary of the tilde escapes,
which are used when composing messages to perform
special functions.  Tilde escapes are only recognized at the beginning
of lines.  The name
``tilde\ escape''
is somewhat of a misnomer since the actual escape character can be set
by the option
.B escape.
.TP 12n
.BR ~! command
Execute the indicated shell command, then return to the message.
.TP
\fB~b\fR name ...
Add the given names to the list of carbon copy recipients but do not make
the names visible in the Cc: line ("blind" carbon copy).
.TP
\fB~c\fR name ...
Add the given names to the list of carbon copy recipients.
.TP
.B ~d
Read the file ``dead.letter'' from your home directory into the message.
.TP
.B ~e
Invoke the text editor on the message collected so far.  After the
editing session is finished, you may continue appending text to the
message.
.TP
\fB~f\fR messages
Read the named messages into the message being sent.
If no messages are specified, read in the current message.
.TP
.B ~h
Edit the message header fields by typing each one in turn and allowing
the user to append text to the end or modify the field by using the
current terminal erase and kill characters.
.TP
\fB~m\fR messages
Read the named messages into the message being sent, shifted right one
tab.  If no messages are specified, read the current message.
.TP
.B ~p
Print out the message collected so far, prefaced by the message header
fields.
.TP
.B ~q
Abort the message being sent, copying the message to
``dead.letter''
in your home directory if
.B save
is set.
.TP
\fB~r\fR filename
Read the named file into the message.
.TP
\fB~s\fR string
Cause the named string to become the current subject field.
.TP
\fB~t\fR name ...
Add the given names to the direct recipient list.
.TP
.B ~v
Invoke an alternate editor (defined by the VISUAL option) on the
message collected so far.  Usually, the alternate editor will be a
screen editor.  After you quit the editor, you may resume appending
text to the end of your message.
.TP
\fB~w\fR filename
Write the message onto the named file.
.TP
\fB~\||\|\fRcommand
Pipe the message through the command as a filter.  If the command gives
no output or terminates abnormally, retain the original text of the
message.  The command
.IR fmt (1)
is often used as
.I command
to rejustify the message.
.TP
.BR ~~ string
Insert the string of text in the message prefaced by a single ~.  If
you have changed the escape character, then you should double
that character in order to send it.
.PP
Options are controlled via the
.B set
and
.B unset
commands.  Options may be either binary, in which case it is only
significant to see whether they are set or not; or string, in which
case the actual value is of interest.
The binary options include the following:
.TP 15n
.B append
Causes messages saved in
.I mbox
to be appended to the end rather than prepended.
(This is set in
/usr/lib/Mail.rc
on version 7 systems.)
.TP
.B ask
Causes
.I mail
to prompt you for the subject of each message you send.  If
you respond with simply a newline, no subject field will be sent.
.TP
.B askcc
Causes you to be prompted for additional carbon copy recipients at the
end of each message.  Responding with a newline indicates your
satisfaction with the current list.
.TP
.B autoprint
Causes the
.B delete
command to behave like
.B dp
\- thus, after deleting a message, the next one will be typed
automatically.
.TP
.B debug
Setting the binary option
.I debug
is the same as specifying
.B \-d
on the command line and causes
.I mail
to output all sorts of information useful for debugging
.IR mail .
.TP
.B dot
The binary option
.I dot
causes
.I mail
to interpret a period alone on a line as the terminator
of a message you are sending.
.TP
.B hold
This option is used to hold messages in the system mailbox
by default.
.TP
.B ignore
Causes interrupt signals from your terminal to be ignored and echoed as
@'s.
.TP
.B ignoreeof
An option related to
.I dot
is
.I ignoreeof
which makes
.I mail
refuse to accept a control-d as the end of a message.
.I Ignoreeof
also applies to
.I mail
command mode.
.TP
.B metoo
Usually, when a group is expanded that contains the sender, the sender
is removed from the expansion.  Setting this option causes the sender
to be included in the group.
.TP
.B nosave
Normally, when you abort a message with two \s-2RUBOUT\s0,
.I mail
copies the partial letter to the file ``dead.letter''
in your home directory. Setting the binary option
.I nosave
prevents this.
.TP
.B Replyall
Reverses the sense of
.I reply
and
.I Reply
commands.
.TP
.B quiet
Suppresses the printing of the version when first invoked.
.TP
.B verbose
Setting the option
.I verbose
is the same as using the
.B \-v
flag on the command line. When mail runs in verbose mode,
the actual delivery of messages is displayed on he users
terminal.
.PP
The following options have string values:
.TP 15n
EDITOR
Pathname of the text editor to use in the
.B edit
command and ~e escape.  If not defined, then a default editor is used.
.TP
PAGER
Pathname of the program to use in the
.B more
command or when
.I crt
variable is set.  A default paginator is used if this option is
not defined.
.TP
SHELL
Pathname of the shell to use in the
.B !
command and the ~! escape.  A default shell is used if this option is
not defined.
.TP
VISUAL
Pathname of the text editor to use in the
.B visual
command and ~v escape.
.TP
.B crt
The valued option
.I crt
is used as a threshold to determine how long a message must
be before
.B PAGER
is used to read it.
.TP
.B escape
If defined, the first character of this option gives the character to
use in the place of ~ to denote escapes.
.TP
.B folder
The name of the directory to use for storing folders of
messages. If this name begins with a `/',
.I mail
considers it to be an absolute pathname; otherwise, the
folder directory is found relative to your home directory.
.TP
.B record
If defined, gives the pathname of the file used to record all outgoing
mail.  If not defined, then outgoing mail is not so saved.
.TP
.B toplines
If defined, gives the number of lines of a message to be printed out
with the
.B top
command; normally, the first five lines are printed.
.SH FILES
.if n .ta 2.5i
.if t .ta 1.8i
/usr/spool/mail/*	post office
.br
~/mbox	your old mail
.br
~/.mailrc	file giving initial mail commands
.br
/tmp/R#	temporary for editor escape
.br
/usr/lib/Mail.help*	help files
.br
/usr/lib/Mail.rc	system initialization file
.br
Message*	temporary for editing messages
.SH "SEE ALSO"
binmail(1), fmt(1), newaliases(1), aliases(5),
.br
mailaddr(7), sendmail(8)
.br
`The Mail Reference Manual'
.SH BUGS
There are many flags that are not documented here. Most are
not useful to the general user.
.br
Usually,
.I mail
is just a link to
.IR Mail ,
which can be confusing.
.SH AUTHOR
Kurt Shoens
