.TH MIG 1 1/19/87
.CM 4
.SH NAME
mig \- Mach message interface generator for Mach 2.5 systems
.SH SYNOPSIS
.B mig [-qQvVrRtT] [-user <name>] [-server <name>] 
.B [-header <name>]
definitions-file

.SH DESCRIPTION
.I mig(1)
uses the interface definitions in the definitions-file and creates two c
modules: subsystemUser.c and subsystemServer.c. These modules
implement respectively the user and the server ends of a
remote procedure call interface to the subsystem. A header file
subsystem.h is also generated that defines the external
functions and can be included in any code using the user
interface.

The switches are:
.TP
.I -r,-R
If r, use msg_rpc, if R use msg_send, msg_receive pairs. The default is
.I r.
.TP
.I -q,-Q
If -q, warning statements will be suppressed. If -Q warning statements
are printed. The default is
.I Q.
.TP
.I -v,-V
If v, all the types, routines and arguments are printed out as
they are encountered. If V, the compilation is silent. The
default is
.I V.
.TP
.I -s,-S
If s, a symbol table of rpc-name, number, routine triplets is generated
in the server file.  If S, the symbol table is not generated. The default
is
.I S.
.TP
.I -i
If this switch is specified, each user routine is put in its own file,
for ease in building a library.  The file name is <routine_name>.c.
If this
switch is not specified (the default), all of the user routines are
put in the same file.
.TP
.I -user <name>
Name the user file <name>.  If not specified, the user file is named
<subsystem>User.c.
.TP
.I -server <name>
Name the server file <name>.  If not specified, the server file is named
<subsystem>Server.c.
.TP
.I -header <name>
Name the header file <name>.  If not specified, the server file is named
<subsystem>.h.
.i0
.DT

.SH FILES
/usr/mach/include/mig_errors.h \- error codes generated by mig code
.br
subsystemUser.c \- the code for the user side of the interface
.br
subsystem.h \- the include file for the user routines
.br
subsystemServer.h \- the code for the server side of the interface

.SH "SEE ALSO"
/usr/mach/doc/mig.PS \- manual that defines the syntax
of the definitions file.

.SH HISTORY
.TP
8-Feb-88   David B. Golub (dbg)
Updated document to reflect new switches.

.TP
21-Jul-87  Mary R. Thompson (mrt)
Updated document to reflect new switches.

.TP
2-Mar-87   Mary R. Thompson (mrt)
Updated document to reflect -q switch and new name for the syntax 
definitions file.

.TP
20-Aug-86  Mary R. Thompson (mrt)
Created man page. mig was created by Michael W. Young from
the Spice Matchmaker program

