.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sendmail.8	6.2 (Berkeley) 5/22/86
.\"
.\"	@(#)sendmail.8	4.2		7/28/83
.TH SENDMAIL 8 "May 22, 1986"
.UC 4
.SH NAME
sendmail \- send mail over the internet
.SH SYNOPSIS
.B /usr/lib/sendmail
[
flags
] [
address ...
]
.PP
.B newaliases
.PP
.B mailq
[
.B \-v
]
.SH DESCRIPTION
.I Sendmail
sends a message to one or more
.IR recipients ,
routing the message over whatever networks
are necessary.
.I Sendmail
does internetwork forwarding as necessary
to deliver the message to the correct place.
.PP
.I Sendmail
is not intended as a user interface routine;
other programs provide user-friendly
front ends;
.I sendmail
is used only to deliver pre-formatted messages.
.PP
With no flags,
.I sendmail
reads its standard input
up to an end-of-file
or a line consisting only of a single dot
and sends a copy of the message found there
to all of the addresses listed.
It determines the network(s) to use
based on the syntax and contents of the addresses.
.PP
Local addresses are looked up in a file
and aliased appropriately.
Aliasing can be prevented by preceding the address
with a backslash.
Normally the sender is not included in any alias
expansions, e.g.,
if `john' sends to `group',
and `group' includes `john' in the expansion,
then the letter will not be delivered to `john'.
.PP
Flags are:
.TP 1.2i
.B \-ba
Go into \s-1ARPANET\s0 mode.
All input lines must end with a CR-LF,
and all messages will be generated with a CR-LF at the end.
Also,
the ``From:'' and ``Sender:''
fields are examined for the name of the sender.
.TP 1.2i
.B \-bd
Run as a daemon.  This requires Berkeley IPC.
.I Sendmail
will fork and run in background
listening on socket 25 for incoming SMTP connections.
This is normally run from
.IR /etc/rc .
.TP 1.2i
.B \-bi
Initialize the alias database.
.TP 1.2i
.B \-bm
Deliver mail in the usual way (default).
.TP 1.2i
.B \-bp
Print a listing of the queue.
.TP 1.2i
.B \-bs
Use the \s-2SMTP\s0 protocol as described in RFC821
on standard input and output.
This flag implies all the operations of the
.B \-ba
flag that are compatible with \s-2SMTP\s0.
.TP 1.2i
.B \-bt
Run in address test mode.
This mode reads addresses and shows the steps in parsing;
it is used for debugging configuration tables.
.TP 1.2i
.B \-bv
Verify names only \- do not try to collect or deliver a message.
Verify mode is normally used for validating
users or mailing lists.
.TP 1.2i
.B \-bz
Create the configuration freeze file.
.TP 1.2i
.BI \-C file
Use alternate configuration file.
.I Sendmail
refuses to run as root if an alternate configuration file is specified.
The frozen configuration file is bypassed.
.TP 1.2i
.BI \-d X
Set debugging value to
.I X.
.TP 1.2i
.BI \-F fullname
Set the full name of the sender.
.TP 1.2i
.BI \-f name
Sets the name of the ``from'' person
(i.e., the sender of the mail).
.B \-f
can only be used
by ``trusted'' users
(normally
.I root,
.I daemon,
and
.I network)
or if the person you are trying to become
is the same as the person you are.
.TP 1.2i
.BI \-h N
Set the hop count to
.I N.
The hop count is incremented every time the mail is
processed.
When it reaches a limit,
the mail is returned with an error message,
the victim of an aliasing loop.
If not specified,
``Received:'' lines in the message are counted.
.TP 1.2i
.B \-n
Don't do aliasing.
.TP 1.2i
.BI \-o x\|value
Set option
.I x
to the specified
.I value.
Options are described below.
.TP 1.2i
.BI \-q[ time ]
Processed saved messages in the queue at given intervals.
If
.I time
is omitted,
process the queue once.
.I Time
is given as a tagged number,
with `s' being seconds,
`m' being minutes,
`h' being hours,
`d' being days,
and
`w' being weeks.
For example,
``\-q1h30m'' or ``\-q90m''
would both set the timeout to one hour thirty minutes.
If
.I time
is specified,
.I sendmail
will run in background.
This option can be used safely with
.BR \-bd .
.TP 1.2i
.BI \-r name
An alternate and obsolete form of the
.B \-f
flag.
.TP 1.2i
.B \-t
Read message for recipients.
To:, Cc:, and Bcc: lines will be scanned for recipient addresses.
The Bcc: line will be deleted before transmission.
Any addresses in the argument list will be suppressed,
that is,
they will
.I not
receive copies even if listed in the message header.
.TP 1.2i
.B \-v
Go into verbose mode.
Alias expansions will be announced, etc.
.PP
There are also a number of processing options that may be set.
Normally these will only be used by a system administrator.
Options may be set either on the command line
using the
.B \-o
flag
or in the configuration file.
These are described in detail in the
.ul
Sendmail Installation and Operation Guide.
The options are:
.TP 1.2i
.RI A file
Use alternate alias file.
.TP 1.2i
c
On mailers that are considered ``expensive'' to connect to,
don't initiate immediate connection.
This requires queueing.
.TP 1.2i
.RI d x
Set the delivery mode to
.I x.
Delivery modes are
`i' for interactive (synchronous) delivery,
`b' for background (asynchronous) delivery,
and
`q' for queue only \- i.e.,
actual delivery is done the next time the queue is run.
.TP 1.2i
D
Try to automatically rebuild the alias database
if necessary.
.TP 1.2i
.RI e x
Set error processing to mode
.I x.
Valid modes are
`m' to mail back the error message,
`w' to ``write'' back the error message
(or mail it back if the sender is not logged in),
`p' to print the errors on the terminal
(default),
`q' to throw away error messages
(only exit status is returned),
and `e'
to do special processing for the BerkNet.
If the text of the message is not mailed back
by
modes `m' or `w'
and if the sender is local to this machine,
a copy of the message is appended to the file
``dead.letter''
in the sender's home directory.
.TP 1.2i
.RI F mode
The mode to use when creating temporary files.
.TP 1.2i
f
Save UNIX-style From lines at the front of messages.
.TP 1.2i
.RI g N
The default group id to use when calling mailers.
.TP 1.2i
.RI H file
The SMTP help file.
.TP 1.2i
i
Do not take dots on a line by themselves
as a message terminator.
.TP 1.2i
.RI L n
The log level.
.TP 1.2i
m
Send to ``me'' (the sender) also if I am in an alias expansion.
.TP 1.2i
o
If set, this message may have
old style headers.
If not set,
this message is guaranteed to have new style headers
(i.e., commas instead of spaces between addresses).
If set, an adaptive algorithm is used that will correctly
determine the header format in most cases.
.TP 1.2i
.RI Q queuedir
Select the directory in which to queue messages.
.TP 1.2i
.RI r timeout
The timeout on reads;
if none is set,
.I sendmail
will wait forever for a mailer.
This option violates the word (if not the intent) of the SMTP specification,
show the timeout should probably be fairly large.
.TP 1.2i
.RI S file
Save statistics in the named file.
.TP 1.2i
s
Always instantiate the queue file,
even under circumstances where it is not strictly necessary.
This provides safety against system crashes during delivery.
.TP 1.2i
.RI T time
Set the timeout on undelivered messages in the queue to the specified time.
After delivery has failed
(e.g., because of a host being down)
for this amount of time,
failed messages will be returned to the sender.
The default is three days.
.TP 1.2i
.RI t stz,dtz
Set the name of the time zone.
.TP 1.2i
.RI u N
Set the default user id for mailers.
.PP
In aliases,
the first character of a name may be
a vertical bar to cause interpretation of
the rest of the name as a command
to pipe the mail to.
It may be necessary to quote the name
to keep
.I sendmail
from suppressing the blanks from between arguments.
For example, a common alias is:
.PP
	msgs: "|/usr/ucb/msgs -s"
.PP
Aliases may also have the syntax ``:include:\c
.IR filename ''
to ask
.I sendmail
to read the named file for a list of recipients.
For example, an alias such as:
.PP
	poets: ":include:/usr/local/lib/poets.list"
.PP
would read
.I /usr/local/lib/poets.list
for the list of addresses making up the group.
.PP
.I Sendmail
returns an exit status
describing what it did.
The codes are defined in
.RI < sysexits.h >
.ta 3n +\w'EX_UNAVAILABLE'u+3n
.de XX
.ti \n(.iu
..
.in +\w'EX_UNAVAILABLE'u+6n
.XX
 	EX_OK	Successful completion on all addresses.
.XX
 	EX_NOUSER	User name not recognized.
.XX
 	EX_UNAVAILABLE	Catchall meaning necessary resources
were not available.
.XX
 	EX_SYNTAX	Syntax error in address.
.XX
 	EX_SOFTWARE	Internal software error,
including bad arguments.
.XX
 	EX_OSERR	Temporary operating system error,
such as \*(lqcannot fork\*(rq.
.XX
 	EX_NOHOST	Host name not recognized.
.XX
	EX_TEMPFAIL	Message could not be sent immediately,
but was queued.
.PP
If invoked as
.I newaliases,
.I sendmail
will rebuild the alias database.
If invoked as
.I mailq,
.I sendmail
will print the contents of the mail queue.
.SH FILES
Except for
/usr/lib/sendmail.cf,
these pathnames are all specified in
/usr/lib/sendmail.cf.
Thus,
these values are only approximations.
.PP
.if t .ta 2i
.if n .ta 3i
/usr/lib/aliases	raw data for alias names
.br
/usr/lib/aliases.pag
.br
/usr/lib/aliases.dir	data base of alias names
.br
/usr/lib/sendmail.cf	configuration file
.br
/usr/lib/sendmail.fc	frozen configuration
.br
/usr/lib/sendmail.hf	help file
.br
/usr/lib/sendmail.st	collected statistics
.br
/usr/spool/mqueue/*	temp files
.SH SEE\ ALSO
binmail(1), mail(1), rmail(1),
syslog(3),
aliases(5), sendmail.cf(5),
mailaddr(7),
rc(8);
.br
DARPA Internet Request For Comments
RFC819, RFC821, RFC822;
.br
.ul
Sendmail \- An Internetwork Mail Router
(SMM:16);
.br
.ul
Sendmail Installation and Operation Guide
(SMM:7)
