.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)termcap.3	6.2 (Berkeley) 9/14/87
.\"
.TH TERMCAP 3X "September 14, 1987"
.UC 4
.SH NAME
tgetent, tgetnum, tgetflag, tgetstr, tgoto, tputs \- terminal independent operation routines
.SH SYNOPSIS
.nf
.B char PC;
.B char *BC;
.B char *UP;
.B short ospeed;
.PP
.B tgetent(bp, name)
.B char *bp, *name;
.PP
.B tgetnum(id)
.B char *id;
.PP
.B tgetflag(id)
.B char *id;
.PP
.B char *
.B tgetstr(id, area)
.B char *id, **area;
.PP
.B char *
.B tgoto(cm, destcol, destline)
.B char *cm;
.PP
.B tputs(cp, affcnt, outc)
.B register char *cp;
.B int affcnt;
.B int (*outc)();
.fi
.SH DESCRIPTION
These functions extract and use capabilities from a terminal capability data
base, usually /etc/termcap, the format of which is described in
.IR termcap (5).
These are low level routines;
see
.IR curses (3X)
for a higher level package.
.PP
.I Tgetent
extracts the entry for terminal
.I name
into the buffer at
.I bp.
.I Bp
should be a character buffer of size
1024 and must be retained through all subsequent calls to
.I tgetnum,
.I tgetflag,
and
.I tgetstr.
.I Tgetent
returns \-1 if none of the termcap
data base files could be opened,
0 if the terminal name given does not have an entry,
and 1 if all goes well.
It will look in the environment for a TERMCAP variable.
If found, and the value does not begin with a slash,
and the terminal type
.I name
is the same as the environment string TERM,
the TERMCAP string is used instead of reading a termcap file.
If it does begin with a slash, the string is used as a path name
of the termcap file to search.
If TERMCAP does not begin with a slash and
.I name
is different from TERM,
.I tgetent
searches the files $HOME/.termcap and /etc/termcap,
in that order, unless the environment variable TERMPATH exists,
in which case it specifies a list of file pathnames
(separated by spaces or colons) to be searched instead.
Whenever multiple files are searched and a
.B tc
field occurs in the requested entry, the entry it names must be found
in the same file or one of the succeeding files.
This can speed up entry into programs that call
.IR tgetent ,
as well as help debug new terminal descriptions
or make one for your terminal if you can't write the file /etc/termcap.
.PP
.I Tgetnum
gets the numeric value of capability
.I id,
returning \-1 if is not given for the terminal.
.I Tgetflag
returns 1 if the specified capability is present in
the terminal's entry, 0 if it is not.
.I Tgetstr
returns the string value of the capability
.I id,
places it in the buffer at
.I area,
and advances the
.I area
pointer.
It decodes the abbreviations for this field described in
.IR termcap (5),
except for cursor addressing and padding information.
.I Tgetstr
returns NULL if the capability was not found.
.PP
.I Tgoto
returns a cursor addressing string decoded from
.I cm
to go to column
.I destcol
in line
.I destline.
It uses the external variables
.B UP
(from the \fBup\fR capability)
and
.B BC
(if \fBbc\fR is given rather than \fBbs\fR)
if necessary to avoid placing \fB\en\fR, \fB^D\fR or \fB^@\fR in
the returned string.
(Programs which call tgoto should be sure to turn off the XTABS bit(s),
since
.I tgoto
may now output a tab.
Note that programs using termcap should in general turn off XTABS
anyway since some terminals use control-I for other functions,
such as nondestructive space.)
If a \fB%\fR sequence is given which is not understood, then
.I tgoto
returns \*(lqOOPS\*(rq.
.PP
.I Tputs
decodes the leading padding information of the string
.IR cp ;
.I affcnt
gives the number of lines affected by the operation, or 1 if this is
not applicable,
.I outc
is a routine which is called with each character in turn.
The external variable
.I ospeed
should contain the output speed of the terminal as encoded by
.IR stty (3).
The external variable
.B PC
should contain a pad character to be used (from the \fBpc\fR capability)
if a null (\fB^@\fR) is inappropriate.
.SH FILES
.ta \w'/usr/lib/libtermcap.a  'u
/usr/lib/libtermcap.a	\-ltermcap library (also known as \-ltermlib)
.br
/etc/termcap	standard terminal capability data base
.br
$HOME/.termcap	user's terminal capability data base
.DT
.SH SEE ALSO
ex(1), curses(3X), termcap(5)
.SH AUTHOR
William Joy
