.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)snake.6	6.2 (Berkeley) 4/20/88
.\"
.TH SNAKE 6 "April 20, 1988"
.UC 4
.SH NAME
snake, snscore \- display chase game
.SH SYNOPSIS
.B snake
[
.B -w width
] [
.B -l length
]
.br
.B snscore
.SH DESCRIPTION
Snake is a display-based game which must be played on a CRT terminal.
The object of the game is to make as much money as possible without
getting eaten by the snake.  The
.B \-l
and
.B \-w
options allow you to specify the length and width of the field.
By default the entire screen (except for the last column) is used.
.PP
You are represented on the screen by an I.
The snake is 6 squares long and is represented by S's.
The money is $, and an exit is #.
Your score is posted in the upper left hand corner.
.PP
You can move around using the same conventions as vi(1),
the h, j, k, and l keys work, as do the arrow keys.
Other possibilities include:
.IP sefc
These keys are like hjkl but form a directed pad around the d key.
.IP HJKL
These keys move you all the way in the indicated direction to the
same row or column as the money.  This does
.I not
let you jump away from the snake, but rather saves you from having
to type a key repeatedly.  The snake still gets all his turns.
.IP SEFC
Likewise for the upper case versions on the left.
.IP ATPB
These keys move you to the four edges of the screen.
Their position on the keyboard is the mnemonic, e.g.
P is at the far right of the keyboard.
.IP x
This lets you quit the game at any time.
.IP p
Points in a direction you might want to go.
.IP w
Space warp to get out of tight squeezes, at a price.
.PP
To earn money, move to the same square the money is on.
A new $ will appear when you earn the current one.
As you get richer, the snake gets hungrier.
To leave the game, move to the exit (#).
.PP
A record is kept of the personal best score of each player.
Scores are only counted if you leave at the exit,
getting eaten by the snake is worth nothing.
.PP
As in pinball, matching the last digit of your score to the number
which appears after the game is worth a bonus.
.PP
To see who wastes time playing snake, run
.I snscore .
.SH FILES
.nf
.ta \w'/usr/games/lib/snakerawscores 'u
/usr/games/lib/snakerawscores	database of personal bests
/usr/games/lib/snake.log	log of games played
.DT
.fi
.SH BUGS
.PP
When playing on a small screen,
it's hard to tell when you hit the edge of the screen.
.PP
The scoring function takes into account the size of the screen.
A perfect function to do this equitably has not been devised.
