.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mille.6	6.2 (Berkeley) 5/6/86
.\"
.TH MILLE 6 "May 6, 1986"
.UC 4
.SH NAME
mille \- play Mille Bournes
.SH SYNOPSIS
.B /usr/games/mille
[ file ]
.SH DESCRIPTION
.I Mille
plays a two-handed game reminiscent of
the Parker Brother's game of Mille Bournes with you.
The rules are described below.
If a file name is given on the command line,
the game saved in that file is started.
.PP
When a game is started up,
the bottom of the score window will contain a list of commands.
They are:
.IP P
Pick a card from the deck.
This card is placed in the `P' slot in your hand.
.IP D
Discard a card from your hand.
To indicate which card, type the number of the card in the hand
(or \*(lqP\*(rq for the just-picked card) followed by a <RETURN> or <SPACE>.
The <RETURN or <SPACE> is required to allow recovery from typos
which can be very expensive, like discarding safeties.
.IP U
Use a card.
The card is again indicated by its number, followed by a <RETURN> or <SPACE>.
.IP O
Toggle ordering the hand.
By default off, if turned on it will sort the cards in your hand appropriately.
This is not recommended for the impatient on slow terminals.
.IP Q
Quit the game.
This will ask for confirmation, just to be sure.
Hitting <DELETE> (or <RUBOUT>) is equivalent.
.IP S
Save the game in a file.
If the game was started from a file,
you will be given an opportunity to save it on the same file.
If you don't wish to, or you did not start from a file,
you will be asked for the file name.
If you type a <RETURN> without a name,
the save will be terminated and the game resumed.
.IP R
Redraw the screen from scratch.
The command ^L (control `L') will also work.
.IP W
Toggle window type.
This switches the score window between the startup window
(with all the command names) and the end-of-game window.
Using the end-of-game window
saves time by eliminating the switch at the end of the game
to show the final score.
Recommended for hackers and other miscreants.
.PP
If you make a mistake, an error message will be printed
on the last line of the score window, and a bell will beep.
.PP
At the end of each hand or game,
you will be asked if you wish to play another.
If not, it will ask you if you want to save the game.
If you do, and the save is unsuccessful,
play will be resumed as if you had said you wanted to play another hand/game.
This allows you to use the
.RB \*(lq S \*(rq
command to reattempt the save.
.SH AUTHOR
Ken Arnold
.br
(The game itself is a product of Parker Brothers, Inc.)
.SH "SEE ALSO"
curses(3X),
.I "Screen Updating and Cursor Movement Optimization:"
.IR "A Library Package" ,
Ken Arnold
.SH CARDS
.PP
Here is some useful information.
The number in parentheses after the card name
is the number of that card in the deck:
.sp
.nf
.ne 10
.ta \w'Speed Limit (3)'u+3n \w'Speed Limit (3)'u+\w'End of Limit (6)'u+6n
Hazard	Repair	Safety
.sp
Out of Gas (2)	Gasoline (6)	Extra Tank (1)
Flat Tire (2)	Spare Tire (6)	Puncture Proof (1)
Accident (2)	Repairs (6)	Driving Ace (1)
Stop (4)	Go (14)	Right of Way (1)
Speed Limit (3)	End of Limit (6)
.sp
.ce
25 \- (10), 50 \- (10), 75 \- (10), 100 \- (12), 200 \- (4)
.sp
.fi
.DT
.SH RULES
.PP
.BR Object :
The point of this game is to get a total of 5000 points in several hands.
Each hand is a race to put down exactly 700 miles before your opponent does.
Beyond the points gained by putting down milestones,
there are several other ways of making points.
.PP
.BR Overview :
The game is played with a deck of 101 cards.
.I Distance
cards represent a number of miles traveled.
They come in denominations of 25, 50, 75, 100, and 200.
When one is played,
it adds that many miles to the player's trip so far this hand.
.I Hazard
cards are used to prevent your opponent from putting down Distance cards.
They can only be played if your opponent has a
.I Go
card on top of the Battle pile.
The cards are
.IR "Out of Gas" ,
.IR "Accident" ,
.IR "Flat Tire" ,
.IR "Speed Limit" ,
and
.IR "Stop" .
.I Remedy
cards fix problems caused by Hazard cards played on you by your opponent.
The cards are
.IR "Gasoline" ,
.IR "Repairs" ,
.IR "Spare Tire" ,
.IR "End of Limit" ,
and
.IR "Go" .
.I Safety
cards prevent your opponent from putting specific Hazard cards on you
in the first place.
They are
.IR "Extra Tank" ,
.IR "Driving Ace" ,
.IR "Puncture Proof" ,
and
.IR "Right of Way" ,
and there are only one of each in the deck.
.PP
.BR "Board Layout" :
The board is split into several areas.
From top to bottom, they are:
.B "SAFETY AREA"
(unlabeled): This is where the safeties will be placed as they are played.
.BR HAND :
These are the cards in your hand.
.BR BATTLE :
This is the Battle pile.
All the Hazard and Remedy Cards are played here, except the
.I "Speed Limit"
and
.I "End of Limit"
cards.  Only the top card is displayed, as it is the only effective one.
.BR SPEED :
The Speed pile.  The
.I "Speed Limit"
and
.I "End of Limit"
cards are played here
to control the speed at which the player is allowed to put down miles.
.BR MILEAGE :
Miles are placed here.
The total of the numbers shown here is the distance traveled so far.
.PP
.BR Play :
The first pick alternates between the two players.
Each turn usually starts with a pick from the deck.
The player then plays a card, or if this is not possible or desirable,
discards one.  Normally, a play or discard of a single card
constitutes a turn.  If the card played is a safety, however,
the same player takes another turn immediately.
.PP
This repeats until one of the players reaches 700 points or the deck runs out.
If someone reaches 700, they have the option of going for an
.IR Extension ,
which means that the play continues until someone reaches 1000 miles.
.PP
.BR "Hazard and Remedy Cards" :
Hazard Cards are played on your opponent's Battle and Speed piles.
Remedy Cards are used for undoing the effects of your opponent's nastiness.
.PP
.RB "\ \ \ \ " Go
(Green Light)
must be the top card on your Battle pile for you to play any mileage,
unless you have played the
.I "Right of Way"
card (see below).
.br
.RB "\ \ \ \ " Stop
is played on your opponent's
.I Go
card to prevent them from playing mileage until they play a
.I Go
card.
.br
.RB "\ \ \ \ " "Speed Limit"
is played on your opponent's Speed pile.
Until they play an
.I "End of Limit"
they can only play 25 or 50 mile cards, presuming their
.I Go
card allows them to do even that.
.br
.RB "\ \ \ \ " "End of Limit"
is played on your Speed pile to nullify a
.I "Speed Limit"
played by your opponent.
.br
.RB "\ \ \ \ " "Out of Gas"
is played on your opponent's
.I Go
card.  They must then play a
.I Gasoline
card, and then a
.I Go
card before they can play any more mileage.
.br
.RB "\ \ \ \ " "Flat Tire"
is played on your opponent's
.I Go
card.  They must then play a
.I "Spare Tire"
card, and then a
.I Go
card before they can play any more mileage.
.br
.RB "\ \ \ \ " "Accident"
is played on your opponent's
.I Go
card.  They must then play a
.I Repairs
card, and then a
.I Go
card before they can play any more mileage.
.br
.PP
.BR "Safety Cards" :
Safety cards prevent your opponent
from playing the corresponding Hazard cards on you for the rest of the hand.
It cancels an attack in progress, and
.IR "always entitles the player to an extra turn" .
.br
.RB "\ \ \ \ "  "Right of Way"
prevents your opponent from playing both
.I Stop
and
.I "Speed Limit"
cards on you.  It also acts as a permanent
.I Go
card for the rest of the hand, so you can play mileage
as long as there is not a Hazard card on top of your Battle pile.
In this case only, your opponent can play Hazard cards directly on a Remedy card
other than a Go card.
.br
.RB "\ \ \ \ " "Extra Tank"
When played, your opponent cannot play an
.I "Out of Gas"
on your Battle Pile.
.br
.RB "\ \ \ \ " "Puncture Proof"
When played, your opponent cannot play a
.I "Flat Tire"
on your Battle Pile.
.br
.RB "\ \ \ \ " "Driving Ace"
When played, your opponent cannot play an
.I Accident
on your Battle Pile.
.PP
.BR "Distance Cards" :
Distance cards are played when you have a
.I Go
card on your Battle pile,
or a Right of Way in your Safety area and are not stopped by a Hazard Card.
They can be played in any combination that totals exactly 700 miles,
except that
.IR "you cannot play more than two 200 mile cards in one hand" .
A hand ends whenever one player gets exactly 700 miles or the deck runs out.
In that case, play continues until neither someone reaches 700,
or neither player can use any cards in their hand.
If the trip is completed after the deck runs out, this is called
.IR "Delayed Action" .
.PP
.BR "Coup Fourr\o'\(aae'" :
This is a French fencing term for a counter-thrust move as part of a parry
to an opponents attack.
In Mille Bournes, it is used as follows:
If an opponent plays a Hazard card,
and you have the corresponding Safety in your hand,
you play it immediately, even
.I before
you draw.  This immediately removes the Hazard card from your Battle pile,
and protects you from that card for the rest of the game.  This
gives you more points (see \*(lqScoring\*(rq below).
.PP
.BR Scoring :
Scores are totaled at the end of each hand,
whether or not anyone completed the trip.
The terms used in the Score window have the following meanings:
.br
.RB "\ \ \ \ " "Milestones Played" :
Each player scores as many miles as they played before the trip ended.
.br
.RB "\ \ \ \ " "Each Safety" :
100 points for each safety in the Safety area.
.br
.RB "\ \ \ \ " "All 4 Safeties" :
300 points if all four safeties are played.
.br
.RB "\ \ \ \ " "Each Coup Four\o'\(aae'" :
300 points for each Coup Four\o'\(aae' accomplished.
.PP
The following bonus scores can apply only to the winning player.
.br
.RB "\ \ \ \ " "Trip Completed" :
400 points bonus for completing the trip to 700 or 1000.
.br
.RB "\ \ \ \ " "Safe Trip" :
300 points bonus for completing the trip without using any 200 mile cards.
.br
.RB "\ \ \ \ " "Delayed Action" :
300 points bonus for finishing after the deck was exhausted.
.br
.RB "\ \ \ \ " "Extension" :
200 points bonus for completing a 1000 mile trip.
.br
.RB "\ \ \ \ " "Shut-Out" :
500 points bonus for completing the trip
before your opponent played any mileage cards.
.PP
Running totals are also kept for the current score for each player
for the hand
.RB ( "Hand Total" ),
the game
.RB ( "Overall Total" ),
and number of games won
.RB ( Games ).
