.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)cribbage.6	6.4 (Berkeley) 7/9/88
.\"
.TH CRIBBAGE 6 "July 9, 1988"
.UC 4
.SH NAME
cribbage \- the card game cribbage
.SH SYNOPSIS
.B /usr/games/cribbage
[
.B \-req
]
.I name ...
.SH DESCRIPTION
.I Cribbage
plays the card game cribbage, with the program playing one hand
and the user the other.  The program will initially ask the user if
the rules of the game are needed \- if so, it will print out
the appropriate section from
.I According to Hoyle
with
.I more (I).
.PP
.I Cribbage
options include:
.TP
.B \-e
When the player makes a mistake scoring his hand or crib, provide an
explanation of the correct score.  (This is especially useful for
beginning players.)
.TP
.B \-q
Print a shorter form of all messages \- this is only recommended for
users who have played the game without specifying this option.
.TP
.B \-r
Instead of asking the player to cut the deck, the program will randomly
cut the deck.
.PP
.I Cribbage
first asks the player whether he wishes to play a short game
(\*(lqonce around\*(rq, to 61) or a long game (\*(lqtwice around\*(rq, to 121).  A
response of `s' will result in a short game, any other response will
play a long game.
.PP
At the start of the first game, the program
asks the player to cut the deck to determine who gets the
first crib.  The user should respond with a number between 0 and
51, indicating how many cards down the deck is to be cut.  The player
who cuts the lower ranked card gets the first crib.
If more than one game is played, the
loser of the previous game gets the first crib in the current game.
.PP
For each hand, the program first prints the player's hand,
whose crib it is, and then asks the player
to discard two cards into the crib.  The cards are prompted for
one per line, and are typed as explained below.
.PP
After discarding, the program cuts the deck (if it is the player's
crib) or asks the player to cut the deck (if it's its crib); in the latter
case, the appropriate response is a number from 0 to 39 indicating
how far down the remaining 40 cards are to be cut.
.PP
After cutting the deck, play starts with the non-dealer (the person
who doesn't have the crib) leading the first card.
Play continues, as per cribbage, until all cards are exhausted.  The
program keeps track of the scoring of all points and the total of
the cards on the table.
.PP
After play, the hands are scored.  The program requests the player to
score his hand (and the crib, if it is his) by printing out the
appropriate cards (and the cut card enclosed in brackets).
Play continues until one player reaches the game limit (61 or 121).
.PP
A carriage return when a numeric input is expected is equivalent
to typing the lowest legal value; when cutting the deck this
is equivalent to choosing the top card.
.PP
Cards are specified as rank followed by suit.  The ranks may be specified
as one of:
`a', `2', `3', `4', `5', `6', `7', `8', `9', `t', `j', `q', and `k',
or alternatively, one of: \*(lqace\*(rq, \*(lqtwo\*(rq, \*(lqthree\*(rq, \*(lqfour\*(rq, \*(lqfive\*(rq, \*(lqsix\*(rq,
\*(lqseven\*(rq, \*(lqeight\*(rq, \*(lqnine\*(rq, \*(lqten\*(rq, \*(lqjack\*(rq, \*(lqqueen\*(rq, and \*(lqking\*(rq.
Suits may be specified as: `s', `h', `d', and `c', or alternatively as:
\*(lqspades\*(rq, \*(lqhearts\*(rq, \*(lqdiamonds\*(rq, and \*(lqclubs\*(rq.
A card may be specified as: <rank> \*(lq \*(rq <suit>, or: <rank> \*(lq of \*(rq <suit>.
If the single letter rank and suit designations are used, the space
separating the suit and rank may be left out.  Also, if only one card
of the desired rank is playable, typing the rank is sufficient.
For example, if your hand was \*(lq2H, 4D, 5C, 6H, JC, KD\*(rq and it was
desired to discard the king of diamonds, any of the following could be typed:
\*(lqk\*(rq, \*(lqking\*(rq, \*(lqkd\*(rq, \*(lqk d\*(rq, \*(lqk of d\*(rq, \*(lqking d\*(rq, \*(lqking of d\*(rq, \*(lqk diamonds\*(rq,
\*(lqk of diamonds\*(rq, \*(lqking diamonds\*(rq, or \*(lqking of diamonds\*(rq.
.SH FILES
.ta 2i
/usr/games/cribbage
.SH AUTHORS
Earl T. Cohen wrote the logic.
Ken Arnold added the screen oriented interface.
