.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)canfield.6	6.2 (Berkeley) 5/6/86
.\"
.TH CANFIELD 6 "May 6, 1986"
.UC 5
.SH NAME
canfield, cfscores \- the solitaire card game canfield
.SH SYNOPSIS
.B /usr/games/canfield
.br
.B /usr/games/cfscores
.SH DESCRIPTION
.PP
If you have never played solitaire before, it is recommended
that you consult a solitaire instruction book. In
Canfield, tableau cards may be built on each other downward
in alternate colors. An entire pile must be moved as a unit
in building. Top cards of the piles are available 
to be played on foundations, but never into empty spaces.
.PP
Spaces must be filled from the stock. The top card of
the stock also is available to be played on foundations or
built on tableau piles. After the stock is exhausted,
tableau spaces may be filled from the talon and the player may
keep them open until he wishes to use them.
.PP
Cards are dealt from the hand to the talon by threes
and this repeats until there are no more cards in the hand
or the player quits. To have cards dealt onto the talon the
player types 'ht' for his move. Foundation base cards are
also automatically moved to the foundation when they become
available.
.PP
The command 'c' causes
.I canfield
to maintain card counting statistics
on the bottom of the screen. 
When properly used this can greatly increase one's chances of 
winning.
.PP
The rules for betting are somewhat less strict than
those used in the official version of the game.
The initial deal costs $13.
You may quit at this point or inspect the game.
Inspection costs $13 and allows you to make as many
moves as possible without moving any cards from your hand
to the talon.
(The initial deal places three cards on the talon;
if all these cards are used,
three more are made available.)
Finally, if the game seems interesting,
you must pay the final installment of $26.
At this point you are
credited at the rate of $5 for each card on the foundation;
as the game progresses you are credited with $5 for each
card that is moved to the foundation.
Each run through the hand after the first costs $5.
The card counting feature
costs $1 for each unknown card that is identified.
If the information is toggled on,
you are only charged for cards
that became visible since it was last turned on.
Thus the maximum cost of information is $34.
Playing time is charged at a rate of $1 per minute.
.PP
With no arguments, the program
.I cfscores
prints out the current status of your canfield account.
If a user name is specified,
it prints out the status of their canfield account.
If the
.B \-a
flag is specified,
it prints out the canfield accounts for all users that have
played the game since the database was set up.
.SH FILES
/usr/games/canfield	the game itself
.br
/usr/games/cfscores	the database printer
.br
/usr/games/lib/cfscores	the database of scores
.SH BUGS
It is impossible to cheat.
.SH AUTHORS
Originally written: Steve Levine
.br
Further random hacking by: Steve Feldman, Kirk McKusick, 
Mikey Olson, and Eric Allman.
