.\"	@(#)tbl.1	6.1 (Berkeley) 4/29/85
.\"
.TH TBL 1 "April 29, 1985"
.AT 3
.SH NAME
tbl \- format tables for nroff or troff
.SH SYNOPSIS
.B tbl
[ files ] ...
.SH DESCRIPTION
.I Tbl
is a preprocessor for formatting tables for
.I nroff
or
.IR troff (1).
The input files are copied to the standard output, except for lines between
.TS and .TE command lines, which are assumed to describe tables
and are reformatted.
Details are given in the 
.IR tbl (1)
reference manual.
.SH EXAMPLE
.PP
As an example, letting \\t represent a tab (which should be typed as a genuine
tab) the input
.IP ""
\&.TS
.nf
c s s
c c s
c c c
l n n.
Household Population
Town\\tHouseholds
\\tNumber\\tSize
Bedminster\\t789\\t3.26
Bernards Twp.\\t3087\\t3.74
Bernardsville\\t2018\\t3.30
Bound Brook\\t3425\\t3.04
Branchburg\\t1644\\t3.49
Bridgewater\\t7897\\t3.81
Far Hills\\t240\\t3.19
\&.TE
.LP
.fi
yields
.ne 10
.IP " "
.TS
.nr 35 \n(.u
.nf
.nr 79 0n
.nr 80 \n(79
.nr 40 \n(79
.nr 38 \n(79+\w!Town!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Bedminster!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Bernards Twp.!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Bernardsville!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Bound Brook!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Branchburg!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Bridgewater!
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \n(79+\w!Far Hills!
.if \n(80<\n(38 .nr 80 \n(38
.nr 81 \n(80
.nr 41 \n(80
.nr 38 \n(80+\w!Number!
.if \n(81<\n(38 .nr 81 \n(38
.nr 31 0
.nr 32 0
.nr 38 \w!789!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3087!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!2018!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3425!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!1644!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!7897!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!240!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!!
.if \n(32<\n(38 .nr 32 \n(38
.nr 61 \n(80+\n(31
.nr 38 \n(61+\n(32
.if \n(38>\n(81 .nr 81 \n(38
.if \n(38<\n(81 .nr 61 +(\n(81-\n(38)/2
.nr 82 \n(81
.nr 42 \n(81
.nr 38 \n(81+\w!Size!
.if \n(82<\n(38 .nr 82 \n(38
.nr 31 0
.nr 32 0
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.26!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.74!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.30!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.04!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.49!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.81!
.if \n(32<\n(38 .nr 32 \n(38
.nr 38 \w!3!
.if \n(31<\n(38 .nr 31 \n(38
.nr 38 \w!.19!
.if \n(32<\n(38 .nr 32 \n(38
.nr 62 \n(81+\n(31
.nr 38 \n(62+\n(32
.if \n(38>\n(82 .nr 82 \n(38
.if \n(38<\n(82 .nr 62 +(\n(82-\n(38)/2
.nr 38 \n(79+\w!Household Population!-\n(82
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 61 +1*\n(38
.nr 81 +1*\n(38
.nr 41 +1*\n(38
.nr 62 +2*\n(38
.nr 82 +2*\n(38
.nr 42 +2*\n(38
.nr 38 \n(80+\w!Households!-\n(82
.if \n(38>0 .nr 38 \n(38/1
.if \n(38<0 .nr 38 0
.nr 62 +1*\n(38
.nr 82 +1*\n(38
.nr 42 +1*\n(38
.nr 38 1n
.nr 41 +3*\n(38
.nr 81 +3*\n(38
.nr 61 +3*\n(38
.if n .if \n(61%24>0 .nr 61 +12u
.nr 42 +6*\n(38
.nr 82 +6*\n(38
.nr 62 +6*\n(38
.if n .if \n(62%24>0 .nr 62 +12u
.nr TW \n(82
.fc ! :
.ta \n(82u 
\&!:Household Population:!
.ta \n(80u \n(82u 
\&\h'|\n(40u'!:Town:!\h'|\n(41u'!:Households:!
.ta \n(80u \n(81u \n(82u 
\&\h'|\n(40u'!::!\h'|\n(41u'!:Number:!\h'|\n(42u'!:Size:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Bedminster:!\h'|\n(41u'!:789!\h'|\n(42u'!:3!!.26:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Bernards Twp.:!\h'|\n(41u'!:3087!\h'|\n(42u'!:3!!.74:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Bernardsville:!\h'|\n(41u'!:2018!\h'|\n(42u'!:3!!.30:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Bound Brook:!\h'|\n(41u'!:3425!\h'|\n(42u'!:3!!.04:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Branchburg:!\h'|\n(41u'!:1644!\h'|\n(42u'!:3!!.49:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Bridgewater:!\h'|\n(41u'!:7897!\h'|\n(42u'!:3!!.81:!
.ta \n(80u \n(61u \n(62u \n(82u 
\&\h'|\n(40u'!Far Hills:!\h'|\n(41u'!:240!\h'|\n(42u'!:3!!.19:!
.fc
.mk ##
.nr ## -1v
.if \n(35>0 .fi
.TE
.fi
.PP
If no arguments are given,
.I tbl
reads the standard input, so it may be used as a filter.  When 
.I tbl
is used with
.I eqn
or
.I neqn
the
.I tbl
command should be first, to minimize the volume of data passed through pipes.
.SH SEE ALSO
troff(1), eqn(1)
.br
M. E. Lesk,
.I TBL.
