.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)roffbib.1	6.2 (Berkeley) 5/7/86
.\"
.TH ROFFBIB 1 "May 7, 1986"
.UC 5
.SH NAME
roffbib \- run off bibliographic database
.SH SYNOPSIS
.B roffbib
[
.B \-e
] [
.B \-h
] [
.B \-n
] [
.B \-o
] [
.B \-r
] [
.B \-s
] [
.BI \-T term
] [
.B \-x
] [
.B \-m
.I mac
] [
.B \-V
] [
.B \-Q
] [ file ... ]
.SH DESCRIPTION
.I Roffbib
prints out all records in a bibliographic database,
in bibliography format rather than as footnotes or endnotes.
Generally it is used in conjunction with
.IR sortbib :
.LP
.RS
sortbib  database | roffbib
.RE
.LP
.I Roffbib
accepts most of the options understood by
.IR nroff (1),
most importantly the
.B \-T
flag to specify terminal type.
.PP
If abstracts or comments are entered following the %X field key,
.I roffbib
will format them into paragraphs for an annotated bibliography.
Several %X fields may be given if several
annotation paragraphs are desired.
The
.B \-x
flag will suppress the printing of these abstracts.
.PP
A user-defined set of macros
may be specified after the
.B \-m
option.
There should be a space between the
.B \-m
and the macro filename.
This set of macros will replace the ones
defined in /usr/lib/tmac/tmac.bib.
The
.B \-V
flag will send output to the Versatec; the
.B \-Q
flag will queue output for the phototypesetter.
.PP
Four command-line registers control formatting style
of the bibliography, much like the number registers of
.IR ms (7).
The command-line argument
.BR \-r N1
will number
the references starting at one (1).
The flag
.BR \-r V2
will double space the biblio\%graphy,
while
.BR \-r V1
will double space references
but single space annotation paragraphs.
The line length can be changed from the default 6.5 inches
to 6 inches with the
.BR \-r L6i
argument,
and the page offset can be set from the default of 0
to one inch by specifying
.BR \-r O1i
(capital O, not zero).
Note: with the
.B \-V
and
.B \-Q
flags
the default page offset is already one inch.
.SH FILES
.ta \w'/usr/lib/tmac/tmac.bib\0\0'u
.nf
/usr/lib/tmac/tmac.bib	file of macros used by \fInroff/troff\fP
.fi
.SH SEE ALSO
refer(1), addbib(1), sortbib(1), indxbib(1), lookbib(1)
.SH BUGS
Users have to rewrite macros
to create customized formats.
