.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)addbib.1	6.1 (Berkeley) 4/29/85
.\"
.TH ADDBIB 1 "April 29, 1985"
.UC 5
.SH NAME
addbib \- create or extend bibliographic database
.SH SYNOPSIS
\fBaddbib\fP  [ \fB\-p\fP  promptfile ]  [ \fB\-a\fP ]  database
.SH DESCRIPTION
When this program starts up, answering ``y''
to the initial ``Instructions?'' prompt yields directions;
typing ``n'' or \s-2RETURN\s0 skips them.
.I Addbib
then prompts for various bibliographic fields,
reads responses from the terminal,
and sends output records to a
.I database.
A null response (just \s-2RETURN\s0) means to leave out that field.
A minus sign (\-) means to go back to the previous field.
A trailing backslash allows a field to be continued on the next line.
The repeating ``Continue?'' prompt allows the user
either to resume by typing ``y'' or \s-2RETURN\s0,
to quit the current session by typing ``n'' or ``q'',
or to edit the
.I database
with any system editor \fI(vi, ex, edit, ed).\fP
.PP
The
.B \-a
option suppresses prompting for an abstract;
asking for an abstract is the default.
Abstracts are ended with a \s-2CTRL\s0-d.
The
.B \-p
option causes
.I addbib
to use a new prompting skeleton, defined in
.I promptfile.
This file should contain prompt strings, a tab,
and the key-letters to be written to the
.I database.
.PP
The most common key-letters and their meanings are given below.
.I Addbib
insulates you from these key-letters,
since it gives you prompts in English,
but if you edit the bibliography file later on,
you will need to know this information.
.sp
.nf
	%A	Author's name
	%B	Book containing article referenced
	%C	City (place of publication)
	%D	Date of publication
	%E	Editor of book containing article referenced
	%F	Footnote number or label (supplied by \fIrefer\fP\|)
	%G	Government order number
	%H	Header commentary, printed before reference
	%I	Issuer (publisher)
	%J	Journal containing article
	%K	Keywords to use in locating reference
	%L	Label field used by \fB\-k\fP option of \fIrefer\fP
	%M	Bell Labs Memorandum (undefined)
	%N	Number within volume
	%O	Other commentary, printed at end of reference
	%P	Page number(s)
	%Q	Corporate or Foreign Author (unreversed)
	%R	Report, paper, or thesis (unpublished)
	%S	Series title
	%T	Title of article or book
	%V	Volume number
	%X	Abstract \(em used by \fIroffbib\fP, not by \fIrefer\fP
	%Y,Z	ignored by \fIrefer\fP
.fi
.sp
Except for `A', each field should be given just once.
Only relevant fields should be supplied.
An example is:
.sp
.nf
	%A	Bill Tuthill
	%T	Refer \(em A Bibliography System
	%I	Computing Services
	%C	Berkeley
	%D	1982
	%O	\s-1UNX\s0 4.3.5.
.fi
.sp
.SH FILES
.DT
promptfile	optional file to define prompting
.SH SEE ALSO
refer(1), sortbib(1), roffbib(1), indxbib(1), lookbib(1)
.SH AUTHORS
Al Stangenberger, Bill Tuthill
