.\"	@(#)ranlib.1	6.2 (Berkeley) 5/3/85
.\"
.TH RANLIB 1 "May 3, 1985"
.AT 3
.SH NAME
ranlib \- convert archives to random libraries
.SH SYNOPSIS
.B ranlib
[
.B \-t
] archive ...
.SH DESCRIPTION
.I Ranlib
converts each
.I archive
to a form which the loader can load more rapidly.
.I Ranlib
does this by adding a table of contents called 
.B __.SYMDEF
to the beginning of the archive.
.I Ranlib
uses 
.IR ar (1)
to reconstruct the archive, so that sufficient temporary file space must
be available in the file system which contains the current directory.
.PP
If given the
.B \-t
option,
ranlib only "touches" the archives and does not modify them.
This is useful after copying an archive
or using the
.B \-t
option of
.IR make (1)
in order to avoid having
.IR ld (1)
complain about
an \*(lqout of date\*(rq symbol table.
.SH "SEE ALSO"
ld(1), ar(1), lorder(1), make(1)
.SH BUGS
Because generation of a library by
.I ar
and randomization of the library by
.I ranlib
are separate processes, phase errors are possible.  The loader,
.IR ld ,
warns when the modification date of a library is more recent than the
creation date of its dictionary;  but this means that you get the
warning even if you only copy the library.
