.\" Copyright (c) 1987 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)mkdep.1	5.6 (Berkeley) 7/9/88
.\"
.TH MKDEP 1 "July 9, 1988"
.UC 5
.SH NAME
mkdep \- construct Makefile dependency list
.SH SYNOPSIS
.B mkdep
[
.B \-f makefile
] [
.B \-p
] [ flags ] file ...
.SH DESCRIPTION
\fIMkdep\fP takes a set of flags for the C compiler and a list of C
source files as arguments and constructs a set of include file dependencies.
It attaches this dependency list to the end of the file ``Makefile''.
An example of its use in a makefile might be:
.nf
.RS

CFLAGS= -O -I../include -I.
SRCS= file1.c file2.c

depend:
	mkdep ${CFLAGS} ${SRCS}
.RE
.PP
where the macro SRCS is the list of C source files and the macro
CFLAGS is the list of flags for the C compiler.  The \fB-f\fP option
provides \fImkdep\fP with a name other than ``Makefile'' to be edited.
If the \fB-p\fP option is provided, \fImkdep\fP produces dependencies
of the form ``program: program.c'' so that subsequent makes will
produce \fIprogram\fP directly from its C module rather than using an
intermediate \fI.o\fP module.  This is useful in directories that
contain many programs, each of whose source is contained in a single
C module.
.SH "SEE ALSO"
cc(1), make(1)
