.\"	@(#)dc.1	6.1 (Berkeley) 4/29/85
.\"
.TH DC 1 "April 29, 1985"
.AT 3
.SH NAME
dc \- desk calculator
.SH SYNOPSIS
.B dc
[ file ]
.SH DESCRIPTION
.I Dc
is an arbitrary precision arithmetic package.
Ordinarily it operates on decimal integers,
but one may specify an input base, output base,
and a number of fractional digits to be maintained.
The overall structure of
.I dc
is
a stacking (reverse Polish) calculator.
If an argument is given,
input is taken from that file until its end,
then from the standard input.
The following constructions are recognized:
.HP 6
number
.br
The value of the number is pushed on the stack.
A number is an unbroken string of the digits 0-9.
It may be preceded by an underscore _ to input a
negative number.
Numbers may contain decimal points.
.HP 6
+  \- /  *  %  ^
.br
The
top two values on the stack are added
(+),
subtracted
(\-),
multiplied (*),
divided (/),
remaindered (%),
or exponentiated (^).
The two entries are popped off the stack;
the result is pushed on the stack in their place.
Any fractional part of an exponent is ignored.
.TP
.BI s x
The
top of the stack is popped and stored into
a register named
.I x,
where
.I x
may be any character.
If
the
.B s
is capitalized,
.I x
is treated as a stack and the value is pushed on it.
.TP
.BI l x
The
value in register
.I x
is pushed on the stack.
The register
.I x
is not altered.
All registers start with zero value.
If the
.B l
is capitalized,
register
.I x
is treated as a stack and its top value is popped onto the main stack.
.TP
.B  d
The
top value on the stack is duplicated.
.TP
.B  p
The top value on the stack is printed.
The top value remains unchanged.
.B P
interprets the top of the stack as an ascii string,
removes it, and prints it.
.TP
.B  f
All values on the stack and in registers are printed.
.TP
.B  q
exits the program.
If executing a string, the recursion level is
popped by two.
If
.B q
is capitalized,
the top value on the stack is popped and the string execution level is popped
by that value.
.TP
.B  x
treats the top element of the stack as a character string
and executes it as a string of dc commands.
.TP
.B  X
replaces the number on the top of the stack with its scale factor.
.TP
.B  "[ ... ]"
puts the bracketed ascii string onto the top of the stack.
.HP 6
.I  "<x  >x  =x"
.br
The
top two elements of the stack are popped and compared.
Register
.I x
is executed if they obey the stated
relation.
.TP
.B  v
replaces the top element on the stack by its square root.
Any existing fractional part of the argument is taken
into account, but otherwise the scale factor is ignored.
.TP
.B  !
interprets the rest of the line as a UNIX command.
.TP
.B  c
All values on the stack are popped.
.TP
.B  i
The top value on the stack is popped and used as the
number radix for further input.
.B I
pushes the input base on the top of the stack.
.TP
.B  o
The top value on the stack is popped and used as the
number radix for further output.
.TP
.SM
.B O
pushes the output base on the top of the stack.
.TP
.B  k
the top of the stack is popped, and that value is used as
a non-negative scale factor:
the appropriate number of places
are printed on output,
and maintained during multiplication, division, and exponentiation.
The interaction of scale factor,
input base, and output base will be reasonable if all are changed
together.
.TP
.B  z
The stack level is pushed onto the stack.
.TP
.SM
.B  Z
replaces the number on the top of the stack with its length.
.TP
.B  ?
A line of input is taken from the input source (usually the terminal)
and executed.
.TP
.B "; :"
are used by 
.I bc
for array operations.
.PP
An example which prints the first ten values of n! is
.nf
.PP
.in +3
[la1+dsa*pla10>y]sy
.br
0sa1
.br
lyx
.fi
.SH "SEE ALSO"
bc(1),
which is a preprocessor for
.I dc
providing infix notation and a C-like syntax
which implements functions and reasonable control
structures for programs.
.SH DIAGNOSTICS
`x is unimplemented' where x is an octal number.
.br
`stack empty' for not enough elements on the stack to do what was asked.
.br
`Out of space' when the free list is exhausted (too many digits).
.br
`Out of headers' for too many numbers being kept around.
.br
`Out of pushdown' for too many items on the stack.
.br
`Nesting Depth' for too many levels of nested execution.
