.\"	@(#)col.1	6.2 (Berkeley) 5/16/86
.\"
.TH COL 1 "May 16, 1986"
.AT 3
.SH NAME
col \- filter reverse line feeds
.SH SYNOPSIS
.B col
[
.B \-bfh
]
.SH DESCRIPTION
.I Col
reads the standard input and writes the standard output.
It performs the line overlays implied by reverse line
feeds (ESC-7 in ASCII)
and by forward and reverse half line feeds (ESC-9 and ESC-8).
.I Col
is particularly useful for filtering multicolumn
output made with the `.rt' command of
.I nroff
and output resulting from use of the
.IR tbl (1)
preprocessor.
.PP
Although
.I col
accepts half line motions in its input, it normally does not
emit them on output.
Instead, text that would appear between lines is moved to the next lower
full line boundary.
This treatment can be suppressed by the
.B \-f
(fine) option; in this case
the output from
.I col
may contain forward half line feeds (ESC-9), but will still never contain
either kind of reverse line motion.
.PP
If the
.B \-b
option is given,
.I col
assumes that the output device in use is not capable of backspacing.
In this case, if several characters are to appear in the same place,
only the last one read will be taken.
.PP
The control characters SO (ASCII code 017),
and SI (016) are assumed
to start and end text in an alternate character set.
The character set (primary or alternate) associated with each printing
character read is remembered; on output, SO and SI characters are generated
where necessary to maintain the correct treatment of each character.
.PP
If the
.B \-h
option is given,
.I col
converts white space to tabs to shorten printing time.
.PP
All control characters are removed from the input except space,
backspace,
tab, return, newline, ESC (033) followed by one of 7, 8, 9, SI, SO, and VT
(013).
This last character is an alternate form of full reverse line feed, for
compatibility with some other hardware conventions.
All other non-printing characters are ignored.
.SH "SEE ALSO"
troff(1), tbl(1)
.SH BUGS
Can't back up more than 128 lines.
.br
No more than 800 characters, including backspaces, on a line.
