.mc |
.\"  (c) Copyright 1989, 1990 OPEN SOFTWARE FOUNDATION, INC.
.mc
.\"  (c) Copyright 1989, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
.\"  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY
.\"  (c) Copyright 1988 MASSACHUSETTS INSTITUTE OF TECHNOLOGY 
.\"  (c) Copyright 1988 MICROSOFT CORPORATION
.\"  ALL RIGHTS RESERVED
.mc |
.nr H1 19
.mc
.H 1 "Using the UIL Compiler "
.P 0
This chapter discusses the following:
.BL
.LI
Invoking the compiler
.LI
.mc |
Default character sets for string literals
.mc
.LI
Interpreting diagnostics issued by the compiler
.LI
Reading the listing produced by the compiler
.LE
.H 2 "Invoking the Compiler"
.mc |
This section describes how to invoke the UIL compiler
from the command line using the
.B uil
command, or from within an application using the
.B Uil
function.
.H 3 "Invoking the Compiler by Command"
.iX "UIL" "compiler"
You invoke the UIL compiler with the \fBuil\fR command.  
The \fBuil\fR command has the following syntax:
.P
.nf
\fBuil\fR [ \fIoption\fP... ] \fIinput-file\fP
.fi
.ft R
.P
.mc
The input file contains the UIL specification to be compiled.
You can use the options to control the output of the UIL compiler.
.P 0
.mc |
The supported options are listed in the following table. 
.iX "UIL" "command qualifiers"
.ne 2i
.P
.mc
.TB "UIL Command Line Options"
.TS H
tab(@);
lBw(1i) lBw(1i) lBw(2.75i)
lw(1i) lw(1i) lw(2.75i).
.mc
_
.sp 6p
.mc |
Option@Default@Description
.mc
.sp 6p
_
.sp 6p
.mc *
.mc
.TH
.mc |
 \-ofilename@a.uid@T{
.mc
Directs the compiler to produce a User Interface Definition (UID) file.  By
.mc |
default, UIL creates a UID file with the name a.uid.  
.mc
.sp 3p
No UID file is produced if the compiler issues any diagnostics categorized 
as error or severe.
T}
.sp 3p
.mc |
 \-vfilename@T{
.mc
No listing is generated
T}@T{
.mc |
Directs the compiler to produce a listing file.  If the \-v option
.mc
is not present, no listing is generated by the compiler.
T}
.sp 3p
.mc |
 \-m@T{
No machine code is listed
.mc
T}@T{
Directs the compiler to place in the listing file a description of the 
records that it added to the UID file.  This helps you isolate
errors.
T}
.sp 3p
.mc |
 \-w@T{
.mc
Warning messages are generated
T}@T{
Directs the compiler to suppress all warning and informational messages.
Error messages and severe messages are generated.
T}
.sp 3p
.mc |
.ne 2.5i
\-Ipathname@/usr/include@T{
If you specify the \-I option followed by a pathname, with no
.mc
intervening spaces, the compiler uses the specified pathname to locate
.mc |
include files when the include directive is used.  A trailing / (slash)
.mc
on the specified pathname is optional; if it is omitted, the compiler
inserts it for you.  
.sp 3p
For example: 
.sp
-I/usr/include/myuilpath
.sp
.mc |
Causes the compiler to look for include files in the 
directory /usr/include/myuilpath
.mc
if the include file has not been found in the paths that have already
been searched.
.mc *
.mc
T}
.sp 6p
_
.TE
.mc |
.H 3 "Invoking the Compiler by Function"
This section describes the \fBUil\fP callable interface routine.
This routine
allows you to invoke the UIL compiler from 
within an application, and returns a
data structure, describing the UIL module that was compiled.
This section
also describes the \fBUilDumpSymbolTable\fP routine, used to 
perform a symbol table dump.
.P
The \fBUil\fR function 
invokes the UIL compiler from within an application.
It has the following syntax:
.P
.nf
\fB#include <uil/UilDef.h>\fR
\fBUil_status_type Uil\fR(\fIcommand_desc\fP, \fIcompile_desc\fP, 
   \fImessage_cb\fP, \fImessage_data\fP, \fIstatus_cb\fP, \fIstatus_data\fP)
   \fBUil_command_type\fR *\fIcommand_desc\fP;
   \fBUil_compile_desc_type\fR *\fIcompile_desc\fP;
   \fBUil_continue_type\fR (*\fImessage_cb\fP) ();
   \fBchar\fR *\fImessage_data\fP;
   \fBUil_continue_type\fR (*\fIstatus_cb\fP) (); 
   \fBchar\fR *\fIstatus_data\fP;
.fi
.ft R
.P
The \fBUil\fR function provides a callable entry point for the UIL
compiler. The
callable interface can be used to process 
a UIL source file and to
generate UID files, as well as return a detailed description of the
UIL source module in the form of a symbol table (parse tree).
.VL 1.5i
.LI "\fIcommand_desc\fP"
Specifies the UIL command line.
.LI "\fIcompile_desc\fP"
Returns the results of the compilation.
.LI "\fImessage_cb\fP"
Specifies a callback function that is called when the compiler 
encounters errors in the UIL source.
.LI "\fImessage_data\fP"
Specifies user data that is passed to the message callback function
(\fImessage_cb\fR). Note that this argument is not interpreted by UIL, and is
used exclusively by the calling application.
.LI "\fIstatus_cb\fP"
Specifies a callback function that is called to allow X applications to service
X events such as updating the screen.  This function is called
at various check points, which have been hardcoded into the UIL compiler.
The status_update_delay argument in \fIcommand_desc\fR specifies the number of
check points to be passed before the \fIstatus_cb\fR function is invoked.
.LI "\fIstatus_data\fP"
Specifies user data that is passed to the status callback function
(\fIstatus_cb\fR). Note that this argument is not interpreted by the UIL compiler,
and is used exclusively by the calling application.
.LE
.P
The data structures \fBUil_command_type\fR and \fBUil_compile_desc_type\fR are detailed
in the text that follows this example.
.P
.ft CW
.in0
.S -2
.nf
typedef struct Uil_command_type {
.in +5n
char *source_file; /* single source to compile */
char *resource_file; /* name of output file */
char *listing_file; /* name of listing file */
unsigned int *include_dir_count; /* number of directories in
.in +25n
/* include_dir array */
.in -25n
char *((*include_dir) []); /* directory to search for
.in +25n
/* include files */
.in -25n
unsigned listing_file_flag: 1; /* produce a listing */
unsigned resource_file_flag: 1; /* generate UID output */
unsigned machine_code_flag: 1; /* generate machine code */
unsigned report_info_msg_flag: 1; /* report info messages */
unsigned report_warn_msg_flag: 1; /* report warnings */
unsigned parse_tree_flag: 1; /* generate parse tree */
unsigned int status_update_delay; /* number of times a status */
.in +25n
/* point is passed before */
/* calling status_cb function */
/* 0 means called every time */
.in -25n
}
.in -5n
.sp
typedef struct Uil_compile_desc_type {
.in +5n
unsigned int compiler_version; /* version number of compiler */
unsigned int data_version; /* version number of structures */
char *parse_tree_root; /* parse tree output */
unsigned int message_count [Uil_k_max_status+1]; /* array of 
}                                               severity counts /*
.in -5n
.S
.fi
.ft R
.P
Following is a description of the message callback function specified by
\fImessage_cb\fP:
.P
.ne 2i
.ft B
Uil_continue_type (\fI*message_cb\fP) (\fImessage_data, message_number,
severity, msg_buffer, src_buffer, ptr_buffer, loc_buffer,
message_count\fP)
.br
.ta 0.5i 1.5i
	char	\fI*message_data\fP;
.br
	int	\fImessage_number\fP;
.br
	int	\fIseverity\fP;
.br
	char	\fI*msg_buffer\fP, \fI*src_buffer\fP;
.br
	char	\fI*ptr_buffer\fP, \fI*loc_buffer\fP;
.br
	int	\fImessage_count\fP[];
.fi
.ft R
.P
Specifies a callback function that UIL invokes instead of printing an
error message when the compiler encounters an error in the UIL source.
The callback should return one of these values:
.VL 1.5i
.LI \fBUil_k_terminate\fP
Tells UIL to terminate processing of the source file
.LI \fBUil_k_continue\fP
Tells UIL to continue processing the source file
.LE
.P
Following are the arguments:
.VL 1.5i
.LI \fImessage_data\fP
Data supplied by the application as the \fImessage_data\fP argument to
the \fBUil\fP function.
UIL does not interpret this data in any way; it just passes it to the
callback.
.LI \fImessage_number\fP
An index into a table of error messages and severities, for internal use
by UIL.
.LI \fIseverity\fP
An integer that indicates the severity of the error.
The possible values are the status constants returned by the \fBUil\fP
function.
.LI \fImsg_buffer\fP
A string that describes the error.
.LI \fIsrc_buffer\fP
A string consisting of the source line where the error occurred.
This is not always available; the argument is then NULL.
.LI \fIptr_buffer\fP
A string consisting of white space and a printing character in the
character position corresponding to the column of the source line where
the error occurred.
This string may be printed beneath the source line to provide a visual
indication of the column where the error occurred.
This is not always available; the argument is then NULL.
.LI \fIloc_buffer\fP
A string identifying the line number and file of the source line where
the error occurred.
This is not always available; the argument is then NULL.
.LI \fImessage_count\fP
An array of integers containing the number of diagnostic messages issued
thus far for each severity level.
To find the number of messages issued for the current severity level,
use the \fIseverity\fP argument as the index into this array.
.LE
.P
Following is a description of the status callback function specified by
\fIstatus_cb\fP:
.P
.ne 2i
.ft B
Uil_continue_type (\fI*status_cb\fP) (\fIstatus_data, percent_complete,
lines_processed, current_file, message_count\fP)
.br
.ta 0.5i 1.5i
	char	\fI*status_data\fP;
.br
	int	\fIpercent_complete\fP;
.br
	int	\fIlines_processed\fP;
.br
	char	\fI*current_file\fP;
.br
	int	\fImessage_count\fP[];
.ft R
.P
Specifies a callback function that is invoked to allow X applications to
service X events such as updating the screen.
The callback should return one of these values:
.VL 1.5i
.LI \fBUil_k_terminate\fP
Tells UIL to terminate processing of the source file
.LI \fBUil_k_continue\fP
Tells UIL to continue processing the source file
.LE
.P
Following are the arguments:
.VL 1.5i
.LI \fIstatus_data\fP
Data supplied by the application as the \fIstatus_data\fP argument to
the \fBUil\fP function.
UIL does not interpret this data in any way; it just passes it to the
callback.
.LI \fIpercent_complete\fP
An integer indicating what percentage of the current source file has
been processed so far.
.LI \fIlines_processed\fP
An integer indicating how many lines of the current source file have
been read so far.
.LI \fIcurrent_file\fP
A string containing the pathname of the current source file.
.LI \fImessage_count\fP
An array of integers containing the number of diagnostic messages issued
thus far for each severity level.
To find the number of messages issued for a given severity level, use
the severity level as the index into this array.
The possible severity levels are the status constants returned by the
\fBUil\fP function.
.LE
.P
.ne 3i
This function returns one of the following 
status return values:
.VL 25n
.LI "\fBUil_k_success_status\fP"
The operation succeeded.
.LI "\fBUil_k_info_status\fP"
The operation succeeded, and an informational
message is returned.
.LI "\fBUil_k_warning_status\fP"
The operation succeeded, and a warning
message is returned.
.LI "\fBUil_k_error_status\fP"
The operation failed due to an error.
.LI "\fBUil_k_severe_status\fP"
The operation failed due to an error.
.LE
.P
The \fBUilDumpSymbolTable\fP function dumps the contents of a named UIL
symbol table.  It has the following syntax:
.P
.nf
\fB#include <uil/UilDef.h>\fR
\fBvoid UilDumpSymbolTable UIL\fR(\fIroot_ptr\fP)
.in +5n
sym_root_entry_type *\fIroot_ptr\fP;
.in -5n
.ft R
.fi
.P
The \fBUilDumpSymbolTable\fR function dumps the contents of a 
UIL symbol table pointer that was returned
from the UIL callable interface. 
.VL 15n
.LI "\fIroot_ptr\fP"
Returns a pointer to the the symbol table root entry.  
.LE
.P
By following the link from the root entry, 
you can traverse the entire parse tree. 
Symbol table entries are in the following format:
.P
.nf
\fIhex.address symbol.type symbol.data
  prev.source.position
  source.position
  modification.record
.ft R
.fi
.P
where:
.VL 25n
.LI \fIhex.address\fP
Specifies the hexadecimal address of this entry in the symbol table.
.LI \fIsymbol.type\fP
Specifies the type of this symbol table entry.  Some possible types
are \fBroot\fP, \fBmodule\fP, \fBvalue\fP, \fBprocedure\fP, and \fBwidget\fP.
.LI \fIsymbol.data\fP
Specifies data for the symbol table entry.  The data varies with the
type of the entry.  Often it contains pointers to other symbol table entries,
or the actual data for the data type.
.LI \fIprev.source.position\fP
Specifies the endpoint in the source code for the previous source item.
.LI \fIsource.position\fP
Specifies the range of positions in the source code for this symbol.
.LE
.br
.ne 5
.P
The exact data structures for each symbol type are defined in the 
include file <\fBuil/UilSymDef.h\fR>.
Note that this file is automatically included when
an application includes the file <\fBuil/UilDef.h\fR>.
.H 2 "Default Character Set for String Literals"
.iX "UIL" "default character set"
.P
Every string literal has a character set associated with it.
The character set is determined when the UIL file is compiled.
.P
For a string declared as '\fIstring\fP,' the character set is the
codeset component of the value of the \fBLANG\fR environment variable at
compile time if \fBLANG\fR is set.
If \fBLANG\fR is not set or if it has no codeset component, the character set
is the value of \fBXmFALLBACK_CHARSET\fP at compile time.
The default value of \fBXmFALLBACK_CHARSET\fP is ISO8859-1 (equivalent
to ISO-LATIN1), but a vendor may set a different default.
.P
For a string declared as "\fIstring\fP," the character set is the
default character set of the module if specified (see Section 19.1.3).
If no character set is specified for the module, the character set is
determined as for a string declared as '\fIstring\fP.'
.br
.ne 2i
.mc
.H 2 "Interpreting Diagnostics Issued by the Compiler"
.P 0
.mc |
.iX "UIL" "compiler listing"
.iX "UIL" "compiler machine listing"
.iX "UIL" "compiler warnings"
.iX "UIL" "compiler include files"
.iX "UIL" "compiler diagnostics"
.mc
The compiler issues diagnostics to the standard error file.  The following
example shows the form of these messages:
.mc |
.P
.nf
.ft CW
.S -2
.mc
        value d: font( 1 );
                       *
Error: found integer value when expecting string value
                 line: 10  file: value_error.uil
.mc |
.S
.fi
.ft R
.mc
.P 0
The first line is the source line that produced the diagnostic.  
.mc |
If the compiler cannot retrieve the source line from the input
.mc
file, this line is omitted.  
Any control characters in the text of the line are printed 
.mc |
as ? (question marks).
.mc
.P 0
The second line of the diagnostic marks the start of the construct
that resulted in the diagnostic.  In this case the literal 1 is marked.
If the error is not associated with a particular construct, the second line is
omitted.  If the source line cannot be retrieved, this line is also
.mc |
omitted, and the column information is included with the line and file
.mc
information following the diagnostic message.
.P 0
The third line is the diagnostic being issued.
.P 0
The fourth line specifies the file containing the source line being diagnosed
and the line number of the source line within that file.
.P 0
.mc |
The following table
.mc
lists the four levels of diagnostics that are
issued by the compiler, in ascending order of severity.
.mc |
.P
.br
.ne 2i
.mc
.TB "Levels of Diagnostic Messages"
.TS H
tab(@);
lB lBw(3i)
l lw(3i).
.mc *
.mc
_
.sp 6p
Severity@Compilation Status
.sp 6p
_
.sp 6p
.mc *
.mc
.TH
Informational@T{
Accompanies other diagnostics that should be
.mc |
investigated.
.mc
T}
.sp 3p
Warning@T{
Compilation continues: check that the compiler did what
.mc |
you expected.
.mc
T}
.sp 3p
Error@T{
.mc |
Compilation continues: no UID file will be generated.
.mc
T}
.sp 3p
.mc |
Severe@Compilation terminates immediately.
.mc
.sp 6p
_
.TE
.mc |
.sp -1
.mc
.H 2 "Reading the Compiler Listing"
.mc |
.sp .25
.iX "UIL" "compiler listing"
.mc
The listing produced by the compiler contains:
.BL
.LI
A title giving miscellaneous information about the compilation
.LI
Source lines of the input file
.LI
Source lines of any include files
.LI
Diagnostics issued by the compiler
.LI
A summary of the diagnostics issued
.LI
A summary of the files read
.LE
.mc |
.P
.ne 2i
The following example shows the contents of a sample listing file:
.mc
.P 0
.mc |
.nf
.ft CW
.S -2
.in 0
.mc
MOTIF UIL Compiler V1.0-000    Wed Dec 16 11:13:31 1989  Page 1
Module: EXAMPLE          Version: X-1
  1 (0)      MODULE example VERSION = 'X-1'
  2 (0)	
  3 (0)          INCLUDE FILE 'colors.uil';
  1 (1)	
  2 (1)        VALUE red: COLOR( 1 );  VALUE green: COLOR( 2 );  
                                 1                         2
Error:  (1) found integer value when expecting string value
Error:  (2) found integer value when expecting string value
  3 (1)        VALUE blue: COLOR( 'XcolorBlue' ;
  4 (1)	
  4 (0)	
  5 (0)          OBJECT primary_window: 
  6 (0)             XmMainWindow
  7 (0)                 { ARGUMENTS
  8 (0)                        { XmNforeground = pink;
                                                    1
Error:  (1) value PINK must be defined before this reference
Error:  (1) found error value when expecting color value
  9 (0)                          XmNbackground = blue; }};
                                                           1
Error:  (1) unexpected RIGHT_BRACE token seen - parsing resumes 
            after ";"
 10 (0)                 };
 11 (0)      END MODULE;
Info:  (0) errors: 5  warnings: 0  informationals: 0
   File (0)   a.uil
   File (1)   colors.uil
.mc |
.fi
.ft R
.S
.in
.mc
.H 3 "Title"
.P 0
.mc |
Each new page of the listing starts with a title:
.mc
.P 0
.mc |
.nf
.ft CW
.S -2
.in0
.mc
MOTIF UIL Compiler V1.0-000    Wed Dec 16 11:13:31 1989  Page 1
Module: EXAMPLE          Version: X-1
.mc |
.fi
.ft R
.S
.in
.mc
.P 0
The first line of the
title identifies the compiler by name, the version of the compiler used
for the compilation, and the time the compilation started.  
.mc |
In this case, the version of the compiler used was \fBV1.0-000\fR.
.mc
.P 0
The second line of the title lists the module name for the UIL specification
and the version of that module if provided in the source.
.mc |
.br
.ne 2i
.mc
.H 3 "Source Line"
.P 0
.mc |
The printing of each source line is preceded by two numbers:
.mc
.P 0
.mc |
.nf
.ft CW
1 (0)   MODULE example VERSION = 'X-1'
.fi
.ft R
.mc
.P 0
The number in parentheses designates which file the source line was read
from.  By looking at the file summary at the end of the listing, you will
see that file (0) is 
.mc |
a.uil.
.mc
The first number
on the source line is the line number within the source file.
.P 0
If a source line contains any control characters other than tabs, they are
.mc |
replaced in the listing by ? (question marks).
.mc
.H 3 "Diagnostics"
.P 0
Diagnostics for a particular source line follow that line in the listing.
.P 0
.mc |
.nf
.S -2
.in0
.ft CW
2 (1)   VALUE red: COLOR( 1 );  VALUE green: COLOR( 2 );  
               1                         2
.mc
Error:  (1) found integer value when expecting string value
Error:  (2) found integer value when expecting string value
    8 (0)                        { XmNforeground = pink;
                                                   1
Error:  (1) value PINK must be defined before this reference
Error:  (1) found error value when expecting color value
.mc |
.fi
.ft R
.S
.in
.mc
.P 0
The line following the source line points to the position in the source line
where each of the diagnostics occurred.  You can determine the position of
each diagnostic by looking at the number in parentheses that follows the 
diagnostic severity.  For example, diagnostic 1 for source line 2 is
at position (1), and diagnostic 2 for the same source line is at position (2).
.mc |
Both the diagnostics for source line 8 occur at position (1).  
.mc
.P 0
.mc |
.ne 1i
.mc
If a diagnostic has no associated position on the line, the position is 
given as (0).  If a diagnostic is not associated with a source line, it appears following
the last source line.  The summary diagnostic, which tallies the number of
diagnostics of each severity level, is an example of a diagnostic with no source
line association.
.H 3 "Summaries"
.P 0
.mc |
The following listing contains two summaries:
.mc
.P 0
.mc |
.nf
.ft CW
Info: (0) errors: 5 warnings: 0 informationals: 0
.mc
    file (0)    a.uil
    file (1)    colors.uil
.mc |
.fi
.ft R
.mc
.P 0
The first summary is in the form of a diagnostic that tallies the number
of error, warning, and informational diagnostics.
.P 0
The second summary lists the files that contributed to the UIL specification.
This list is useful in determining from which file a source line in the listing
was read.  A source line preceded by the sequence 532 (3) in the listing was
read from line 532 of file (3) in the summary list.
